/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jeecg.modules.htvideo.entity.HtJsfileInfo;
import org.jeecg.modules.htvideo.mapper.HtJsfileInfoMapper;
import org.jeecg.modules.htvideo.service.IHtJsfileInfoService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class HtJsfileInfoServiceImpl
extends ServiceImpl<HtJsfileInfoMapper, HtJsfileInfo>
implements IHtJsfileInfoService {
    @Value(value="${jeecg.path.upload}")
    private String uploadPath;

    @Override
    public HtJsfileInfo saveJsFile(MultipartFile file, String directoryId, String directoryName) {
        try {
            String id = UUID.randomUUID().toString().replace("-", "");
            String fileName = file.getOriginalFilename();
            if (directoryName == null) {
                throw new RuntimeException("Directory name is required");
            }
            String jsDir = this.uploadPath + "/advjs/" + directoryName;
            File dir = new File(jsDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String filePath = jsDir + "/" + fileName;
            File destFile = new File(filePath);
            file.transferTo(destFile);
            String fileUrl = directoryName + "/" + fileName;
            long size = file.getSize();
            HtJsfileInfo info = new HtJsfileInfo();
            info.setId(id);
            info.setName(fileName);
            info.setDirectoryId(directoryId);
            info.setFileUrl(fileUrl);
            info.setSize(size);
            info.setCreateTime(new Date());
            this.save(info);
            return info;
        }
        catch (Exception e) {
            this.log.error("Failed to save JS file", (Throwable)e);
            throw new RuntimeException("Failed to save JS file: " + e.getMessage());
        }
    }

    @Override
    public List<HtJsfileInfo> listByDirectoryId(String directoryId) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(HtJsfileInfo::getDirectoryId, (Object)directoryId)).list();
    }

    @Override
    public String readJsFileContent(String id) {
        HtJsfileInfo jsfileInfo = (HtJsfileInfo)this.getById((Serializable)((Object)id));
        if (jsfileInfo == null) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            String filePath = this.uploadPath + "/advjs/" + jsfileInfo.getFileUrl();
            return new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.log.error("\u8bfb\u53d6JS\u6587\u4ef6\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25: " + e.getMessage());
        }
    }

    @Override
    public void saveJsFileContent(String id, String content) {
        HtJsfileInfo jsfileInfo = (HtJsfileInfo)this.getById((Serializable)((Object)id));
        if (jsfileInfo == null) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            String filePath = this.uploadPath + "/advjs/" + jsfileInfo.getFileUrl();
            Files.write(Paths.get(filePath, new String[0]), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            this.log.error("\u4fdd\u5b58JS\u6587\u4ef6\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9\u5931\u8d25: " + e.getMessage());
        }
    }
}

