/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RestUtil;
import org.jeecg.modules.htvideo.controller.ApiConfig;
import org.jeecg.modules.htvideo.controller.BaseController;
import org.jeecg.modules.htvideo.dto.SiteGroupDTO;
import org.jeecg.modules.htvideo.entity.HostSslReplaceRecord;
import org.jeecg.modules.htvideo.entity.HtCloudFlareRecord;
import org.jeecg.modules.htvideo.entity.HtJumpDomains;
import org.jeecg.modules.htvideo.entity.HtSiteGroup;
import org.jeecg.modules.htvideo.groups.UpdateGroup;
import org.jeecg.modules.htvideo.service.IHostSslReplaceRecordService;
import org.jeecg.modules.htvideo.service.IHtCloudFlareRecordService;
import org.jeecg.modules.htvideo.service.IHtJumpDomainsService;
import org.jeecg.modules.htvideo.service.IHtSiteGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u7ad9\u5206\u7ec4\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ht/sitegroup"})
public class HtSiteGroupController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(HtSiteGroupController.class);
    @Autowired
    private IHtSiteGroupService htSiteGroupService;
    @Autowired
    private IHtJumpDomainsService htJumpDomainsService;
    @Autowired
    private IHtCloudFlareRecordService htCloudFlareRecordService;
    @Autowired
    private IHostSslReplaceRecordService hostSslReplaceRecordService;
    @Value(value="${jeecg.path.webapp}")
    protected String jsPath;

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<IPage<HtSiteGroup>> queryPageList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="channelName", required=false) String channelName, @RequestParam(name="siteName", required=false) String siteName, @RequestParam(name="domainName", required=false) String domainName) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<HtSiteGroup> pageList = this.htSiteGroupService.querySiteGroupList((Page<HtSiteGroup>)page, channelName, siteName, domainName);
        return Result.OK(pageList);
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u6dfb\u52a0", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<HtSiteGroup> add(@RequestBody @Validated SiteGroupDTO siteGroupDTO) {
        HtSiteGroup htSiteGroup = new HtSiteGroup();
        BeanUtils.copyProperties((Object)siteGroupDTO, (Object)htSiteGroup);
        String originalDomainName = htSiteGroup.getDomainName();
        CharSequence[] domains = new String[]{};
        if (originalDomainName != null && !originalDomainName.isEmpty()) {
            domains = originalDomainName.split("\\s*\\R\\s*");
            String commaSeparatedDomains = String.join((CharSequence)",", domains);
            htSiteGroup.setDomainName(commaSeparatedDomains);
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        htSiteGroup.setCreateTime(new Date());
        htSiteGroup.setCreateBy(sysUser.getUsername());
        htSiteGroup.setUpdateTime(new Date());
        htSiteGroup.setUpdateBy(sysUser.getUsername());
        this.htSiteGroupService.save(htSiteGroup);
        if (domains.length > 0) {
            for (CharSequence domain : domains) {
                HtCloudFlareRecord cloudFlareRecord;
                long _count2;
                long _count;
                CharSequence host = "";
                int port = 80;
                if (((String)domain).contains(":")) {
                    String[] parts = ((String)domain).split(":");
                    host = parts[0];
                    try {
                        port = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    host = domain;
                }
                if ((_count = this.htJumpDomainsService.count((Wrapper)new QueryWrapper().eq((Object)"domain", (Object)host))) == 0L) {
                    HtJumpDomains htJumpDomains = new HtJumpDomains();
                    htJumpDomains.setDomain((String)host);
                    htJumpDomains.setPort(port);
                    htJumpDomains.setChannelId(htSiteGroup.getId().toString());
                    htJumpDomains.setUsefull(1);
                    this.htJumpDomainsService.save(htJumpDomains);
                }
                if ((_count2 = this.hostSslReplaceRecordService.count((Wrapper)new QueryWrapper().eq((Object)"host", (Object)host))) != 0L || (cloudFlareRecord = (HtCloudFlareRecord)this.htCloudFlareRecordService.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)htSiteGroup.getCloudFlare()))) == null) continue;
                HostSslReplaceRecord hostSslReplaceRecord = new HostSslReplaceRecord();
                hostSslReplaceRecord.setHost((String)host);
                hostSslReplaceRecord.setCfAccountId(cloudFlareRecord.getCfAccountId());
                hostSslReplaceRecord.setCfApiKey(cloudFlareRecord.getCfApiKey());
                hostSslReplaceRecord.setCfToken(cloudFlareRecord.getCfToken());
                hostSslReplaceRecord.setZerosslApi(cloudFlareRecord.getZerosslApi());
                this.hostSslReplaceRecordService.save(hostSslReplaceRecord);
            }
        }
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)htSiteGroup);
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u7f16\u8f91", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<HtSiteGroup> edit(@RequestBody @Validated(value={UpdateGroup.class}) SiteGroupDTO siteGroupDTO) {
        HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById(siteGroupDTO.getId());
        if (htSiteGroup == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f");
        }
        String originalDomainName = siteGroupDTO.getDomainName();
        CharSequence[] domains = new String[]{};
        if (originalDomainName != null && !originalDomainName.isEmpty()) {
            domains = originalDomainName.split("\\s*\\R\\s*");
            String commaSeparatedDomains = String.join((CharSequence)",", domains);
            htSiteGroup.setDomainName(commaSeparatedDomains);
        }
        BeanUtils.copyProperties((Object)siteGroupDTO, (Object)htSiteGroup, (String[])new String[]{"domainName"});
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        htSiteGroup.setUpdateTime(new Date());
        htSiteGroup.setUpdateBy(sysUser.getUsername());
        this.htSiteGroupService.updateById(htSiteGroup);
        if (domains.length > 0) {
            for (CharSequence domain : domains) {
                HtCloudFlareRecord cloudFlareRecord;
                long _count2;
                long _count;
                CharSequence host = "";
                int port = 80;
                if (((String)domain).contains(":")) {
                    String[] parts = ((String)domain).split(":");
                    host = parts[0];
                    try {
                        port = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("\u7aef\u53e3\u683c\u5f0f\u9519\u8bef");
                    }
                } else {
                    host = domain;
                }
                if ((_count = this.htJumpDomainsService.count((Wrapper)new QueryWrapper().eq((Object)"domain", (Object)host))) == 0L) {
                    HtJumpDomains htJumpDomains = new HtJumpDomains();
                    htJumpDomains.setDomain((String)host);
                    htJumpDomains.setPort(port);
                    htJumpDomains.setChannelId(htSiteGroup.getId().toString());
                    htJumpDomains.setUsefull(1);
                    this.htJumpDomainsService.save(htJumpDomains);
                }
                if ((_count2 = this.hostSslReplaceRecordService.count((Wrapper)new QueryWrapper().eq((Object)"host", (Object)domain))) != 0L || (cloudFlareRecord = (HtCloudFlareRecord)this.htCloudFlareRecordService.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)htSiteGroup.getCloudFlare()))) == null) continue;
                HostSslReplaceRecord hostSslReplaceRecord = new HostSslReplaceRecord();
                hostSslReplaceRecord.setHost((String)domain);
                hostSslReplaceRecord.setCfAccountId(cloudFlareRecord.getCfAccountId());
                hostSslReplaceRecord.setCfApiKey(cloudFlareRecord.getCfApiKey());
                hostSslReplaceRecord.setCfToken(cloudFlareRecord.getCfToken());
                hostSslReplaceRecord.setZerosslApi(cloudFlareRecord.getZerosslApi());
                this.hostSslReplaceRecordService.save(hostSslReplaceRecord);
            }
        }
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!", (Object)htSiteGroup);
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        this.htSiteGroupService.removeById(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/queryById"})
    public Result<HtSiteGroup> queryById(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById(id);
        if (htSiteGroup == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f");
        }
        return Result.OK((Object)htSiteGroup);
    }

    @ApiOperation(value="\u751f\u6210hm.js\u548cconf.js", notes="\u6839\u636eid\u751f\u6210js\u6587\u4ef6")
    @PostMapping(value={"/generateJsFile"})
    public Result<?> generateJsFile(@RequestBody Map<String, Integer> params) {
        Integer id = params.get("id");
        if (id == null) {
            return Result.error((String)"\u7f3a\u5c11\u53c2\u6570id");
        }
        HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById(id);
        if (htSiteGroup == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f");
        }
        String domainName = htSiteGroup.getDomainName();
        String statisticsCode = htSiteGroup.getStatisticsCode();
        Integer cid = htSiteGroup.getId();
        String siteName = htSiteGroup.getSiteName();
        if (StringUtils.isNotBlank((String)domainName)) {
            String[] domainList;
            for (String domain : domainList = domainName.split(",")) {
                if (!StringUtils.isNotBlank((String)domain)) continue;
                String baseDir = this.jsPath + "/" + (domain = domain.replace(":", "-"));
                File dir = new File(baseDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File hmHtml = new File(dir, "hm.html");
                try (FileWriter writer = new FileWriter(hmHtml, false);){
                    writer.write(statisticsCode != null ? statisticsCode : "");
                }
                catch (IOException e) {
                    log.error("\u751f\u6210\u6e20\u9053[{}]\u7684hm.html\u5931\u8d25", (Object)siteName, (Object)e);
                    return Result.error((String)("\u751f\u6210hm.html\u5931\u8d25: " + e.getMessage()));
                }
                File confJs = new File(dir, "conf.js");
                try (FileWriter writer = new FileWriter(confJs, false);){
                    writer.write("var __xyz_cid_=\"" + cid + "\";");
                    writer.write("var __xyz_sn_=\"" + siteName + "\";");
                }
                catch (IOException e) {
                    return Result.error((String)("\u751f\u6210conf.js\u5931\u8d25: " + e.getMessage()));
                }
            }
        }
        return Result.OK((String)"\u751f\u6210js\u6587\u4ef6\u6210\u529f\uff01");
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u67e5\u8be2\u5168\u90e8")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u67e5\u8be2\u5168\u90e8", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u67e5\u8be2\u5168\u90e8")
    @PostMapping(value={"/listAll"})
    public Result<List<HtSiteGroup>> queryAllList(@RequestParam(name="channelName", required=false) String channelName, @RequestParam(name="siteName", required=false) String siteName, @RequestParam(name="domainName", required=false) String domainName) {
        HtSiteGroup record = new HtSiteGroup();
        record.setChannelName(channelName);
        record.setSiteName(siteName);
        record.setDomainName(domainName);
        QueryWrapper queryWrapper = new QueryWrapper((Object)record);
        List list = this.htSiteGroupService.list((Wrapper)queryWrapper);
        return Result.OK((Object)list);
    }
}

