/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.htvideo.entity.HtFileDirectory;
import org.jeecg.modules.htvideo.entity.HtJsfileInfo;
import org.jeecg.modules.htvideo.service.IHtFileDirectoryService;
import org.jeecg.modules.htvideo.service.IHtJsfileInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/ht/jsadvfile"})
public class HtJsAdvFileController {
    private static final Logger log = LoggerFactory.getLogger(HtJsAdvFileController.class);
    @Value(value="${ht.syncPath}")
    protected String syncPath;
    @Value(value="${jeecg.path.upload}")
    protected String jsPath;
    private static final String SEARCH_KEY_FILENAME = "sk.txt";
    private static final String REPLACE_DOMAIN_CONF = "replace_host.txt";
    @Autowired
    private IHtFileDirectoryService fileDirectoryService;
    @Autowired
    private IHtJsfileInfoService jsfileInfoService;

    @AutoLog(value="\u5e7f\u544ajs\u76ee\u5f55\u521b\u5efa")
    @ApiOperation(value="\u5e7f\u544ajs\u76ee\u5f55\u521b\u5efa", notes="\u5e7f\u544ajs\u76ee\u5f55\u521b\u5efa")
    @PostMapping(value={"/directory/create"})
    public Result<HtFileDirectory> createDirectory(@RequestBody HtFileDirectory directory) {
        this.fileDirectoryService.save(directory);
        return Result.OK((String)"\u76ee\u5f55\u521b\u5efa\u6210\u529f", (Object)directory);
    }

    @GetMapping(value={"/directory/tree"})
    public Result<List<HtFileDirectory>> getDirectoryTree() {
        List<HtFileDirectory> tree = this.fileDirectoryService.getDirectoryTree();
        return Result.OK(tree);
    }

    @DeleteMapping(value={"/directory/delete"})
    public Result<?> deleteDirectory(@RequestBody Map<String, String> params) {
        String id = params.get("id");
        this.fileDirectoryService.deleteDirectoryWithChildren(id);
        return Result.OK((String)"\u76ee\u5f55\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/jsfile/upload"})
    public Result<HtJsfileInfo> uploadJsFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="directoryId") String directoryId) {
        HtFileDirectory directory = (HtFileDirectory)this.fileDirectoryService.getById((Serializable)((Object)directoryId));
        if (directory == null) {
            return Result.error((String)"Directory does not exist");
        }
        HtJsfileInfo jsfileInfo = this.jsfileInfoService.saveJsFile(file, directoryId, directory.getName());
        return Result.OK((String)"File uploaded successfully", (Object)jsfileInfo);
    }

    @GetMapping(value={"/jsfile/list"})
    public Result<List<HtJsfileInfo>> listJsFiles(@RequestParam(value="directoryId") String directoryId) {
        List<HtJsfileInfo> files = this.jsfileInfoService.listByDirectoryId(directoryId);
        return Result.OK(files);
    }

    @DeleteMapping(value={"/jsfile/delete"})
    public Result<?> deleteJsFile(@RequestBody Map<String, String> params) {
        String id = params.get("id");
        this.jsfileInfoService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u6587\u4ef6\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/jsfile/modifyName"})
    public Result<?> modifyName(@RequestBody Map<String, String> params) {
        String id = params.get("id");
        String newName = params.get("name");
        HtJsfileInfo jsfileInfo = (HtJsfileInfo)this.jsfileInfoService.getById((Serializable)((Object)id));
        if (jsfileInfo == null) {
            return Result.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        jsfileInfo.setName(newName);
        this.jsfileInfoService.updateById(jsfileInfo);
        return Result.OK((String)"\u6587\u4ef6\u540d\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/sync"})
    @ApiOperation(value="\u6267\u884c\u540c\u6b65\u811a\u672c", notes="\u7269\u7406\u673a\u76ee\u5f55\u4e0b\u7684sync.sh\u811a\u672c")
    @AutoLog(value="\u6267\u884c\u540c\u6b65\u811a\u672c")
    public Result<?> executeSync() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", this.syncPath + "sync.sh");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return Result.OK((String)"\u540c\u6b65\u811a\u672c\u6267\u884c\u7ed3\u675f");
            }
            log.error("\u540c\u6b65\u811a\u672c\u6267\u884c\u5931\u8d25\uff0c\u9000\u51fa\u7801: {}", (Object)exitCode);
            return Result.error((String)"\u540c\u6b65\u811a\u672c\u6267\u884c\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u540c\u6b65\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            return Result.error((String)"\u6267\u884c\u540c\u6b65\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef");
        }
    }

    @GetMapping(value={"/jsfile/content"})
    @ApiOperation(value="\u8bfb\u53d6JS\u6587\u4ef6\u5185\u5bb9", notes="\u6839\u636e\u6587\u4ef6ID\u8bfb\u53d6JS\u6587\u4ef6\u5185\u5bb9")
    @AutoLog(value="\u8bfb\u53d6JS\u6587\u4ef6\u5185\u5bb9")
    public Result<String> getJsFileContent(@RequestParam(value="id") String id) {
        HtJsfileInfo jsfileInfo = (HtJsfileInfo)this.jsfileInfoService.getById((Serializable)((Object)id));
        if (jsfileInfo == null) {
            return Result.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        String content = this.jsfileInfoService.readJsFileContent(id);
        return Result.OK((String)"", (Object)content);
    }

    @PostMapping(value={"/jsfile/content"})
    @ApiOperation(value="\u4fdd\u5b58JS\u6587\u4ef6\u5185\u5bb9", notes="\u4fdd\u5b58JS\u6587\u4ef6\u7684\u7f16\u8f91\u5185\u5bb9")
    @AutoLog(value="\u4fdd\u5b58JS\u6587\u4ef6\u5185\u5bb9")
    public Result<?> saveJsFileContent(@RequestBody Map<String, String> params) {
        String id = params.get("id");
        String content = params.get("content");
        if (id == null || content == null) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        HtJsfileInfo jsfileInfo = (HtJsfileInfo)this.jsfileInfoService.getById((Serializable)((Object)id));
        if (jsfileInfo == null) {
            return Result.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.jsfileInfoService.saveJsFileContent(id, content);
        return Result.OK((String)"\u6587\u4ef6\u5185\u5bb9\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/listAllQdFiles"})
    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u76ee\u5f55\u53ca\u6587\u4ef6", notes="\u67e5\u8be2\u5168\u90e8\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u76ee\u5f55\u53ca\u6587\u4ef6")
    @AutoLog(value="\u67e5\u8be2\u5168\u90e8\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u76ee\u5f55\u53ca\u6587\u4ef6")
    public Result<?> listAllQdFiles() {
        Path rootPath = Paths.get(this.jsPath, new String[0]);
        Path target = rootPath.resolve("qdad").normalize();
        if (!Files.exists(target, new LinkOption[0]) || !Files.isDirectory(target, new LinkOption[0])) {
            return Result.error((String)"\u8def\u5f84\u65e0\u6548");
        }
        try {
            List result;
            try (Stream<Path> stream = Files.walk(target, new FileVisitOption[0]);){
                result = stream.filter(p -> !p.equals(target)).map(p -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("name", p.getFileName().toString());
                    map.put("isDirectory", Files.isDirectory(p, new LinkOption[0]));
                    map.put("path", rootPath.relativize((Path)p).toString().replace("\\", "/"));
                    return map;
                }).collect(Collectors.toList());
            }
            return Result.ok(result);
        }
        catch (IOException e) {
            return Result.error((String)"\u8bfb\u53d6\u76ee\u5f55\u5931\u8d25");
        }
    }

    @PostMapping(value={"/deleteAdDirectory"})
    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u76ee\u5f55\u7684\u5168\u90e8\u5185\u5bb9", notes="\u5220\u9664\u6307\u5b9a\u76ee\u5f55\u7684\u5168\u90e8\u5185\u5bb9")
    @AutoLog(value="\u5220\u9664\u6307\u5b9a\u76ee\u5f55\u7684\u5168\u90e8\u5185\u5bb9")
    public Result<?> deleteAdDirectory(@RequestBody Map<String, String> params) {
        String path = params.get("path");
        if (path == null || path.isEmpty()) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11 path");
        }
        Path targetPath = Paths.get(this.jsPath, new String[0]).resolve(path).normalize();
        try {
            if (!Files.exists(targetPath, new LinkOption[0]) || !Files.isDirectory(targetPath, new LinkOption[0])) {
                return Result.error((String)"\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
            Files.walk(targetPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return Result.ok((String)"\u76ee\u5f55\u5220\u9664\u6210\u529f");
        }
        catch (IOException e) {
            return Result.error((String)("\u5220\u9664\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/deleteAdFile"})
    @ApiOperation(value="\u5220\u9664\u6587\u4ef6", notes="\u5220\u9664\u6587\u4ef6")
    @AutoLog(value="\u5220\u9664\u6587\u4ef6")
    public Result<?> deleteAdFile(@RequestBody Map<String, String> params) {
        String path = params.get("path");
        if (path == null || path.isEmpty()) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11 path");
        }
        Path targetPath = Paths.get(this.jsPath, new String[0]).resolve(path).normalize();
        try {
            if (!Files.exists(targetPath, new LinkOption[0]) || Files.isDirectory(targetPath, new LinkOption[0])) {
                return Result.error((String)"\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u662f\u76ee\u5f55");
            }
            Files.delete(targetPath);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (IOException e) {
            return Result.error((String)("\u5220\u9664\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/getAdFileContent"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9", notes="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @AutoLog(value="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    public Result<?> getAdFileContent(@RequestBody Map<String, String> params) {
        String path = params.get("path");
        if (path == null || path.isEmpty()) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11 path");
        }
        Path filePath = Paths.get(this.jsPath, new String[0]).resolve(path).normalize();
        if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
            return Result.error((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u662f\u76ee\u5f55");
        }
        try {
            String content = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
            return Result.ok((String)content);
        }
        catch (IOException e) {
            return Result.error((String)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/editAdFile"})
    @ApiOperation(value="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9", notes="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9")
    @AutoLog(value="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9")
    public Result<?> editAdFile(@RequestBody Map<String, String> params) {
        String path = params.get("path");
        String content = params.get("content");
        if (path == null || path.isEmpty()) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11 path");
        }
        Path filePath = Paths.get(this.jsPath, new String[0]).resolve(path).normalize();
        try {
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.createFile(filePath, new FileAttribute[0]);
            }
            Files.write(filePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return Result.ok((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (IOException e) {
            return Result.error((String)("\u4fdd\u5b58\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/createAdDirectory"})
    @ApiOperation(value="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9", notes="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9")
    @AutoLog(value="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9")
    public Result<?> createAdDirectory(@RequestBody Map<String, String> params) {
        String pathParam = params.get("path");
        if (pathParam == null || pathParam.isEmpty()) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11 path");
        }
        String targetPath = this.jsPath + "/" + pathParam;
        File dir = new File(targetPath);
        if (dir.exists()) {
            return Result.ok((String)"\u76ee\u5f55\u5df2\u5b58\u5728");
        }
        boolean created = dir.mkdirs();
        if (created) {
            return Result.ok((String)"\u76ee\u5f55\u521b\u5efa\u6210\u529f");
        }
        return Result.error((String)"\u76ee\u5f55\u521b\u5efa\u5931\u8d25\uff1a\u53ef\u80fd\u6ca1\u6709\u6743\u9650\u6216\u8def\u5f84\u65e0\u6548");
    }

    @PostMapping(value={"/uploadAdFile"})
    public Result<?> uploadAdFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="path", required=false) String pathParam) {
        if (file.isEmpty()) {
            return Result.error((String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (pathParam == null || pathParam.isEmpty()) {
            return Result.error((String)"\u672a\u9009\u62e9\u4e0a\u4f20\u7684\u76ee\u5f55");
        }
        Path basePath = Paths.get(this.jsPath, new String[0]);
        Path targetDir = basePath.resolve(pathParam).normalize();
        if (!Files.exists(targetDir, new LinkOption[0])) {
            return Result.error((String)"\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        try {
            Path targetFile = targetDir.resolve(file.getOriginalFilename()).normalize();
            Files.copy(file.getInputStream(), targetFile, StandardCopyOption.REPLACE_EXISTING);
            return Result.ok((String)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.error((String)("\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private Path resolveZipEntry(Path targetDir, String entryName) {
        return targetDir.resolve(entryName).normalize();
    }

    @PostMapping(value={"/uploadAdZip"})
    public Result<?> uploadAdZip(@RequestParam(value="file") MultipartFile file, @RequestParam(value="path") String pathParam) {
        if (file.isEmpty()) {
            return Result.error((String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (pathParam == null || pathParam.trim().isEmpty()) {
            return Result.error((String)"\u672a\u6307\u5b9a\u4e0a\u4f20\u7684\u76ee\u6807\u76ee\u5f55");
        }
        String contentType = file.getContentType();
        if (!"application/zip".equalsIgnoreCase(contentType) && !"application/x-zip-compressed".equalsIgnoreCase(contentType)) {
            return Result.error((String)"\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20ZIP\u683c\u5f0f\u7684\u538b\u7f29\u5305");
        }
        Path basePath = Paths.get(this.jsPath, new String[0]);
        Path targetDir = basePath.resolve(pathParam).normalize();
        if (!targetDir.startsWith(basePath)) {
            return Result.error((String)"\u975e\u6cd5\u7684\u76ee\u6807\u76ee\u5f55\u8def\u5f84");
        }
        try {
            if (!Files.exists(targetDir, new LinkOption[0])) {
                return Result.error((String)"\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
            try (ZipInputStream zis = new ZipInputStream(file.getInputStream());){
                ZipEntry zipEntry;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    Path newPath = this.resolveZipEntry(targetDir, zipEntry.getName());
                    if (!newPath.startsWith(targetDir)) {
                        throw new IOException("ZIP\u6587\u4ef6\u4e2d\u5305\u542b\u65e0\u6548\u7684\u8def\u5f84 (Zip Slip): " + zipEntry.getName());
                    }
                    if (zipEntry.isDirectory()) {
                        Files.createDirectories(newPath, new FileAttribute[0]);
                    } else {
                        Path parent = newPath.getParent();
                        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    zis.closeEntry();
                }
            }
            return Result.ok((String)"\u4e0a\u4f20\u5e76\u89e3\u538b\u6210\u529f");
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6216\u89e3\u538b\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.error((String)("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/searchkey/content"})
    @ApiOperation(value="\u8bfb\u53d6\u641c\u7d22\u5173\u952e\u5b57\u6587\u4ef6\u5185\u5bb9", notes="\u6839\u636e\u6587\u4ef6ID\u8bfb\u53d6\u641c\u7d22\u5173\u952e\u5b57\u6587\u4ef6\u5185\u5bb9")
    @AutoLog(value="\u8bfb\u53d6\u641c\u7d22\u5173\u952e\u5b57\u6587\u4ef6\u5185\u5bb9")
    public Result<String> getSearchkeyContent() {
        Path basePath = Paths.get(this.jsPath, new String[0]);
        Path targetDir = basePath.resolve("advjs").normalize();
        if (!targetDir.startsWith(basePath)) {
            return Result.error((String)"\u975e\u6cd5\u7684\u76ee\u6807\u76ee\u5f55\u8def\u5f84");
        }
        Path filePath = targetDir.resolve(SEARCH_KEY_FILENAME);
        log.info("\u5c1d\u8bd5\u8bfb\u53d6\u6587\u4ef6: {}", (Object)filePath);
        try {
            if (!Files.exists(filePath, new LinkOption[0])) {
                log.info("\u6587\u4ef6 {} \u4e0d\u5b58\u5728\uff0c\u8fd4\u56de\u7a7a\u5185\u5bb9", (Object)filePath);
                return Result.OK((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de\u7a7a\u5185\u5bb9", (Object)"");
            }
            String content = Files.readString(filePath, StandardCharsets.UTF_8);
            return Result.OK((String)"\u6587\u4ef6\u5185\u5bb9\u8bfb\u53d6\u6210\u529f", (Object)content);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
            return Result.error((String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1a\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
    }

    @PostMapping(value={"/searchkey/content"})
    @ApiOperation(value="\u4fdd\u5b58\u641c\u7d22\u5173\u952e\u5b57\u6587\u4ef6\u5185\u5bb9", notes="\u4fdd\u5b58\u641c\u7d22\u5173\u952e\u5b57\u6587\u4ef6\u7684\u7f16\u8f91\u5185\u5bb9")
    @AutoLog(value="\u4fdd\u5b58\u641c\u7d22\u5173\u952e\u5b57\u6587\u4ef6\u5185\u5bb9")
    public Result<?> saveSearchkeyContent(@RequestBody Map<String, String> params) {
        String content = params.get("content");
        if (content == null) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        Path basePath = Paths.get(this.jsPath, new String[0]);
        Path targetDir = basePath.resolve("advjs").normalize();
        if (!targetDir.startsWith(basePath)) {
            return Result.error((String)"\u975e\u6cd5\u7684\u76ee\u6807\u76ee\u5f55\u8def\u5f84");
        }
        Path filePath = targetDir.resolve(SEARCH_KEY_FILENAME);
        try {
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                log.info("\u76ee\u5f55 {} \u4e0d\u5b58\u5728\uff0c\u5df2\u521b\u5efa\u3002", (Object)targetDir);
            }
            Files.writeString(filePath, (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            return Result.OK((String)"\u6587\u4ef6\u5185\u5bb9\u4fdd\u5b58\u6210\u529f");
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
            return Result.error((String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1a\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @PostMapping(value={"/domainreplace/save"})
    @ApiOperation(value="\u4fdd\u5b58\u57df\u540d\u66ff\u6362\u914d\u7f6e", notes="\u4fdd\u5b58\u57df\u540d\u66ff\u6362\u914d\u7f6e")
    @AutoLog(value="\u4fdd\u5b58\u57df\u540d\u66ff\u6362\u914d\u7f6e")
    public Result<?> saveReplaceDomainConf(@RequestBody Map<String, String> params) {
        String oldhost = params.get("oldhost").toString();
        String newhost = params.get("newhost").toString();
        if (oldhost == null || oldhost == "" || newhost == null || newhost == "") {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        Path basePath = Paths.get(this.syncPath, new String[0]);
        Path parentDir = basePath.getParent();
        Path targetDir = parentDir.resolve("conf");
        if (!targetDir.startsWith(parentDir)) {
            return Result.error((String)"\u975e\u6cd5\u7684\u76ee\u6807\u76ee\u5f55\u8def\u5f84");
        }
        Path filePath = targetDir.resolve(REPLACE_DOMAIN_CONF);
        try {
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                log.info("\u76ee\u5f55 {} \u4e0d\u5b58\u5728\uff0c\u5df2\u521b\u5efa\u3002", (Object)targetDir);
            }
            Files.writeString(filePath, (CharSequence)(oldhost + " " + newhost), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            return Result.OK((String)"\u6587\u4ef6\u5185\u5bb9\u4fdd\u5b58\u6210\u529f");
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
            return Result.error((String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1a\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
        }
    }
}

