/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.htvideo.entity.HtImgRes;
import org.jeecg.modules.htvideo.service.IHtImgResService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/ht/imgres"})
public class HtImgResController {
    private static final Logger log = LoggerFactory.getLogger(HtImgResController.class);
    @Value(value="${ht.syncPath}")
    protected String syncPath;
    @Value(value="${jeecg.path.upload}")
    protected String resPath;
    @Autowired
    private IHtImgResService htImgResService;
    final byte XOR_KEY = (byte)-120;

    String imageToBase64(String imagePath, String site) {
        String string;
        File file = new File(imagePath);
        FileInputStream imageInFile = new FileInputStream(file);
        try {
            byte[] imageData = new byte[(int)file.length()];
            imageInFile.read(imageData);
            imageData = site.equals("ht") ? this.xorEncrypt(imageData, (byte)-120) : HtImgResController.reverseBytes(imageData);
            string = Base64.getEncoder().encodeToString(imageData);
        }
        catch (Throwable throwable) {
            try {
                try {
                    imageInFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        imageInFile.close();
        return string;
    }

    private String formatFileSize(long sizeInBytes) {
        if (sizeInBytes < 1024L) {
            return sizeInBytes + " B";
        }
        if (sizeInBytes < 0x100000L) {
            return String.format("%.2f KB", (double)sizeInBytes / 1024.0);
        }
        if (sizeInBytes < 0x40000000L) {
            return String.format("%.2f MB", (double)sizeInBytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)sizeInBytes / 1.073741824E9);
    }

    private String md5Hex(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(data);
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    private byte[] xorEncrypt(byte[] data, byte key) {
        byte[] encrypted = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            encrypted[i] = (byte)(data[i] ^ key);
        }
        return encrypted;
    }

    public static byte[] reverseBytes(byte[] data) {
        int len = data.length;
        byte[] reversed = new byte[len];
        for (int i = 0; i < len; ++i) {
            reversed[i] = data[len - 1 - i];
        }
        return reversed;
    }

    @AutoLog(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<?> list(@RequestBody Map<String, Object> params) {
        Page page = new Page((long)Integer.parseInt(params.getOrDefault("pageNo", 1).toString()), (long)Integer.parseInt(params.getOrDefault("pageSize", 10).toString()));
        QueryWrapper queryWrapper = new QueryWrapper();
        if (params.get("imgType") != null) {
            queryWrapper.like((Object)"img_type", params.get("imgType"));
        }
        if (params.get("imgMd5") != null) {
            queryWrapper.like((Object)"img_md5", params.get("imgMd5"));
            queryWrapper.like((Object)"img_ori_name", params.get("imgMd5"));
        }
        queryWrapper.orderByDesc((Object)"img_created_at");
        IPage pageList = this.htImgResService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @PostMapping(value={"/add"})
    public Result<String> add(@RequestParam(value="file") MultipartFile file, @RequestParam Map<String, String> params) {
        HtImgRes htImgRes = new HtImgRes();
        String site = params.get("site");
        String imgType = params.get("imgType");
        String originalFilename = file.getOriginalFilename();
        htImgRes.setImgType(imgType);
        htImgRes.setImgOriName(originalFilename);
        htImgRes.setImgSize(this.formatFileSize(file.getSize()));
        Date dt = new Date();
        htImgRes.setImgCreatedAt(dt);
        Object filePath = "";
        try {
            String extension = "." + StringUtils.getFilenameExtension((String)originalFilename);
            byte[] fileBytes = file.getBytes();
            String md5Raw = this.md5Hex(fileBytes);
            Object finalFileName = this.md5Hex((md5Raw + System.currentTimeMillis()).getBytes());
            if (site.equals("ht")) {
                fileBytes = this.xorEncrypt(fileBytes, (byte)-120);
                finalFileName = (String)finalFileName + "_xfile";
            } else {
                fileBytes = HtImgResController.reverseBytes(fileBytes);
                finalFileName = (String)finalFileName + "_r";
            }
            htImgRes.setImgMd5((String)finalFileName);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = sdf.format(dt);
            Path dir = Paths.get(this.resPath, imgType, dateStr);
            Files.createDirectories(dir, new FileAttribute[0]);
            filePath = "/" + imgType + "/" + dateStr + "/" + (String)finalFileName + extension;
            Files.write(dir.resolve((String)finalFileName + extension), fileBytes, new OpenOption[0]);
            this.htImgResService.save(htImgRes);
        }
        catch (IOException e) {
            return Result.error((String)"\u6587\u4ef6\u5b58\u50a8\u5931\u8d25");
        }
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)filePath);
    }

    @PostMapping(value={"/delete"})
    public Result<String> delete(@RequestBody Map<String, Object> params) {
        String id = params.get("id").toString();
        HtImgRes htImgRes = (HtImgRes)this.htImgResService.getById((Serializable)((Object)id));
        if (htImgRes != null) {
            try {
                String originalFilename = htImgRes.getImgOriName();
                String extension = "." + StringUtils.getFilenameExtension((String)originalFilename);
                Date dt = htImgRes.getImgCreatedAt();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = sdf.format(dt);
                String filePathString = this.resPath + "/" + htImgRes.getImgType() + "/" + dateStr + "/" + htImgRes.getImgMd5() + extension;
                Files.deleteIfExists(Paths.get(filePathString, new String[0]));
            }
            catch (IOException e) {
                return Result.error((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25");
            }
            this.htImgResService.removeById((Serializable)((Object)id));
        }
        return Result.OK((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/preview"})
    public Result<String> preview(@RequestBody Map<String, Object> params) {
        String id = params.get("id").toString();
        String site = params.get("site").toString();
        HtImgRes htImgRes = (HtImgRes)this.htImgResService.getById((Serializable)((Object)id));
        if (htImgRes != null) {
            try {
                String originalFilename = htImgRes.getImgOriName();
                String extension = "." + StringUtils.getFilenameExtension((String)originalFilename);
                Date dt = htImgRes.getImgCreatedAt();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String dateStr = sdf.format(dt);
                String filePathString = this.resPath + "/" + htImgRes.getImgType() + "/" + dateStr + "/" + htImgRes.getImgMd5() + extension;
                return Result.OK((String)"", (Object)this.imageToBase64(filePathString, site));
            }
            catch (Exception e) {
                return Result.error((String)"\u6587\u4ef6\u9884\u89c8\u5931\u8d25");
            }
        }
        return Result.error((String)"\u6587\u4ef6\u9884\u89c8\u5931\u8d25");
    }

    @PostMapping(value={"/previewbyurl"})
    public Result<String> previewByUrl(@RequestBody Map<String, Object> params) {
        String site = params.get("site").toString();
        Object urlObject = params.get("url");
        if (!(urlObject instanceof String) || !StringUtils.hasText((String)((String)urlObject))) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef\uff1aurl\u5fc5\u987b\u4e3a\u975e\u7a7a\u5b57\u7b26\u4e32");
        }
        String url = (String)urlObject;
        String protocol = "n-res:upload/";
        if (!url.startsWith(protocol)) {
            return Result.error((String)"\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        String relativePathStr = url.substring(protocol.length());
        Path basePath = Paths.get(this.resPath, new String[0]);
        Path fullPath = basePath.resolve(relativePathStr).normalize();
        if (!fullPath.startsWith(basePath)) {
            log.warn("\u68c0\u6d4b\u5230\u6f5c\u5728\u7684\u8def\u5f84\u904d\u5386\u653b\u51fb: {}", (Object)url);
            return Result.error((String)"\u975e\u6cd5\u7684\u6587\u4ef6\u8def\u5f84");
        }
        try {
            String filePathString = fullPath.toString();
            return Result.OK((String)"", (Object)this.imageToBase64(filePathString, site));
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25, url: {}", (Object)url, (Object)e);
            return Result.error((String)"\u6587\u4ef6\u9884\u89c8\u5931\u8d25");
        }
    }

    @PostMapping(value={"/asyncres"})
    @ApiOperation(value="\u6267\u884c\u540c\u6b65\u811a\u672c", notes="\u7269\u7406\u673a\u76ee\u5f55\u4e0b\u7684sync.sh\u811a\u672c")
    @AutoLog(value="\u6267\u884c\u540c\u6b65\u811a\u672c")
    public Result<?> executeSync() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", this.syncPath + "rsync_res.sh");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return Result.OK((String)"\u540c\u6b65\u811a\u672c\u6267\u884c\u7ed3\u675f");
            }
            log.error("\u540c\u6b65\u811a\u672c\u6267\u884c\u5931\u8d25\uff0c\u9000\u51fa\u7801: {}", (Object)exitCode);
            return Result.error((String)"\u540c\u6b65\u811a\u672c\u6267\u884c\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u540c\u6b65\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            return Result.error((String)"\u6267\u884c\u540c\u6b65\u811a\u672c\u65f6\u53d1\u751f\u9519\u8bef");
        }
    }
}

