/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.LoginUser;
import org.springframework.beans.factory.annotation.Value;

public class BaseController {
    @Value(value="${ht.apiPath}")
    protected String apiPath;

    protected JSONObject baseBodyParams(Object params) {
        JSONObject json = new JSONObject();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        json.put("loginName", (Object)loginUser.getUsername());
        if (params != null) {
            if (params instanceof JSONObject) {
                Integer pageNo;
                json.putAll((Map)((JSONObject)params));
                if (json.containsKey((Object)"pageNo") && (pageNo = json.getInteger("pageNo")) != null && pageNo > 0) {
                    json.put("pageNo", (Object)(pageNo - 1));
                }
            } else {
                for (Class<?> currentClass = params.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = currentClass.getDeclaredFields()) {
                        field.setAccessible(true);
                        try {
                            Object value = field.get(params);
                            if (value == null) continue;
                            if ("pageNo".equals(field.getName()) && value instanceof Number) {
                                int pageNo = ((Number)value).intValue();
                                json.put("pageNo", (Object)(pageNo > 0 ? pageNo - 1 : 0));
                                continue;
                            }
                            json.put(field.getName(), value);
                        }
                        catch (IllegalAccessException e) {
                            throw new JeecgBootException("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
                        }
                    }
                }
            }
        }
        return json;
    }

    protected Result unPacking(JSONObject resp) {
        if (resp == null) {
            return Result.error((String)"\u8bf7\u6c42\u670d\u52a1\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        int code = resp.getInteger("code");
        String msg = resp.getString("msg");
        JSONObject data = resp.getJSONObject("data");
        if (code == 10000) {
            return Result.OK((Object)data);
        }
        return Result.error((String)msg);
    }

    protected <T> Result<IPage<T>> unPackingPage(JSONObject resp, String listKey, Class<T> clazz, long pageNo, long pageSize) {
        if (resp == null) {
            return Result.error((String)"\u8bf7\u6c42\u670d\u52a1\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        int code = resp.getInteger("code");
        String msg = resp.getString("msg");
        if (code != 10000) {
            return Result.error((String)msg);
        }
        JSONObject data = resp.getJSONObject("data");
        JSONArray listArray = data.getJSONArray(listKey);
        List records = JSON.parseArray((String)listArray.toJSONString(), clazz);
        long total = 10000L;
        Page page = new Page(pageNo, pageSize);
        page.setTotal(total);
        page.setRecords(records);
        Result result = new Result();
        result.setSuccess(true);
        result.setResult((Object)page);
        return result;
    }
}

