/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.demo.test.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jeecg.modules.demo.test.entity.JeecgOrderCustomer;
import org.jeecg.modules.demo.test.entity.JeecgOrderMain;
import org.jeecg.modules.demo.test.entity.JeecgOrderTicket;
import org.jeecg.modules.demo.test.mapper.JeecgOrderCustomerMapper;
import org.jeecg.modules.demo.test.mapper.JeecgOrderMainMapper;
import org.jeecg.modules.demo.test.mapper.JeecgOrderTicketMapper;
import org.jeecg.modules.demo.test.service.IJeecgOrderMainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JeecgOrderMainServiceImpl
extends ServiceImpl<JeecgOrderMainMapper, JeecgOrderMain>
implements IJeecgOrderMainService {
    @Autowired
    private JeecgOrderMainMapper jeecgOrderMainMapper;
    @Autowired
    private JeecgOrderCustomerMapper jeecgOrderCustomerMapper;
    @Autowired
    private JeecgOrderTicketMapper jeecgOrderTicketMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(JeecgOrderMain jeecgOrderMain, List<JeecgOrderCustomer> jeecgOrderCustomerList, List<JeecgOrderTicket> jeecgOrderTicketList) {
        this.jeecgOrderMainMapper.insert(jeecgOrderMain);
        if (jeecgOrderCustomerList != null) {
            for (JeecgOrderCustomer jeecgOrderCustomer : jeecgOrderCustomerList) {
                jeecgOrderCustomer.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderCustomerMapper.insert(jeecgOrderCustomer);
            }
        }
        if (jeecgOrderTicketList != null) {
            for (JeecgOrderTicket jeecgOrderTicket : jeecgOrderTicketList) {
                jeecgOrderTicket.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderTicketMapper.insert(jeecgOrderTicket);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMain(JeecgOrderMain jeecgOrderMain, List<JeecgOrderCustomer> jeecgOrderCustomerList, List<JeecgOrderTicket> jeecgOrderTicketList) {
        this.jeecgOrderMainMapper.updateById(jeecgOrderMain);
        this.jeecgOrderTicketMapper.deleteTicketsByMainId(jeecgOrderMain.getId());
        this.jeecgOrderCustomerMapper.deleteCustomersByMainId(jeecgOrderMain.getId());
        if (jeecgOrderCustomerList != null) {
            for (JeecgOrderCustomer jeecgOrderCustomer : jeecgOrderCustomerList) {
                jeecgOrderCustomer.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderCustomerMapper.insert(jeecgOrderCustomer);
            }
        }
        if (jeecgOrderTicketList != null) {
            for (JeecgOrderTicket jeecgOrderTicket : jeecgOrderTicketList) {
                jeecgOrderTicket.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderTicketMapper.insert(jeecgOrderTicket);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCopyMain(JeecgOrderMain jeecgOrderMain, List<JeecgOrderCustomer> jeecgOrderCustomerList, List<JeecgOrderTicket> jeecgOrderTicketList) {
        this.jeecgOrderMainMapper.updateById(jeecgOrderMain);
        for (JeecgOrderTicket ticket : jeecgOrderTicketList) {
            JeecgOrderTicket orderTicket = (JeecgOrderTicket)this.jeecgOrderTicketMapper.selectById((Serializable)((Object)ticket.getId()));
            if (orderTicket == null) {
                ticket.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderTicketMapper.insert(ticket);
                continue;
            }
            if (!orderTicket.getId().equals(ticket.getId())) continue;
            this.jeecgOrderTicketMapper.updateById(ticket);
        }
        for (JeecgOrderCustomer customer : jeecgOrderCustomerList) {
            JeecgOrderCustomer customers = (JeecgOrderCustomer)this.jeecgOrderCustomerMapper.selectById((Serializable)((Object)customer.getId()));
            if (customers == null) {
                customer.setOrderId(jeecgOrderMain.getId());
                this.jeecgOrderCustomerMapper.insert(customer);
                continue;
            }
            if (!customers.getId().equals(customer.getId())) continue;
            this.jeecgOrderCustomerMapper.updateById(customer);
        }
        List<JeecgOrderTicket> jeecgOrderTickets = this.jeecgOrderTicketMapper.selectTicketsByMainId(jeecgOrderMain.getId());
        List collect = jeecgOrderTickets.stream().filter(item -> !jeecgOrderTicketList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(item.getId())).collect(Collectors.toList());
        for (JeecgOrderTicket ticket : collect) {
            this.jeecgOrderTicketMapper.deleteById((Serializable)((Object)ticket.getId()));
        }
        List<JeecgOrderCustomer> jeecgOrderCustomers = this.jeecgOrderCustomerMapper.selectCustomersByMainId(jeecgOrderMain.getId());
        List customersCollect = jeecgOrderCustomers.stream().filter(item -> !jeecgOrderCustomerList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(item.getId())).collect(Collectors.toList());
        for (JeecgOrderCustomer c : customersCollect) {
            this.jeecgOrderCustomerMapper.deleteById((Serializable)((Object)c.getId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        this.jeecgOrderMainMapper.deleteById((Serializable)((Object)id));
        this.jeecgOrderTicketMapper.deleteTicketsByMainId(id);
        this.jeecgOrderCustomerMapper.deleteCustomersByMainId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(Collection<? extends Serializable> idList) {
        for (Serializable serializable : idList) {
            this.jeecgOrderMainMapper.deleteById(serializable);
            this.jeecgOrderTicketMapper.deleteTicketsByMainId(serializable.toString());
            this.jeecgOrderCustomerMapper.deleteCustomersByMainId(serializable.toString());
        }
    }
}

