/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jeecg.qywx.api.base.JwAccessTokenAPI;
import com.jeecg.qywx.api.core.common.AccessToken;
import com.jeecg.qywx.api.department.JwDepartmentAPI;
import com.jeecg.qywx.api.department.vo.DepartMsgResponse;
import com.jeecg.qywx.api.department.vo.Department;
import com.jeecg.qywx.api.message.JwMessageAPI;
import com.jeecg.qywx.api.message.vo.Markdown;
import com.jeecg.qywx.api.message.vo.MarkdownEntity;
import com.jeecg.qywx.api.message.vo.Text;
import com.jeecg.qywx.api.message.vo.TextCard;
import com.jeecg.qywx.api.message.vo.TextCardEntity;
import com.jeecg.qywx.api.message.vo.TextEntity;
import com.jeecg.qywx.api.user.JwUserAPI;
import com.jeecg.qywx.api.user.vo.User;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysThirdAppConfig;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysTenantMapper;
import org.jeecg.modules.system.mapper.SysThirdAccountMapper;
import org.jeecg.modules.system.mapper.SysThirdAppConfigMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysPositionService;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.IThirdAppService;
import org.jeecg.modules.system.vo.thirdapp.JwDepartmentTreeVo;
import org.jeecg.modules.system.vo.thirdapp.JwSysUserDepartVo;
import org.jeecg.modules.system.vo.thirdapp.JwUserDepartVo;
import org.jeecg.modules.system.vo.thirdapp.SyncInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class ThirdAppWechatEnterpriseServiceImpl
implements IThirdAppService {
    private static final Logger log = LoggerFactory.getLogger(ThirdAppWechatEnterpriseServiceImpl.class);
    @Autowired
    JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Autowired
    private ISysPositionService sysPositionService;
    @Autowired
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Autowired
    private SysThirdAppConfigMapper configMapper;
    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private SysUserTenantMapper sysUserTenantMapper;
    @Autowired
    private SysThirdAccountMapper sysThirdAccountMapper;
    @Autowired
    private SysTenantMapper tenantMapper;
    private static final String ERR_CODE = "errcode";
    public final String THIRD_TYPE = "wechat_enterprise";

    @Override
    public String getAccessToken() {
        String secret;
        SysThirdAppConfig config = this.getWeChatThirdAppConfig();
        String corpId = config.getClientId();
        AccessToken accessToken = JwAccessTokenAPI.getAccessToken((String)corpId, (String)(secret = config.getClientSecret()));
        if (accessToken != null) {
            return accessToken.getAccesstoken();
        }
        log.warn("\u83b7\u53d6AccessToken\u5931\u8d25");
        return null;
    }

    public String getAppAccessToken(SysThirdAppConfig config) {
        String secret;
        String corpId = config.getClientId();
        AccessToken accessToken = JwAccessTokenAPI.getAccessToken((String)corpId, (String)(secret = config.getClientSecret()));
        if (accessToken != null) {
            return accessToken.getAccesstoken();
        }
        log.warn("\u83b7\u53d6AccessToken\u5931\u8d25");
        return null;
    }

    @Override
    public SyncInfoVo syncLocalDepartmentToThirdApp(String ids) {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List departments = JwDepartmentAPI.getAllDepartment((String)accessToken);
        if (departments == null) {
            syncInfo.addFailInfo("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u6240\u6709\u90e8\u95e8\u5931\u8d25\uff01");
            return syncInfo;
        }
        List<JwDepartmentTreeVo> departmentTreeList = JwDepartmentTreeVo.listToTree(departments);
        this.deleteDepartRecursion(departmentTreeList, accessToken, true);
        List<SysDepartTreeModel> sysDepartsTree = this.sysDepartService.queryTreeList();
        Department parent = new Department();
        parent.setId("1");
        departments = JwDepartmentAPI.getAllDepartment((String)accessToken);
        this.syncDepartmentRecursion(sysDepartsTree, departments, parent, accessToken);
        return syncInfo;
    }

    private void deleteDepartRecursion(List<JwDepartmentTreeVo> children, String accessToken, boolean ifLocal) {
        for (JwDepartmentTreeVo departmentTree : children) {
            List departUserList;
            String depId = departmentTree.getId();
            if ("1".equals(depId)) continue;
            if (ifLocal) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysDepart::getQywxIdentifier, (Object)depId);
                SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                if (sysDepart != null) {
                    if (!departmentTree.hasChildren()) continue;
                    this.deleteDepartRecursion(departmentTree.getChildren(), accessToken, true);
                    continue;
                }
            }
            if ((departUserList = JwUserAPI.getUsersByDepartid((String)depId, (String)"1", null, (String)accessToken)) != null && departUserList.size() > 0) {
                for (User user : departUserList) {
                    User updateUser = new User();
                    updateUser.setUserid(user.getUserid());
                    updateUser.setDepartment(new Integer[]{1});
                    JwUserAPI.updateUser((User)updateUser, (String)accessToken);
                }
            }
            if (departmentTree.hasChildren()) {
                this.deleteDepartRecursion(departmentTree.getChildren(), accessToken, false);
            }
            JwDepartmentAPI.deleteDepart((String)depId, (String)accessToken);
        }
    }

    private void syncDepartmentRecursion(List<SysDepartTreeModel> sysDepartsTree, List<Department> departments, Department parent, String accessToken) {
        if (sysDepartsTree != null && sysDepartsTree.size() != 0) {
            block0: for (SysDepartTreeModel depart : sysDepartsTree) {
                for (Department department : departments) {
                    if (!department.getId().equals(depart.getQywxIdentifier())) continue;
                    this.sysDepartToQwDepartment(depart, department, parent.getId());
                    JwDepartmentAPI.updateDepart((Department)department, (String)accessToken);
                    this.syncDepartmentRecursion(depart.getChildren(), departments, department, accessToken);
                    continue block0;
                }
                Department newDepartment = this.sysDepartToQwDepartment(depart, parent.getId());
                DepartMsgResponse response = JwDepartmentAPI.createDepartment((Department)newDepartment, (String)accessToken);
                if (response == null || response.getId() == null) continue;
                SysDepart sysDepart = new SysDepart();
                sysDepart.setId(depart.getId());
                sysDepart.setQywxIdentifier(response.getId().toString());
                this.sysDepartService.updateById(sysDepart);
                Department newParent = new Department();
                newParent.setId(response.getId().toString());
                this.syncDepartmentRecursion(depart.getChildren(), departments, newParent, accessToken);
            }
        }
    }

    public SyncInfoVo syncThirdAppDepartmentToLocal(Integer tenantId, Map<String, String> map) {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List departments = JwDepartmentAPI.getAllDepartment((String)accessToken);
        if (departments == null) {
            syncInfo.addFailInfo("\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        List<JwDepartmentTreeVo> departmentTreeList = JwDepartmentTreeVo.listToTree(departments);
        this.syncDepartmentToLocalRecursion(departmentTreeList, null, username, syncInfo, tenantId, map);
        return syncInfo;
    }

    private void syncDepartmentToLocalRecursion(List<JwDepartmentTreeVo> departmentTreeList, String sysParentId, String username, SyncInfoVo syncInfo, Integer tenantId, Map<String, String> map) {
        if (departmentTreeList != null && departmentTreeList.size() != 0) {
            for (JwDepartmentTreeVo departmentTree : departmentTreeList) {
                String str;
                String depId = departmentTree.getId();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysDepart::getQywxIdentifier, (Object)depId);
                queryWrapper.eq(SysDepart::getTenantId, (Object)tenantId);
                SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                if (sysDepart != null) {
                    SysDepart updateSysDepart = this.qwDepartmentToSysDepart(departmentTree, sysDepart);
                    if (sysParentId != null && !"0".equals(sysParentId)) {
                        updateSysDepart.setParentId(sysParentId);
                    }
                    try {
                        this.sysDepartService.updateDepartDataById(updateSysDepart, username);
                        str = String.format("\u90e8\u95e8 %s \u66f4\u65b0\u6210\u529f\uff01", updateSysDepart.getDepartName());
                        syncInfo.addSuccessInfo(str);
                        map.put(depId, updateSysDepart.getId());
                    }
                    catch (Exception e) {
                        this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                    }
                    if (!departmentTree.hasChildren()) continue;
                    this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), updateSysDepart.getId(), username, syncInfo, tenantId, map);
                    continue;
                }
                SysDepart newSysDepart = this.qwDepartmentToSysDepart(departmentTree, null);
                if (sysParentId != null && !"0".equals(sysParentId)) {
                    newSysDepart.setParentId(sysParentId);
                    newSysDepart.setOrgCategory("2");
                } else {
                    newSysDepart.setOrgCategory("1");
                }
                newSysDepart.setTenantId(tenantId);
                try {
                    this.sysDepartService.saveDepartData(newSysDepart, username);
                    str = String.format("\u90e8\u95e8 %s \u521b\u5efa\u6210\u529f\uff01", newSysDepart.getDepartName());
                    syncInfo.addSuccessInfo(str);
                    map.put(depId, newSysDepart.getId());
                }
                catch (Exception e) {
                    this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                }
                if (!departmentTree.hasChildren()) continue;
                this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), newSysDepart.getId(), username, syncInfo, tenantId, map);
            }
        }
    }

    @Override
    public SyncInfoVo syncLocalUserToThirdApp(String ids) {
        List sysUsers;
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List qwUsers = JwUserAPI.getUserIdList((String)accessToken);
        if (qwUsers == null) {
            syncInfo.addFailInfo("\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff01");
            return syncInfo;
        }
        if (StringUtils.isNotBlank((String)ids)) {
            String[] idList = ids.split(",");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUser::getId, (Object[])idList);
            sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        } else {
            sysUsers = this.userMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        }
        block0: for (SysUser sysUser : sysUsers) {
            User qwUser;
            if ("_reserve_user_external".equals(sysUser.getUsername())) continue;
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneBySysUserId(sysUser.getId(), "wechat_enterprise");
            for (User qwUserTemp : qwUsers) {
                String username;
                if ((sysThirdAccount == null || oConvertUtils.isEmpty((Object)sysThirdAccount.getThirdUserId()) || !sysThirdAccount.getThirdUserId().equals(qwUserTemp.getUserid())) && !oConvertUtils.isEmpty((Object)(username = sysUser.getUsername())) && !username.equals(qwUserTemp.getUserid())) continue;
                qwUser = this.sysUserToQwUser(sysUser, qwUserTemp);
                int errCode = JwUserAPI.updateUser((User)qwUser, (String)accessToken);
                this.syncUserCollectErrInfo(errCode, sysUser, syncInfo);
                this.thirdAccountSaveOrUpdate(sysThirdAccount, sysUser.getId(), qwUser.getUserid(), qwUser.getName(), null);
                continue block0;
            }
            qwUser = this.sysUserToQwUser(sysUser);
            int errCode = JwUserAPI.createUser((User)qwUser, (String)accessToken);
            boolean apiSuccess = this.syncUserCollectErrInfo(errCode, sysUser, syncInfo);
            if (!apiSuccess) continue;
            this.thirdAccountSaveOrUpdate(sysThirdAccount, sysUser.getId(), qwUser.getUserid(), qwUser.getName(), null);
        }
        return syncInfo;
    }

    private void thirdAccountSaveOrUpdate(SysThirdAccount sysThirdAccount, String sysUserId, String qwUserId, String wechatRealName, Integer tenantId) {
        if (sysThirdAccount == null) {
            sysThirdAccount = new SysThirdAccount();
            sysThirdAccount.setSysUserId(sysUserId);
            sysThirdAccount.setStatus(1);
            sysThirdAccount.setDelFlag(0);
            sysThirdAccount.setThirdType("wechat_enterprise");
            if (oConvertUtils.isNotEmpty((Object)tenantId)) {
                sysThirdAccount.setTenantId(tenantId);
            }
        }
        sysThirdAccount.setThirdUserId(qwUserId);
        sysThirdAccount.setThirdUserUuid(qwUserId);
        sysThirdAccount.setRealname(wechatRealName);
        this.sysThirdAccountService.saveOrUpdate(sysThirdAccount);
    }

    private boolean syncUserCollectErrInfo(int errCode, SysUser sysUser, SyncInfoVo syncInfo) {
        if (errCode != 0) {
            String msg = "";
            switch (errCode) {
                case 40003: {
                    msg = "\u65e0\u6548\u7684UserID";
                    break;
                }
                case 60129: {
                    msg = "\u624b\u673a\u548c\u90ae\u7bb1\u4e0d\u80fd\u90fd\u4e3a\u7a7a";
                    break;
                }
                case 60102: {
                    msg = "UserID\u5df2\u5b58\u5728";
                    break;
                }
                case 60103: {
                    msg = "\u624b\u673a\u53f7\u7801\u4e0d\u5408\u6cd5";
                    break;
                }
                case 60104: {
                    msg = "\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728";
                    break;
                }
            }
            String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a%s\u2014\u2014%s", sysUser.getUsername(), sysUser.getRealname(), errCode, msg);
            syncInfo.addFailInfo(str);
            return false;
        }
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u6210\u529f\uff01", sysUser.getUsername(), sysUser.getRealname());
        syncInfo.addSuccessInfo(str);
        return true;
    }

    private boolean syncUserCollectErrInfo(Exception e, User qwUser, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", qwUser.getUserid(), qwUser.getName(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private boolean syncDepartCollectErrInfo(Exception e, Department department, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u90e8\u95e8 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", department.getName(), department.getId(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private User sysUserToQwUser(SysUser sysUser) {
        User user = new User();
        user.setUserid(sysUser.getUsername());
        return this.sysUserToQwUser(sysUser, user);
    }

    private User sysUserToQwUser(SysUser sysUser, User user) {
        List<SysPosition> positionList;
        user.setName(sysUser.getRealname());
        user.setMobile(sysUser.getPhone());
        List<SysDepart> departList = this.getUserDepart(sysUser);
        if (departList != null) {
            ArrayList<Integer> departmentIdList = new ArrayList<Integer>();
            ArrayList<Integer> isLeaderInDept = new ArrayList<Integer>();
            List<Object> manageDepartIdList = new ArrayList();
            if (oConvertUtils.isNotEmpty((Object)sysUser.getDepartIds())) {
                manageDepartIdList = Arrays.asList(sysUser.getDepartIds().split(","));
            }
            for (SysDepart sysDepart : departList) {
                if (!oConvertUtils.isNotEmpty((Object)sysDepart.getQywxIdentifier())) continue;
                try {
                    departmentIdList.add(Integer.parseInt(sysDepart.getQywxIdentifier()));
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
                if (CommonConstant.USER_IDENTITY_2.equals(sysUser.getUserIdentity())) {
                    isLeaderInDept.add(manageDepartIdList.contains(sysDepart.getId()) ? 1 : 0);
                    continue;
                }
                isLeaderInDept.add(0);
            }
            user.setDepartment(departmentIdList.toArray(new Integer[0]));
            user.setIs_leader_in_dept(isLeaderInDept.toArray(new Integer[0]));
        }
        if (user.getDepartment() == null || user.getDepartment().length == 0) {
            user.setDepartment(new Integer[]{1});
            user.setIs_leader_in_dept(new Integer[]{0});
        }
        if (null != (positionList = this.sysPositionService.getPositionList(sysUser.getId())) && positionList.size() > 0) {
            String positionName = positionList.stream().map(SysPosition::getName).collect(Collectors.joining(","));
            user.setPosition(positionName);
        }
        if (sysUser.getSex() != null) {
            user.setGender(sysUser.getSex().toString());
        }
        user.setEmail(sysUser.getEmail());
        if (sysUser.getStatus() != null) {
            if (CommonConstant.USER_UNFREEZE.equals(sysUser.getStatus()) || CommonConstant.USER_FREEZE.equals(sysUser.getStatus())) {
                user.setEnable(Integer.valueOf(sysUser.getStatus() == 1 ? 1 : 0));
            } else {
                user.setEnable(Integer.valueOf(1));
            }
        }
        user.setTelephone(sysUser.getTelephone());
        if (CommonConstant.DEL_FLAG_1.equals(sysUser.getDelFlag())) {
            user.setEnable(Integer.valueOf(0));
        }
        return user;
    }

    private List<SysDepart> getUserDepart(SysUser sysUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserDepart::getUserId, (Object)sysUser.getId());
        List sysUserDepartList = this.sysUserDepartService.list((Wrapper)queryWrapper);
        if (sysUserDepartList.size() == 0) {
            return null;
        }
        LambdaQueryWrapper departQueryWrapper = new LambdaQueryWrapper();
        List departIdList = sysUserDepartList.stream().map(SysUserDepart::getDepId).collect(Collectors.toList());
        departQueryWrapper.in(SysDepart::getId, departIdList);
        List departList = this.sysDepartService.list((Wrapper)departQueryWrapper);
        return departList.size() == 0 ? null : departList;
    }

    private SysUser qwUserToSysUser(User user) {
        SysUser sysUser = new SysUser();
        sysUser.setDelFlag(0);
        sysUser.setStatus(1);
        sysUser.setUsername(user.getUserid());
        String password = "123456";
        String salt = oConvertUtils.randomGen((int)8);
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setSalt(salt);
        sysUser.setPassword(passwordEncode);
        return this.qwUserToSysUser(user, sysUser);
    }

    private SysUser qwUserToSysUser(User qwUser, SysUser oldSysUser) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)oldSysUser, (Object)sysUser);
        sysUser.setRealname(qwUser.getName());
        sysUser.setPost(qwUser.getPosition());
        if (oConvertUtils.isEmpty((Object)sysUser.getWorkNo())) {
            sysUser.setWorkNo(qwUser.getUserid());
        }
        try {
            sysUser.setSex(Integer.parseInt(qwUser.getGender()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (oConvertUtils.isNotEmpty((Object)qwUser.getEmail()) && !qwUser.getEmail().equals(sysUser.getEmail())) {
            sysUser.setEmail(qwUser.getEmail());
        } else {
            sysUser.setEmail(null);
        }
        if (oConvertUtils.isNotEmpty((Object)qwUser.getMobile()) && !qwUser.getMobile().equals(sysUser.getPhone())) {
            sysUser.setPhone(qwUser.getMobile());
        } else {
            sysUser.setPhone(null);
        }
        if (qwUser.getEnable() != null) {
            sysUser.setStatus(qwUser.getEnable() == 1 ? 1 : 2);
        }
        sysUser.setTelephone(qwUser.getTelephone());
        return sysUser;
    }

    private Department sysDepartToQwDepartment(SysDepartTreeModel departTree, String parentId) {
        Department department = new Department();
        return this.sysDepartToQwDepartment(departTree, department, parentId);
    }

    private Department sysDepartToQwDepartment(SysDepartTreeModel departTree, Department department, String parentId) {
        department.setName(departTree.getDepartName());
        department.setParentid(parentId);
        if (departTree.getDepartOrder() != null) {
            department.setOrder(departTree.getDepartOrder().toString());
        }
        return department;
    }

    private SysDepart qwDepartmentToSysDepart(Department department, SysDepart oldSysDepart) {
        SysDepart sysDepart = new SysDepart();
        if (oldSysDepart != null) {
            BeanUtils.copyProperties((Object)oldSysDepart, (Object)sysDepart);
        }
        sysDepart.setQywxIdentifier(department.getId());
        sysDepart.setDepartName(department.getName());
        try {
            sysDepart.setDepartOrder(Integer.parseInt(department.getOrder()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sysDepart;
    }

    @Override
    public int removeThirdAppUser(List<String> userIdList) {
        SysThirdAppConfig config = this.getWeChatThirdAppConfig();
        if (null == config) {
            return -1;
        }
        int count = 0;
        if (userIdList != null && userIdList.size() > 0) {
            String accessToken = this.getAccessToken();
            if (accessToken == null) {
                return count;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"wechat_enterprise");
            queryWrapper.in(SysThirdAccount::getSysUserId, userIdList);
            List thirdAccountList = this.sysThirdAccountService.list((Wrapper)queryWrapper);
            List thirdUserIdList = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            for (String thirdUserId : thirdUserIdList) {
                int err;
                if (!oConvertUtils.isNotEmpty((Object)thirdUserId) || (err = JwUserAPI.deleteUser((String)thirdUserId, (String)accessToken)) != 0) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean sendMessage(MessageDTO message) {
        return this.sendMessage(message, false);
    }

    @Override
    public boolean sendMessage(MessageDTO message, boolean verifyConfig) {
        JSONObject response = message.isMarkdown() ? this.sendMarkdownResponse(message, verifyConfig) : this.sendMessageResponse(message, verifyConfig);
        if (response != null) {
            return response.getIntValue(ERR_CODE) == 0;
        }
        return false;
    }

    public JSONObject sendMessageResponse(MessageDTO message, boolean verifyConfig) {
        SysThirdAppConfig config = this.getWeChatThirdAppConfig();
        if (verifyConfig && null == config) {
            return null;
        }
        String accessToken = this.getAppAccessToken(config);
        if (accessToken == null) {
            return null;
        }
        Text text = new Text();
        text.setMsgtype("text");
        text.setTouser(this.getTouser(message.getToUser(), message.getToAll()));
        TextEntity entity = new TextEntity();
        entity.setContent(message.getContent());
        text.setText(entity);
        text.setAgentid(Integer.parseInt(config.getAgentId()));
        return JwMessageAPI.sendTextMessage((Text)text, (String)accessToken);
    }

    public JSONObject sendMarkdownResponse(MessageDTO message, boolean verifyConfig) {
        SysThirdAppConfig config = this.getWeChatThirdAppConfig();
        if (verifyConfig && null == config) {
            return null;
        }
        String accessToken = this.getAppAccessToken(config);
        if (accessToken == null) {
            return null;
        }
        Markdown markdown = new Markdown();
        markdown.setTouser(this.getTouser(message.getToUser(), message.getToAll()));
        MarkdownEntity entity = new MarkdownEntity();
        entity.setContent(message.getContent());
        markdown.setMarkdown(entity);
        markdown.setAgentid(Integer.parseInt(config.getAgentId()));
        return JwMessageAPI.sendMarkdownMessage((Markdown)markdown, (String)accessToken);
    }

    public JSONObject sendTextCardMessage(SysAnnouncement announcement, boolean verifyConfig) {
        SysThirdAppConfig config = this.getWeChatThirdAppConfig();
        if (verifyConfig && null == config) {
            return null;
        }
        String accessToken = this.getAppAccessToken(config);
        if (accessToken == null) {
            return null;
        }
        TextCard textCard = new TextCard();
        textCard.setAgentid(Integer.parseInt(config.getAgentId()));
        boolean isToAll = "ALL".equals(announcement.getMsgType());
        String usernameString = "";
        if (!isToAll) {
            LambdaQueryWrapper queryWrapper;
            String userId = announcement.getUserIds();
            Object[] userIds = null;
            if (oConvertUtils.isNotEmpty((Object)userId)) {
                userIds = userId.substring(0, userId.length() - 1).split(",");
            } else {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)announcement.getId());
                SysAnnouncementSend sysAnnouncementSend = (SysAnnouncementSend)this.sysAnnouncementSendMapper.selectOne((Wrapper)queryWrapper);
                userIds = new String[]{sysAnnouncementSend.getUserId()};
            }
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUser::getId, userIds);
            List userList = this.userMapper.selectList((Wrapper)queryWrapper);
            List usernameList = userList.stream().map(SysUser::getUsername).collect(Collectors.toList());
            usernameString = String.join((CharSequence)",", usernameList);
        }
        textCard.setTouser(this.getTouser(usernameString, isToAll));
        TextCardEntity entity = new TextCardEntity();
        entity.setTitle(announcement.getTitile());
        entity.setDescription(oConvertUtils.getString((String)announcement.getMsgAbstract(), (String)"\u7a7a"));
        String baseUrl = null;
        try {
            baseUrl = RestUtil.getBaseUrl();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            baseUrl = this.jeecgBaseConfig.getDomainUrl().getPc();
        }
        entity.setUrl(baseUrl + "/sys/annountCement/show/" + announcement.getId());
        textCard.setTextcard(entity);
        return JwMessageAPI.sendTextCardMessage((TextCard)textCard, (String)accessToken);
    }

    private String getTouser(String origin, boolean toAll) {
        if (toAll) {
            return "@all";
        }
        String[] toUsers = origin.split(",");
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (Integer)CommonConstant.TENANT_ID_DEFAULT_VALUE);
        List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(toUsers, "wechat_enterprise", tenantId);
        List toUserList = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
        return String.join((CharSequence)"|", toUserList);
    }

    public Map<String, String> getUserIdByThirdCode(String code, String accessToken) {
        JSONObject response = JwUserAPI.getUserInfoByCode((String)code, (String)accessToken);
        if (response != null) {
            HashMap<String, String> map = new HashMap<String, String>(5);
            log.info("response: " + response.toJSONString());
            if (response.getIntValue(ERR_CODE) == 0) {
                String userTicket = response.getString("user_ticket");
                String appUserId = response.getString("UserId");
                map.put("userTicket", userTicket);
                map.put("appUserId", appUserId);
                return map;
            }
        }
        return null;
    }

    public SysUser oauth2Login(String code, Integer tenantId) {
        Long count = this.tenantMapper.tenantIzExist(tenantId);
        if (ObjectUtil.isEmpty((Object)count) || 0L == count) {
            throw new JeecgBootException("\u79df\u6237\u4e0d\u5b58\u5728\uff01");
        }
        SysThirdAppConfig config = this.configMapper.getThirdConfigByThirdType(tenantId, MessageTypeEnum.QYWX.getType());
        String accessToken = this.getAppAccessToken(config);
        if (accessToken == null) {
            return null;
        }
        Map<String, String> map = this.getUserIdByThirdCode(code, accessToken);
        if (null != map) {
            String appUserId = map.get("appUserId");
            String userTicket = map.get("userTicket");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdUserId, (Object)appUserId);
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"wechat_enterprise");
            queryWrapper.eq(SysThirdAccount::getTenantId, (Object)tenantId);
            SysThirdAccount thirdAccount = (SysThirdAccount)this.sysThirdAccountService.getOne((Wrapper)queryWrapper);
            if (thirdAccount != null) {
                return this.getSysUserByThird(thirdAccount, null, appUserId, accessToken, userTicket, tenantId);
            }
            throw new JeecgBootException("\u8be5\u7528\u6237\u5c1a\u672a\u540c\u6b65\uff0c\u8bf7\u540c\u6b65\u540e\u518d\u6b21\u767b\u5f55\uff01");
        }
        return null;
    }

    private SysUser getSysUserByThird(SysThirdAccount thirdAccount, User appUser, String appUserId, String accessToken, String userTicket, Integer tenantId) {
        SysUser sysUser;
        String sysUserId = thirdAccount.getSysUserId();
        if (oConvertUtils.isNotEmpty((Object)sysUserId)) {
            return (SysUser)this.userMapper.selectById((Serializable)((Object)sysUserId));
        }
        if (appUser == null) {
            appUser = this.getUserByUserTicket(userTicket, accessToken);
        }
        if ((sysUser = this.userMapper.getUserByPhone(appUser.getMobile())) != null) {
            thirdAccount.setAvatar(appUser.getAvatar());
            thirdAccount.setRealname(appUser.getName());
            thirdAccount.setThirdUserId(appUser.getUserid());
            thirdAccount.setThirdUserUuid(appUser.getUserid());
            thirdAccount.setSysUserId(sysUser.getId());
            this.sysThirdAccountService.updateById(thirdAccount);
            return sysUser;
        }
        return this.sysThirdAccountService.createUser(appUser.getMobile(), appUser.getUserid(), tenantId);
    }

    private SysThirdAppConfig getWeChatThirdAppConfig() {
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        return this.configMapper.getThirdConfigByThirdType(tenantId, MessageTypeEnum.QYWX.getType());
    }

    private User getUserByUserTicket(String userTicket, String accessToken) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("user_ticket", userTicket);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost("https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=" + accessToken);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString(map), ContentType.create((String)"application/json", (String)"utf-8")));
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            Integer errcode = jsonObject.getInteger(ERR_CODE);
            if (0 == errcode) {
                return (User)JSONObject.toJavaObject((JSON)jsonObject, User.class);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public JwSysUserDepartVo getThirdUserByWechat(Integer tenantId) {
        JwSysUserDepartVo sysUserDepartVo = new JwSysUserDepartVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            throw new JeecgBootException("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
        }
        List<JwUserDepartVo> userList = this.sysUserTenantMapper.getUsersByTenantIdAndName(tenantId);
        List qwUsers = JwUserAPI.getUsersByDepartid((String)"1", (String)"1", null, (String)accessToken);
        if (oConvertUtils.isEmpty((Object)qwUsers)) {
            throw new JeecgBootException("\u4f01\u4e1a\u5fae\u4fe1\u4e0b\u6ca1\u67e5\u8be2\u5230\u7528\u6237\uff01");
        }
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<JwUserDepartVo> userWechatList = new ArrayList<JwUserDepartVo>();
        for (int i = 0; i < qwUsers.size(); ++i) {
            User user = (User)qwUsers.get(i);
            String userId = ((User)qwUsers.get(i)).getUserid();
            if (userIds.contains(userId)) continue;
            SysThirdAccount oneBySysUserId = this.sysThirdAccountService.getOneByUuidAndThirdType(userId, "wechat_enterprise", tenantId, userId);
            if (null != oneBySysUserId) {
                userIds.add(((User)qwUsers.get(i)).getUserid());
                userList = userList.stream().filter(item -> !item.getUserId().equals(oneBySysUserId.getSysUserId())).collect(Collectors.toList());
                continue;
            }
            AtomicBoolean excludeUser = new AtomicBoolean(false);
            if (ObjectUtil.isNotEmpty((Object)qwUsers)) {
                userList.forEach(item -> {
                    if (item.getRealName().equals(user.getName())) {
                        item.setWechatUserId(user.getUserid());
                        item.setWechatRealName(user.getName());
                        if (ObjectUtil.isNotEmpty((Object)user.getDepartment())) {
                            item.setWechatDepartId(Arrays.toString((Object[])user.getDepartment()));
                        }
                        excludeUser.set(true);
                    }
                });
                userIds.add(user.getUserid());
            }
            if (excludeUser.get()) continue;
            JwUserDepartVo userDepartVo = new JwUserDepartVo();
            userDepartVo.setWechatRealName(user.getName());
            userDepartVo.setWechatUserId(user.getUserid());
            if (ObjectUtil.isNotEmpty((Object)user.getDepartment())) {
                userDepartVo.setWechatDepartId(Arrays.toString((Object[])user.getDepartment()));
            }
            userWechatList.add(userDepartVo);
        }
        sysUserDepartVo.setUserList(userWechatList);
        sysUserDepartVo.setJwUserDepartVos(userList);
        return sysUserDepartVo;
    }

    public SyncInfoVo syncWechatEnterpriseDepartAndUserToLocal(String jwUserDepartJson, Integer tenantId) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        SyncInfoVo syncInfoVo = this.syncThirdAppDepartmentToLocal(tenantId, idsMap);
        this.syncDepartAndUser(syncInfoVo, tenantId, idsMap, jwUserDepartJson);
        return syncInfoVo;
    }

    private void syncDepartAndUser(SyncInfoVo syncInfoVo, Integer tenantId, Map<String, String> idsMap, String jwUserDepartJson) {
        if (oConvertUtils.isNotEmpty((Object)jwUserDepartJson)) {
            JSONArray jsonArray = JSONObject.parseArray((String)jwUserDepartJson);
            for (Object object : jsonArray) {
                JSONObject jsonObject = JSONObject.parseObject((String)object.toString());
                Object userId = jsonObject.get((Object)"userId");
                String wechatUserId = jsonObject.getString("wechatUserId");
                String wechatRealName = jsonObject.getString("wechatRealName");
                Object wechatDepartId = jsonObject.get((Object)"wechatDepartId");
                String sysUserId = "";
                if (null == userId) {
                    SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById(tenantId);
                    String houseNumber = "";
                    if (null != sysTenant) {
                        houseNumber = sysTenant.getHouseNumber();
                    }
                    String username = houseNumber + wechatUserId;
                    sysUserId = this.saveUser(username, wechatRealName, syncInfoVo, wechatUserId);
                } else {
                    SysUser sysUser = (SysUser)this.userMapper.selectById((Serializable)((Object)userId.toString()));
                    if (null != sysUser) {
                        sysUserId = sysUser.getId();
                        if (oConvertUtils.isEmpty((Object)sysUser.getRealname())) {
                            sysUser.setRealname(wechatRealName);
                            this.userMapper.updateById(sysUser);
                        }
                        String str = String.format("\u7528\u6237 %s(%s) \u66f4\u65b0\u6210\u529f\uff01", sysUser.getRealname(), sysUser.getUsername());
                        syncInfoVo.addSuccessInfo(str);
                    } else {
                        syncInfoVo.addFailInfo("\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237 " + wechatRealName + " \u5bf9\u5e94\u7684\u7ec4\u7ec7\u7528\u6237\u6ca1\u6709\u5339\u914d\u5230\uff01");
                        continue;
                    }
                }
                if (!oConvertUtils.isNotEmpty((Object)sysUserId)) continue;
                this.createUserTenant(sysUserId, false, tenantId);
                SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneByUuidAndThirdType(wechatUserId, "wechat_enterprise", tenantId, wechatUserId);
                this.thirdAccountSaveOrUpdate(sysThirdAccount, sysUserId, wechatUserId, wechatRealName, tenantId);
                if (!oConvertUtils.isNotEmpty((Object)wechatDepartId)) continue;
                String wechatDepartIds = wechatDepartId.toString();
                String[] departIds = wechatDepartIds.substring(1, wechatDepartIds.length() - 1).split(",");
                this.userDepartSaveOrUpdate(idsMap, sysUserId, departIds);
            }
        } else {
            syncInfoVo.addFailInfo("\u7528\u6237\u540c\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u4f01\u4e1a\u5fae\u4fe1\u662f\u5426\u5b58\u5728\u7528\u6237\uff01");
        }
    }

    private String saveUser(String username, String wechatRealName, SyncInfoVo syncInfo, String wechatUserId) {
        SysUser sysUser = new SysUser();
        sysUser.setRealname(wechatRealName);
        sysUser.setPassword(username);
        sysUser.setUsername(username);
        sysUser.setDelFlag(CommonConstant.DEL_FLAG_0);
        sysUser.setCreateTime(new Date());
        String salt = oConvertUtils.randomGen((int)8);
        sysUser.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)sysUser.getPassword(), (String)salt);
        sysUser.setPassword(passwordEncode);
        sysUser.setStatus(1);
        sysUser.setDelFlag(CommonConstant.DEL_FLAG_0);
        sysUser.setOrgCode(null);
        try {
            this.userMapper.insert(sysUser);
            String str = String.format("\u7528\u6237 %s(%s) \u521b\u5efa\u6210\u529f\uff01", sysUser.getRealname(), sysUser.getUsername());
            syncInfo.addSuccessInfo(str);
            return sysUser.getId();
        }
        catch (Exception e) {
            User user = new User();
            user.setUserid(wechatUserId);
            user.setName(wechatRealName);
            this.syncUserCollectErrInfo(e, user, syncInfo);
            return "";
        }
    }

    private void createUserTenant(String userId, Boolean isUpdate, Integer tenantId) {
        Integer count;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && (count = this.sysUserTenantMapper.userTenantIzExist(userId, tenantId)) == 0) {
            SysUserTenant userTenant = new SysUserTenant();
            userTenant.setTenantId(tenantId);
            userTenant.setUserId(userId);
            userTenant.setStatus(isUpdate != false ? "3" : "1");
            this.sysUserTenantMapper.insert(userTenant);
        }
    }

    private void userDepartSaveOrUpdate(Map<String, String> idsMap, String sysUserId, String[] departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserDepart::getUserId, (Object)sysUserId);
        for (String departId : departIds) {
            if (!idsMap.containsKey(departId = departId.trim())) continue;
            String value = idsMap.get(departId);
            query.eq(SysUserDepart::getDepId, (Object)value);
            long count = this.sysUserDepartService.count((Wrapper)query);
            if (count != 0L) continue;
            SysUserDepart sysUserDepart = new SysUserDepart(null, sysUserId, value);
            this.sysUserDepartService.save(sysUserDepart);
        }
    }

    public List<JwUserDepartVo> getThirdUserBindByWechat(int tenantId) {
        return this.sysThirdAccountMapper.getThirdUserBindByWechat(tenantId, "wechat_enterprise");
    }
}

