/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jeecg.dingtalk.api.base.JdtBaseAPI;
import com.jeecg.dingtalk.api.core.response.Response;
import com.jeecg.dingtalk.api.core.util.HttpUtil;
import com.jeecg.dingtalk.api.core.vo.AccessToken;
import com.jeecg.dingtalk.api.core.vo.PageResult;
import com.jeecg.dingtalk.api.department.JdtDepartmentAPI;
import com.jeecg.dingtalk.api.department.vo.Department;
import com.jeecg.dingtalk.api.message.JdtMessageAPI;
import com.jeecg.dingtalk.api.message.vo.ActionCardMessage;
import com.jeecg.dingtalk.api.message.vo.MarkdownMessage;
import com.jeecg.dingtalk.api.message.vo.Message;
import com.jeecg.dingtalk.api.message.vo.SuperMessage;
import com.jeecg.dingtalk.api.message.vo.TextMessage;
import com.jeecg.dingtalk.api.oauth2.JdtOauth2API;
import com.jeecg.dingtalk.api.oauth2.vo.ContactUser;
import com.jeecg.dingtalk.api.user.JdtUserAPI;
import com.jeecg.dingtalk.api.user.body.GetUserListBody;
import com.jeecg.dingtalk.api.user.vo.User;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysThirdAppConfig;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysTenantMapper;
import org.jeecg.modules.system.mapper.SysThirdAppConfigMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.model.ThirdLoginModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysPositionService;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.IThirdAppService;
import org.jeecg.modules.system.vo.thirdapp.JdtDepartmentTreeVo;
import org.jeecg.modules.system.vo.thirdapp.SyncInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class ThirdAppDingtalkServiceImpl
implements IThirdAppService {
    private static final Logger log = LoggerFactory.getLogger(ThirdAppDingtalkServiceImpl.class);
    @Autowired
    JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Autowired
    private ISysPositionService sysPositionService;
    @Autowired
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Autowired
    private SysThirdAppConfigMapper configMapper;
    @Autowired
    private SysUserTenantMapper userTenantMapper;
    @Autowired
    private SysTenantMapper tenantMapper;
    public final String THIRD_TYPE = "dingtalk";

    @Override
    public String getAccessToken() {
        SysThirdAppConfig config = this.getDingThirdAppConfig();
        if (null != config) {
            return this.getTenantAccessToken(config);
        }
        log.warn("\u79df\u6237\u4e0b\u672a\u914d\u7f6e\u9489\u9489");
        return null;
    }

    @Override
    public SyncInfoVo syncLocalDepartmentToThirdApp(String ids) {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List departments = JdtDepartmentAPI.listAllResponse((String)accessToken);
        List sysDepartList = this.sysDepartService.list();
        block0: for (Response departmentRes : departments) {
            if (!departmentRes.isSuccess()) {
                syncInfo.addFailInfo(departmentRes.getErrmsg());
                if (!new Integer(88).equals(departmentRes.getErrcode())) continue;
                return syncInfo;
            }
            Department department = (Department)departmentRes.getResult();
            for (SysDepart depart : sysDepartList) {
                String sourceIdentifier = department.getSource_identifier();
                if (sourceIdentifier == null || !sourceIdentifier.equals(depart.getId())) continue;
                continue block0;
            }
            int deptId = department.getDept_id();
            Response userIdRes = JdtUserAPI.getUserListIdByDeptId((int)deptId, (String)accessToken);
            if (userIdRes.isSuccess() && ((List)userIdRes.getResult()).size() > 0) {
                for (String userId : (List)userIdRes.getResult()) {
                    User updateUser = new User();
                    updateUser.setUserid(userId);
                    updateUser.setDept_id_list(new Integer[]{1});
                    JdtUserAPI.update((User)updateUser, (String)accessToken);
                }
            }
            JdtDepartmentAPI.delete((int)deptId, (String)accessToken);
        }
        List<SysDepartTreeModel> sysDepartsTree = this.sysDepartService.queryTreeList();
        Department parent = new Department();
        parent.setDept_id(Integer.valueOf(1));
        departments = JdtDepartmentAPI.listAllResponse((String)accessToken);
        this.syncDepartmentRecursion(sysDepartsTree, departments, parent, accessToken, syncInfo);
        return syncInfo;
    }

    public void syncDepartmentRecursion(List<SysDepartTreeModel> sysDepartsTree, List<Response<Department>> departments, Department parent, String accessToken, SyncInfoVo syncInfo) {
        if (sysDepartsTree != null && sysDepartsTree.size() != 0) {
            block0: for (SysDepartTreeModel depart : sysDepartsTree) {
                for (Response<Department> departmentRes : departments) {
                    if (!departmentRes.isSuccess()) {
                        syncInfo.addFailInfo(departmentRes.getErrmsg());
                        continue;
                    }
                    Department department = (Department)departmentRes.getResult();
                    String sourceIdentifier = department.getSource_identifier();
                    if (sourceIdentifier == null || !sourceIdentifier.equals(depart.getId())) continue;
                    this.sysDepartToDtDepartment(depart, department, parent.getDept_id());
                    Response response = JdtDepartmentAPI.update((Department)department, (String)accessToken);
                    if (response.isSuccess()) {
                        this.syncDepartmentRecursion(depart.getChildren(), departments, department, accessToken, syncInfo);
                    }
                    this.syncDepartCollectErrInfo(response, depart, syncInfo);
                    continue block0;
                }
                Department newDepartment = this.sysDepartToDtDepartment(depart, parent.getDept_id());
                Response response = JdtDepartmentAPI.create((Department)newDepartment, (String)accessToken);
                if (response.getResult() != null) {
                    Department newParent = new Department();
                    newParent.setDept_id((Integer)response.getResult());
                    this.syncDepartmentRecursion(depart.getChildren(), departments, newParent, accessToken, syncInfo);
                }
                this.syncDepartCollectErrInfo(response, depart, syncInfo);
            }
        }
    }

    public void syncDepartmentToLocalRecursion(List<JdtDepartmentTreeVo> departmentTreeList, String sysParentId, String username, SyncInfoVo syncInfo, String accessToken, Boolean syncUser, Integer tenantId) {
        if (departmentTreeList != null && departmentTreeList.size() != 0) {
            HashSet<String> syncedUserIdSet = new HashSet<String>();
            for (JdtDepartmentTreeVo departmentTree : departmentTreeList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.and(item -> ((LambdaQueryWrapper)((LambdaQueryWrapper)item.eq(SysDepart::getId, (Object)departmentTree.getSource_identifier())).or()).eq(SysDepart::getDingIdentifier, (Object)departmentTree.getDept_id()));
                SysDepart sysDepart = (SysDepart)this.sysDepartService.getOne((Wrapper)queryWrapper);
                if (sysDepart != null) {
                    SysDepart updateSysDepart = this.dtDepartmentToSysDepart(departmentTree, sysDepart);
                    if (sysParentId != null) {
                        updateSysDepart.setParentId(sysParentId);
                        this.sysDepartService.updateIzLeaf(sysParentId, CommonConstant.NOT_LEAF);
                    }
                    try {
                        this.sysDepartService.updateDepartDataById(updateSysDepart, username);
                        String str = String.format("\u90e8\u95e8 %s \u66f4\u65b0\u6210\u529f\uff01", updateSysDepart.getDepartName());
                        syncInfo.addSuccessInfo(str);
                    }
                    catch (Exception e) {
                        this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                    }
                    if (departmentTree.hasChildren()) {
                        this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), updateSysDepart.getId(), username, syncInfo, accessToken, syncUser, tenantId);
                    }
                    if (!syncUser.booleanValue()) continue;
                    this.addDepartUser(updateSysDepart.getId(), departmentTree.getDept_id(), accessToken, syncInfo, syncedUserIdSet, tenantId);
                    continue;
                }
                SysDepart newSysDepart = this.dtDepartmentToSysDepart(departmentTree, null);
                if (sysParentId != null) {
                    newSysDepart.setParentId(sysParentId);
                    newSysDepart.setOrgCategory("2");
                } else {
                    newSysDepart.setOrgCategory("1");
                }
                try {
                    Response response;
                    if (oConvertUtils.isEmpty((Object)departmentTree.getParent_id())) {
                        newSysDepart.setDingIdentifier(departmentTree.getDept_id().toString());
                    }
                    newSysDepart.setTenantId(tenantId);
                    this.sysDepartService.saveDepartData(newSysDepart, username);
                    Department updateDtDepart = new Department();
                    updateDtDepart.setDept_id(departmentTree.getDept_id());
                    updateDtDepart.setSource_identifier(newSysDepart.getId());
                    if (oConvertUtils.isNotEmpty((Object)newSysDepart.getParentId()) && !(response = JdtDepartmentAPI.update((Department)updateDtDepart, (String)accessToken)).isSuccess()) {
                        throw new RuntimeException(response.getErrmsg());
                    }
                    String str = String.format("\u90e8\u95e8 %s \u521b\u5efa\u6210\u529f\uff01", newSysDepart.getDepartName());
                    syncInfo.addSuccessInfo(str);
                    if (syncUser.booleanValue()) {
                        this.addDepartUser(newSysDepart.getId(), departmentTree.getDept_id(), accessToken, syncInfo, syncedUserIdSet, tenantId);
                    }
                }
                catch (Exception e) {
                    this.syncDepartCollectErrInfo(e, departmentTree, syncInfo);
                }
                if (!departmentTree.hasChildren()) continue;
                this.syncDepartmentToLocalRecursion(departmentTree.getChildren(), newSysDepart.getId(), username, syncInfo, accessToken, syncUser, tenantId);
            }
        }
    }

    private boolean syncDepartCollectErrInfo(Exception e, Department department, SyncInfoVo syncInfo) {
        String msg = e instanceof DuplicateKeyException ? e.getCause().getMessage() : e.getMessage();
        String str = String.format("\u90e8\u95e8 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", department.getName(), department.getDept_id(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private boolean syncDepartCollectErrInfo(Response<?> response, SysDepartTreeModel depart, SyncInfoVo syncInfo) {
        if (!response.isSuccess()) {
            String str = String.format("\u90e8\u95e8 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a%s\u2014\u2014%s", depart.getDepartName(), depart.getOrgCode(), response.getErrcode(), response.getErrmsg());
            syncInfo.addFailInfo(str);
            return false;
        }
        String str = String.format("\u90e8\u95e8\u6237 %s(%s) \u540c\u6b65\u6210\u529f\uff01", depart.getDepartName(), depart.getOrgCode());
        syncInfo.addSuccessInfo(str);
        return true;
    }

    @Override
    public SyncInfoVo syncLocalUserToThirdApp(String ids) {
        List sysUsers;
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        if (StringUtils.isNotBlank((String)ids)) {
            String[] idList = ids.split(",");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUser::getId, (Object[])idList);
            sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        } else {
            sysUsers = this.userMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        }
        List allDepartment = JdtDepartmentAPI.listAll((String)accessToken);
        for (SysUser sysUser : sysUsers) {
            boolean flag;
            boolean apiSuccess;
            String dtUserId;
            Response thirdUserId;
            if ("_reserve_user_external".equals(sysUser.getUsername())) continue;
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneBySysUserId(sysUser.getId(), "dingtalk");
            Response dtUserInfo = sysThirdAccount != null && oConvertUtils.isNotEmpty((Object)sysThirdAccount.getThirdUserId()) ? JdtUserAPI.getUserById((String)sysThirdAccount.getThirdUserId(), (String)accessToken) : ((thirdUserId = JdtUserAPI.getUseridByMobile((String)sysUser.getPhone(), (String)accessToken)).isSuccess() && oConvertUtils.isNotEmpty((Object)thirdUserId.getResult()) ? JdtUserAPI.getUserById((String)((String)thirdUserId.getResult()), (String)accessToken) : JdtUserAPI.getUserById((String)sysUser.getUsername(), (String)accessToken));
            if (dtUserInfo != null && dtUserInfo.isSuccess() && dtUserInfo.getResult() != null) {
                User dtUser = (User)dtUserInfo.getResult();
                dtUserId = dtUser.getUserid();
                User updateQwUser = this.sysUserToDtUser(sysUser, dtUser, allDepartment);
                Response updateRes = JdtUserAPI.update((User)updateQwUser, (String)accessToken);
                apiSuccess = this.syncUserCollectErrInfo(updateRes, sysUser, syncInfo);
            } else {
                User newQwUser = this.sysUserToDtUser(sysUser, allDepartment);
                Response createRes = JdtUserAPI.create((User)newQwUser, (String)accessToken);
                dtUserId = (String)createRes.getResult();
                apiSuccess = this.syncUserCollectErrInfo(createRes, sysUser, syncInfo);
            }
            boolean bl = flag = sysThirdAccount == null || oConvertUtils.isEmpty((Object)sysThirdAccount.getThirdUserId());
            if (!apiSuccess || !flag) continue;
            if (sysThirdAccount == null) {
                sysThirdAccount = new SysThirdAccount();
                sysThirdAccount.setSysUserId(sysUser.getId());
                sysThirdAccount.setStatus(1);
                sysThirdAccount.setDelFlag(0);
                sysThirdAccount.setThirdType("dingtalk");
            }
            sysThirdAccount.setThirdUserId(dtUserId);
            this.sysThirdAccountService.saveOrUpdate(sysThirdAccount);
        }
        return syncInfo;
    }

    private void getUserListByDeptIdRecursion(int deptId, int cursor, List<User> userList, String accessToken) {
        GetUserListBody getUserListBody = new GetUserListBody(deptId, cursor, 100);
        Response response = JdtUserAPI.getUserListByDeptId((GetUserListBody)getUserListBody, (String)accessToken);
        if (response.isSuccess()) {
            PageResult page = (PageResult)response.getResult();
            userList.addAll(page.getList());
            if (page.getHas_more().booleanValue()) {
                this.getUserListByDeptIdRecursion(deptId, page.getNext_cursor(), userList, accessToken);
            }
        }
    }

    private void thirdAccountSaveOrUpdate(SysThirdAccount sysThirdAccount, String sysUserId, User user, Integer tenantId) {
        if (sysThirdAccount == null) {
            sysThirdAccount = new SysThirdAccount();
            sysThirdAccount.setSysUserId(sysUserId);
            sysThirdAccount.setThirdUserUuid(user.getUnionid());
            sysThirdAccount.setStatus(1);
            sysThirdAccount.setTenantId(tenantId);
            sysThirdAccount.setDelFlag(0);
            sysThirdAccount.setThirdType("dingtalk");
        }
        sysThirdAccount.setThirdUserId(user.getUserid());
        if (oConvertUtils.isEmpty((Object)sysThirdAccount.getRealname())) {
            sysThirdAccount.setRealname(user.getName());
        }
        this.sysThirdAccountService.saveOrUpdate(sysThirdAccount);
    }

    private boolean syncUserCollectErrInfo(Response<?> response, SysUser sysUser, SyncInfoVo syncInfo) {
        if (!response.isSuccess()) {
            String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u7801\uff1a%s\u2014\u2014%s", sysUser.getUsername(), sysUser.getRealname(), response.getErrcode(), response.getErrmsg());
            syncInfo.addFailInfo(str);
            return false;
        }
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u6210\u529f\uff01", sysUser.getUsername(), sysUser.getRealname());
        syncInfo.addSuccessInfo(str);
        return true;
    }

    private boolean syncUserCollectErrInfo(Exception e, User dtUser, SyncInfoVo syncInfo) {
        String msg;
        if (e instanceof DuplicateKeyException) {
            String workNoUniq;
            String emailUniq;
            msg = e.getCause().getMessage();
            if (msg.contains(emailUniq = "uniq_sys_user_email")) {
                msg = "\u90ae\u7bb1\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u90ae\u7bb1";
            }
            if (msg.contains(workNoUniq = "uniq_sys_user_work_no")) {
                msg = "\u5de5\u53f7\u91cd\u590d\uff0c\u8bf7\u66f4\u6362\u5de5\u53f7";
            }
        } else {
            msg = e.getMessage();
        }
        String str = String.format("\u7528\u6237 %s(%s) \u540c\u6b65\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a%s", dtUser.getUserid(), dtUser.getName(), msg);
        syncInfo.addFailInfo(str);
        return false;
    }

    private User sysUserToDtUser(SysUser sysUser, List<Department> allDepartment) {
        User user = new User();
        user.setUserid(sysUser.getUsername());
        return this.sysUserToDtUser(sysUser, user, allDepartment);
    }

    private User sysUserToDtUser(SysUser sysUser, User user, List<Department> allDepartment) {
        user.setName(sysUser.getRealname());
        user.setMobile(sysUser.getPhone());
        user.setTelephone(sysUser.getTelephone());
        user.setJob_number(sysUser.getWorkNo());
        List<SysPosition> positionList = this.sysPositionService.getPositionList(sysUser.getId());
        if (null != positionList && positionList.size() > 0) {
            String positionName = positionList.stream().map(SysPosition::getName).collect(Collectors.joining(","));
            user.setTitle(positionName);
        }
        user.setEmail(sysUser.getEmail());
        List<SysDepart> departList = this.getUserDepart(sysUser);
        if (departList != null) {
            ArrayList<Integer> departmentIdList = new ArrayList<Integer>();
            for (SysDepart sysDepart : departList) {
                Department department = this.getDepartmentByDepartId(sysDepart.getId(), allDepartment);
                if (department == null) continue;
                departmentIdList.add(department.getDept_id());
            }
            user.setDept_id_list(departmentIdList.toArray(new Integer[0]));
            user.setDept_order_list(null);
        }
        if (oConvertUtils.isEmpty((Object)user.getDept_id_list())) {
            user.setDept_id_list(new Integer[]{1});
            user.setDept_order_list(null);
        }
        return user;
    }

    private SysUser dtUserToSysUser(User dtUser) {
        SysUser sysUser = new SysUser();
        sysUser.setDelFlag(0);
        sysUser.setUsername(dtUser.getMobile());
        String password = "";
        String salt = oConvertUtils.randomGen((int)8);
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        if (tenantId > 0) {
            SysTenant tenant = (SysTenant)this.tenantMapper.selectById(Integer.valueOf(tenantId));
            password = tenant.getHouseNumber() + dtUser.getMobile();
        } else {
            password = dtUser.getMobile();
        }
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setSalt(salt);
        sysUser.setPassword(passwordEncode);
        sysUser.setStatus(1);
        return this.dtUserToSysUser(dtUser, sysUser);
    }

    private SysUser dtUserToSysUser(User dtUser, SysUser oldSysUser) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)oldSysUser, (Object)sysUser);
        sysUser.setTelephone(dtUser.getTelephone());
        if (oConvertUtils.isEmpty((Object)oldSysUser.getRealname())) {
            sysUser.setRealname(dtUser.getName());
        }
        if (oConvertUtils.isNotEmpty((Object)dtUser.getEmail()) && !dtUser.getEmail().equals(sysUser.getEmail())) {
            sysUser.setEmail(dtUser.getEmail());
        } else {
            sysUser.setEmail(null);
        }
        if (oConvertUtils.isNotEmpty((Object)dtUser.getMobile()) && !dtUser.getMobile().equals(sysUser.getPhone())) {
            sysUser.setPhone(dtUser.getMobile());
        } else {
            sysUser.setPhone(null);
        }
        if (oConvertUtils.isEmpty((Object)dtUser.getJob_number())) {
            sysUser.setWorkNo(dtUser.getUserid());
        } else {
            sysUser.setWorkNo(dtUser.getJob_number());
        }
        return sysUser;
    }

    private List<SysDepart> getUserDepart(SysUser sysUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserDepart::getUserId, (Object)sysUser.getId());
        List sysUserDepartList = this.sysUserDepartService.list((Wrapper)queryWrapper);
        if (sysUserDepartList.size() == 0) {
            return null;
        }
        LambdaQueryWrapper departQueryWrapper = new LambdaQueryWrapper();
        List departIdList = sysUserDepartList.stream().map(SysUserDepart::getDepId).collect(Collectors.toList());
        departQueryWrapper.in(SysDepart::getId, departIdList);
        List departList = this.sysDepartService.list((Wrapper)departQueryWrapper);
        return departList.size() == 0 ? null : departList;
    }

    private Department getDepartmentByDepartId(String departId, List<Department> allDepartment) {
        for (Department department : allDepartment) {
            if (!departId.equals(department.getSource_identifier())) continue;
            return department;
        }
        return null;
    }

    private Department sysDepartToDtDepartment(SysDepartTreeModel departTree, Integer parentId) {
        Department department = new Department();
        department.setSource_identifier(departTree.getId());
        return this.sysDepartToDtDepartment(departTree, department, parentId);
    }

    private Department sysDepartToDtDepartment(SysDepartTreeModel departTree, Department department, Integer parentId) {
        department.setName(departTree.getDepartName());
        department.setParent_id(parentId);
        department.setOrder(departTree.getDepartOrder());
        return department;
    }

    private SysDepart dtDepartmentToSysDepart(Department department, SysDepart departTree) {
        SysDepart sysDepart = new SysDepart();
        if (departTree != null) {
            BeanUtils.copyProperties((Object)departTree, (Object)sysDepart);
        }
        sysDepart.setDepartName(department.getName());
        sysDepart.setDepartOrder(department.getOrder());
        return sysDepart;
    }

    @Override
    public int removeThirdAppUser(List<String> userIdList) {
        SysThirdAppConfig appConfig = this.getDingThirdAppConfig();
        if (null == appConfig) {
            return -1;
        }
        int count = 0;
        if (userIdList != null && userIdList.size() > 0) {
            String accessToken = this.getTenantAccessToken(appConfig);
            if (accessToken == null) {
                return count;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"dingtalk");
            queryWrapper.in(SysThirdAccount::getSysUserId, userIdList);
            List thirdAccountList = this.sysThirdAccountService.list((Wrapper)queryWrapper);
            List thirdUserIdList = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            for (String thirdUserId : thirdUserIdList) {
                Response response;
                if (!oConvertUtils.isNotEmpty((Object)thirdUserId) || (response = JdtUserAPI.delete((String)thirdUserId, (String)accessToken)).getErrcode() != 0) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean sendMessage(MessageDTO message) {
        return this.sendMessage(message, false);
    }

    @Override
    public boolean sendMessage(MessageDTO message, boolean verifyConfig) {
        Response<String> response = message.isMarkdown() ? this.sendMarkdownResponse(message, verifyConfig) : this.sendMessageResponse(message, verifyConfig);
        if (response != null) {
            return response.isSuccess();
        }
        return false;
    }

    public Response<String> sendMarkdownResponse(MessageDTO message, boolean verifyConfig) {
        SysThirdAppConfig config = this.getDingThirdAppConfig();
        if (verifyConfig && null == config) {
            return null;
        }
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        String title = message.getTitle();
        String content = message.getContent();
        String agentId = config.getAgentId();
        Message mdMessage = new Message(agentId, (SuperMessage)new MarkdownMessage(title, content));
        if (message.getToAll().booleanValue()) {
            mdMessage.setTo_all_user(Boolean.valueOf(true));
        } else {
            String[] toUsers = message.getToUser().split(",");
            int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (Integer)CommonConstant.TENANT_ID_DEFAULT_VALUE);
            List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(toUsers, "dingtalk", tenantId);
            List dtUserIds = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            mdMessage.setUserid_list(dtUserIds);
        }
        return JdtMessageAPI.sendMarkdownMessage((Message)mdMessage, (String)accessToken);
    }

    public Response<String> sendMessageResponse(MessageDTO message, boolean verifyConfig) {
        SysThirdAppConfig config = this.getDingThirdAppConfig();
        if (verifyConfig && null == config) {
            return null;
        }
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            return null;
        }
        String content = message.getContent();
        String agentId = config.getAgentId();
        Message textMessage = new Message(agentId, (SuperMessage)new TextMessage(content));
        if (message.getToAll().booleanValue()) {
            textMessage.setTo_all_user(Boolean.valueOf(true));
        } else {
            String[] toUsers = message.getToUser().split(",");
            int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (Integer)CommonConstant.TENANT_ID_DEFAULT_VALUE);
            List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(toUsers, "dingtalk", tenantId);
            List dtUserIds = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            textMessage.setUserid_list(dtUserIds);
        }
        return JdtMessageAPI.sendTextMessage((Message)textMessage, (String)accessToken);
    }

    public boolean recallMessage(String msgTaskId) {
        Response<JSONObject> response = this.recallMessageResponse(msgTaskId);
        if (response == null) {
            return false;
        }
        return response.isSuccess();
    }

    public Response<JSONObject> recallMessageResponse(String msgTaskId) {
        SysThirdAppConfig config = this.getDingThirdAppConfig();
        String accessToken = this.getTenantAccessToken(config);
        if (accessToken == null) {
            return null;
        }
        String agentId = config.getAgentId();
        return JdtMessageAPI.recallMessage((String)agentId, (String)msgTaskId, (String)accessToken);
    }

    public Response<String> sendActionCardMessage(SysAnnouncement announcement, String ddMobileUrl, boolean verifyConfig) {
        LambdaQueryWrapper queryWrapper;
        SysThirdAppConfig config = this.getDingThirdAppConfig();
        if (verifyConfig && null == config) {
            return null;
        }
        String accessToken = this.getTenantAccessToken(config);
        if (accessToken == null) {
            return null;
        }
        String agentId = config.getAgentId();
        String emptySuffix = null;
        if (oConvertUtils.isNotEmpty((Object)announcement.getMsgAbstract())) {
            String msgAbstract = announcement.getMsgAbstract().trim();
            log.info("\u83b7\u53d6\u9489\u9489\u901a\u77e5\u53c2\u6570\uff0cmsgAbstract: {}", (Object)msgAbstract);
            emptySuffix = msgAbstract.startsWith("{") && msgAbstract.endsWith("}") ? announcement.getMsgContent() : msgAbstract;
        } else {
            emptySuffix = "\u7a7a";
        }
        String markdown = "### " + announcement.getTitile() + "\n" + emptySuffix;
        log.info("\u9489\u9489\u63a8\u9001\u53c2\u6570, markdown: {}", (Object)markdown);
        ActionCardMessage actionCard = new ActionCardMessage(markdown);
        actionCard.setTitle(announcement.getTitile());
        actionCard.setSingle_title("\u8be6\u60c5");
        String baseUrl = null;
        try {
            baseUrl = RestUtil.getBaseUrl();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            baseUrl = this.jeecgBaseConfig.getDomainUrl().getPc();
        }
        log.info("\u83b7\u53d6\u9489\u9489\u6253\u5f00\u7f51\u9875\u5730\u5740\uff0c\u53c2\u6570 ddMobileUrl: {}", (Object)ddMobileUrl);
        String ddSingleUrl = null;
        ddSingleUrl = oConvertUtils.isNotEmpty((Object)ddMobileUrl) ? ddMobileUrl : baseUrl + "/sys/annountCement/show/" + announcement.getId();
        actionCard.setSingle_url(ddSingleUrl);
        log.info("\u83b7\u53d6\u9489\u9489\u6253\u5f00\u7f51\u9875\u5730\u5740\uff0c\u6700\u7ec8\u5730\u5740 ddSingleUrl: {}", (Object)ddSingleUrl);
        Message actionCardMessage = new Message(agentId, (SuperMessage)actionCard);
        if ("ALL".equals(announcement.getMsgType())) {
            actionCardMessage.setTo_all_user(Boolean.valueOf(true));
            return JdtMessageAPI.sendActionCardMessage((Message)actionCardMessage, (String)accessToken);
        }
        Object[] userIds = null;
        String userId = announcement.getUserIds();
        if (oConvertUtils.isNotEmpty((Object)userId)) {
            userIds = userId.substring(0, userId.length() - 1).split(",");
        } else {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)announcement.getId());
            SysAnnouncementSend sysAnnouncementSend = (SysAnnouncementSend)this.sysAnnouncementSendMapper.selectOne((Wrapper)queryWrapper);
            userIds = new String[]{sysAnnouncementSend.getUserId()};
        }
        if (userIds != null) {
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(SysUser::getId, userIds);
            List userList = this.userMapper.selectList((Wrapper)queryWrapper);
            String[] usernameList = (String[])userList.stream().map(SysUser::getUsername).toArray(String[]::new);
            int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (Integer)CommonConstant.TENANT_ID_DEFAULT_VALUE);
            List<SysThirdAccount> thirdAccountList = this.sysThirdAccountService.listThirdUserIdByUsername(usernameList, "dingtalk", tenantId);
            List dtUserIds = thirdAccountList.stream().map(SysThirdAccount::getThirdUserId).collect(Collectors.toList());
            actionCardMessage.setUserid_list(dtUserIds);
            return JdtMessageAPI.sendActionCardMessage((Message)actionCardMessage, (String)accessToken);
        }
        return null;
    }

    public SysUser oauth2Login(String authCode, Integer tenantId) {
        this.tenantIzExist(tenantId);
        SysThirdAppConfig dtConfig = this.configMapper.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
        String userAccessToken = JdtOauth2API.getUserAccessToken((String)dtConfig.getClientId(), (String)dtConfig.getClientSecret(), (String)authCode);
        if (userAccessToken == null) {
            log.error("oauth2Login userAccessToken is null");
            throw new JeecgBootException("\u8bf7\u67e5\u770b\u5e94\u7528key\u548c\u5e94\u7528\u79d8\u94a5\u662f\u5426\u6b63\u786e\uff0c\u7ec4\u7ec7ID\u662f\u5426\u5339\u914d");
        }
        ContactUser contactUser = JdtOauth2API.getContactUsers((String)"me", (String)userAccessToken);
        if (contactUser == null) {
            log.error("oauth2Login contactUser is null");
            throw new JeecgBootException("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String unionId = contactUser.getUnionId();
        String accessToken = this.getTenantAccessToken(dtConfig);
        if (accessToken == null) {
            log.error("oauth2Login accessToken is null");
            throw new JeecgBootException("\u8bf7\u67e5\u770b\u5e94\u7528key\u548c\u5e94\u7528\u79d8\u94a5\u662f\u5426\u6b63\u786e\uff0c\u7ec4\u7ec7ID\u662f\u5426\u5339\u914d");
        }
        Response getUserIdRes = JdtUserAPI.getUseridByUnionid((String)unionId, (String)accessToken);
        if (!getUserIdRes.isSuccess()) {
            log.error("oauth2Login getUseridByUnionid failed: " + JSON.toJSONString((Object)getUserIdRes));
            throw new JeecgBootException("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String appUserId = (String)getUserIdRes.getResult();
        log.info("appUserId: " + appUserId);
        if (appUserId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"dingtalk");
            queryWrapper.eq(SysThirdAccount::getTenantId, (Object)tenantId);
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysThirdAccount::getThirdUserUuid, (Object)appUserId)).or()).eq(SysThirdAccount::getThirdUserId, (Object)appUserId));
            SysThirdAccount thirdAccount = (SysThirdAccount)this.sysThirdAccountService.getOne((Wrapper)queryWrapper);
            if (thirdAccount != null) {
                return this.getSysUserByThird(thirdAccount, null, appUserId, accessToken, tenantId);
            }
            User appUser = (User)JdtUserAPI.getUserById((String)appUserId, (String)accessToken).getResult();
            ThirdLoginModel tlm = new ThirdLoginModel("dingtalk", appUser.getUnionid(), appUser.getName(), appUser.getAvatar());
            thirdAccount = this.sysThirdAccountService.saveThirdUser(tlm, tenantId);
            return this.getSysUserByThird(thirdAccount, appUser, null, null, tenantId);
        }
        return null;
    }

    private SysUser getSysUserByThird(SysThirdAccount thirdAccount, User appUser, String appUserId, String accessToken, Integer tenantId) {
        SysUser sysUser;
        String sysUserId = thirdAccount.getSysUserId();
        if (oConvertUtils.isNotEmpty((Object)sysUserId)) {
            return (SysUser)this.userMapper.selectById((Serializable)((Object)sysUserId));
        }
        if (appUser == null) {
            appUser = (User)JdtUserAPI.getUserById((String)appUserId, (String)accessToken).getResult();
        }
        if ((sysUser = this.userMapper.getUserByPhone(appUser.getMobile())) != null) {
            thirdAccount.setAvatar(appUser.getAvatar());
            thirdAccount.setRealname(appUser.getName());
            thirdAccount.setThirdUserId(appUser.getUserid());
            thirdAccount.setThirdUserUuid(appUser.getUnionid());
            thirdAccount.setSysUserId(sysUser.getId());
            this.sysThirdAccountService.updateById(thirdAccount);
            return sysUser;
        }
        return this.sysThirdAccountService.createUser(appUser.getMobile(), appUser.getUnionid(), tenantId);
    }

    private SysThirdAppConfig getDingThirdAppConfig() {
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        this.tenantIzExist(tenantId);
        return this.configMapper.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
    }

    private String getTenantAccessToken(SysThirdAppConfig config) {
        if (null == config) {
            return null;
        }
        AccessToken accessToken = JdtBaseAPI.getAccessToken((String)config.getClientId(), (String)config.getClientSecret());
        if (accessToken != null) {
            return accessToken.getAccessToken();
        }
        log.warn("\u83b7\u53d6AccessToken\u5931\u8d25");
        return null;
    }

    private void createUserTenant(String userId, Boolean isUpdate) {
        int tenantId;
        Integer count;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && (count = this.userTenantMapper.userTenantIzExist(userId, tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0))) == 0) {
            SysUserTenant userTenant = new SysUserTenant();
            userTenant.setTenantId(tenantId);
            userTenant.setUserId(userId);
            userTenant.setStatus(isUpdate != false ? "3" : "1");
            this.userTenantMapper.insert(userTenant);
        }
    }

    public SyncInfoVo syncThirdAppDepartmentUserToLocal() {
        SyncInfoVo syncInfo = new SyncInfoVo();
        String accessToken = this.getAccessToken();
        if (accessToken == null) {
            syncInfo.addFailInfo("accessToken\u83b7\u53d6\u5931\u8d25\uff01");
            return syncInfo;
        }
        List departments = JdtDepartmentAPI.listAll((String)accessToken);
        if (departments.isEmpty()) {
            throw new JeecgBootBizTipException("\u8bf7\u67e5\u770b\u914d\u7f6e\u53c2\u6570\u548c\u767d\u540d\u5355\u662f\u5426\u914d\u7f6e\uff01");
        }
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        List<JdtDepartmentTreeVo> departmentTreeList = JdtDepartmentTreeVo.listToTree(departments);
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        this.syncDepartmentToLocalRecursion(departmentTreeList, null, username, syncInfo, accessToken, true, tenantId);
        return syncInfo;
    }

    private void addDepartUser(String departId, Integer dingDepartId, String accessToken, SyncInfoVo syncInfo, Set<String> syncedUserIdSet, Integer tenantId) {
        ArrayList<User> userList = new ArrayList<User>();
        this.getUserListByDeptIdRecursion(dingDepartId, 0, userList, accessToken);
        for (User user : userList) {
            String str;
            if (syncedUserIdSet.contains(user.getUserid())) {
                this.syncAddOrUpdateUserDepart(user.getUserid(), departId);
                continue;
            }
            syncedUserIdSet.add(user.getUserid());
            SysUser userByPhone = this.userMapper.getUserByPhone(user.getMobile());
            SysThirdAccount sysThirdAccount = this.sysThirdAccountService.getOneByUuidAndThirdType(user.getUnionid(), "dingtalk", tenantId, user.getUserid());
            if (null != userByPhone) {
                SysUser updateSysUser = this.dtUserToSysUser(user, userByPhone);
                try {
                    this.userMapper.updateById(updateSysUser);
                    str = String.format("\u7528\u6237 %s(%s) \u66f4\u65b0\u6210\u529f\uff01", updateSysUser.getRealname(), updateSysUser.getUsername());
                    if (!syncInfo.getSuccessInfo().contains(str)) {
                        syncInfo.addSuccessInfo(str);
                    }
                }
                catch (Exception e) {
                    this.syncUserCollectErrInfo(e, user, syncInfo);
                }
                this.thirdAccountSaveOrUpdate(sysThirdAccount, updateSysUser.getId(), user, tenantId);
                this.createUserTenant(updateSysUser.getId(), true);
                this.syncAddOrUpdateUserDepart(updateSysUser.getId(), departId);
                continue;
            }
            SysUser newSysUser = this.dtUserToSysUser(user);
            try {
                this.userMapper.insert(newSysUser);
                str = String.format("\u7528\u6237 %s(%s) \u521b\u5efa\u6210\u529f\uff01", newSysUser.getRealname(), newSysUser.getUsername());
                syncInfo.addSuccessInfo(str);
            }
            catch (Exception e) {
                this.syncUserCollectErrInfo(e, user, syncInfo);
            }
            this.thirdAccountSaveOrUpdate(sysThirdAccount, newSysUser.getId(), user, tenantId);
            this.createUserTenant(newSysUser.getId(), false);
            this.syncAddOrUpdateUserDepart(newSysUser.getId(), departId);
        }
    }

    private void syncAddOrUpdateUserDepart(String userId, String departId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserDepart::getDepId, (Object)departId);
        query.eq(SysUserDepart::getUserId, (Object)userId);
        long count = this.sysUserDepartService.count((Wrapper)query);
        if (count == 0L) {
            SysUserDepart sysUserDepart = new SysUserDepart(null, userId, departId);
            this.sysUserDepartService.save(sysUserDepart);
        }
    }

    public void tenantIzExist(Integer tenantId) {
        Long count;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && (ObjectUtil.isEmpty((Object)(count = this.tenantMapper.tenantIzExist(tenantId))) || 0L == count)) {
            throw new JeecgBootException("\u79df\u6237ID:" + tenantId + "\u65e0\u6548\uff0c\u5e73\u53f0\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
    }

    public SysUser oauthDingDingLogin(String authCode, Integer tenantId) {
        Long count = this.tenantMapper.tenantIzExist(tenantId);
        if (ObjectUtil.isEmpty((Object)count) || 0L == count) {
            throw new JeecgBootException("\u79df\u6237\u4e0d\u5b58\u5728\uff01");
        }
        SysThirdAppConfig config = this.configMapper.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
        String accessToken = this.getTenantAccessToken(config);
        if (StringUtils.isEmpty((String)accessToken)) {
            throw new JeecgBootBizTipException("accessToken\u83b7\u53d6\u5931\u8d25");
        }
        String getUserInfoUrl = "https://oapi.dingtalk.com/topapi/v2/user/getuserinfo?access_token=" + accessToken;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", authCode);
        Response userInfoResponse = HttpUtil.post((String)getUserInfoUrl, (String)JSON.toJSONString(params), (Type[])new Type[0]);
        if (userInfoResponse.isSuccess()) {
            String userId = ((JSONObject)userInfoResponse.getResult()).getString("userid");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysThirdAccount::getThirdType, (Object)"dingtalk");
            queryWrapper.eq(SysThirdAccount::getTenantId, (Object)tenantId);
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysThirdAccount::getThirdUserUuid, (Object)userId)).or()).eq(SysThirdAccount::getThirdUserId, (Object)userId));
            SysThirdAccount thirdAccount = (SysThirdAccount)this.sysThirdAccountService.getOne((Wrapper)queryWrapper);
            if (thirdAccount != null) {
                return this.getSysUserByThird(thirdAccount, null, userId, accessToken, tenantId);
            }
            throw new JeecgBootException("\u8be5\u7528\u6237\u6ca1\u6709\u540c\u6b65\uff0c\u8bf7\u5148\u540c\u6b65\uff01");
        }
        return null;
    }

    public SysThirdAppConfig getCorpIdClientId(Integer tenantId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThirdAppConfig::getThirdType, (Object)"dingtalk");
        queryWrapper.eq(SysThirdAppConfig::getTenantId, (Object)tenantId);
        queryWrapper.select((Object[])new SFunction[]{SysThirdAppConfig::getCorpId, SysThirdAppConfig::getClientId});
        return (SysThirdAppConfig)this.configMapper.selectOne((Wrapper)queryWrapper);
    }
}

