/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.mapper.SysTenantPackUserMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserPositionMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.service.ISysUserTenantService;
import org.jeecg.modules.system.vo.SysUserDepVo;
import org.jeecg.modules.system.vo.SysUserTenantVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserTenantServiceImpl
extends ServiceImpl<SysUserTenantMapper, SysUserTenant>
implements ISysUserTenantService {
    @Autowired
    private SysUserTenantMapper userTenantMapper;
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysUserPositionMapper userPositionMapper;
    @Autowired
    private SysTenantPackUserMapper packUserMapper;

    @Override
    public Page<SysUser> getPageUserList(Page<SysUser> page, Integer userTenantId, SysUser user) {
        return page.setRecords(this.userTenantMapper.getPageUserList(page, userTenantId, user));
    }

    @Override
    public List<SysUser> setUserTenantIds(List<SysUser> records) {
        if (null == records || records.size() == 0) {
            return records;
        }
        for (SysUser sysUser : records) {
            List<Integer> list = this.userTenantMapper.getTenantIdsByUserId(sysUser.getId());
            if (oConvertUtils.isNotEmpty(list)) {
                sysUser.setRelTenantIds(StringUtils.join((Object[])list.toArray(), (String)","));
                continue;
            }
            sysUser.setRelTenantIds("");
        }
        return records;
    }

    @Override
    public List<String> getUserIdsByTenantId(Integer tenantId) {
        return this.userTenantMapper.getUserIdsByTenantId(tenantId);
    }

    @Override
    public List<Integer> getTenantIdsByUserId(String userId) {
        return this.userTenantMapper.getTenantIdsByUserId(userId);
    }

    @Override
    public List<SysUserTenantVo> getTenantListByUserId(String userId, List<String> userTenantStatus) {
        return this.userTenantMapper.getTenantListByUserId(userId, userTenantStatus);
    }

    @Override
    public void updateUserTenantStatus(String id, String tenantId, String userTenantStatus) {
        if (oConvertUtils.isEmpty((Object)tenantId)) {
            throw new JeecgBootException("\u79df\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getUserId, (Object)id);
        query.eq(SysUserTenant::getTenantId, (Object)Integer.valueOf(tenantId));
        SysUserTenant userTenant = (SysUserTenant)this.userTenantMapper.selectOne((Wrapper)query);
        if (null == userTenant) {
            throw new JeecgBootException("\u79df\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        SysUserTenant tenant = new SysUserTenant();
        tenant.setStatus(userTenantStatus);
        this.update(tenant, (Wrapper)query);
    }

    @Override
    public IPage<SysUserTenantVo> getUserTenantPageList(Page<SysUserTenantVo> page, List<String> status, SysUser user, Integer tenantId) {
        List<SysUserTenantVo> tenantPageList = this.userTenantMapper.getUserTenantPageList(page, status, user, tenantId);
        List<String> userIds = tenantPageList.stream().map(SysUserTenantVo::getId).collect(Collectors.toList());
        if (userIds != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.getDepNamesByUserIds(userIds);
            tenantPageList.forEach(item -> {
                item.setOrgCodeTxt((String)useDepNames.get(item.getId()));
                List<Integer> list = this.userTenantMapper.getTenantIdsNoStatus(item.getId());
                if (oConvertUtils.isNotEmpty(list)) {
                    item.setRelTenantIds(StringUtils.join((Object[])list.toArray(), (String)","));
                } else {
                    item.setRelTenantIds("");
                }
                List<String> positionList = this.userPositionMapper.getPositionIdByUserId(item.getId());
                item.setPost(CommonUtils.getSplitText(positionList, (String)","));
            });
        }
        return page.setRecords(tenantPageList);
    }

    public Map<String, String> getDepNamesByUserIds(List<String> userIds) {
        List<SysUserDepVo> list = this.userMapper.getDepNamesByUserIds(userIds);
        HashMap<String, String> res = new HashMap<String, String>(5);
        list.forEach(item -> {
            if (res.get(item.getUserId()) == null) {
                res.put(item.getUserId(), item.getDepartName());
            } else {
                res.put(item.getUserId(), (String)res.get(item.getUserId()) + "," + item.getDepartName());
            }
        });
        return res;
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void putCancelQuit(List<String> userIds, Integer tenantId) {
        this.userTenantMapper.putCancelQuit(userIds, tenantId);
    }

    @Override
    public Integer userTenantIzExist(String userId, Integer tenantId) {
        return this.userTenantMapper.userTenantIzExist(userId, tenantId);
    }

    @Override
    public IPage<SysTenant> getTenantPageListByUserId(Page<SysTenant> page, String userId, List<String> userTenantStatus, SysUserTenantVo sysUserTenantVo) {
        return page.setRecords(this.userTenantMapper.getTenantPageListByUserId(page, userId, userTenantStatus, sysUserTenantVo));
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void agreeJoinTenant(String userId, Integer tenantId) {
        this.userTenantMapper.agreeJoinTenant(userId, tenantId);
    }

    @Override
    public void refuseJoinTenant(String userId, Integer tenantId) {
        this.userTenantMapper.refuseJoinTenant(userId, tenantId);
    }

    @Override
    public SysUserTenant getUserTenantByTenantId(String userId, Integer tenantId) {
        return this.userTenantMapper.getUserTenantByTenantId(userId, tenantId);
    }

    @Override
    public Long getUserCount(Integer tenantId, String tenantStatus) {
        return this.userTenantMapper.getUserCount(tenantId, tenantStatus);
    }
}

