/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserPosition;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserPositionMapper;
import org.jeecg.modules.system.service.ISysUserPositionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserPositionServiceImpl
extends ServiceImpl<SysUserPositionMapper, SysUserPosition>
implements ISysUserPositionService {
    @Autowired
    private SysUserPositionMapper sysUserPositionMapper;
    @Autowired
    private SysUserMapper userMapper;

    @Override
    public IPage<SysUser> getPositionUserList(Page<SysUser> page, String positionId) {
        return page.setRecords(this.sysUserPositionMapper.getPositionUserList(page, positionId));
    }

    @Override
    public void saveUserPosition(String userIds, String positionId) {
        String[] userIdArray = userIds.split(",");
        StringBuilder userBuilder = new StringBuilder();
        for (String userId : userIdArray) {
            Long count = this.sysUserPositionMapper.getUserPositionCount(userId, positionId);
            if (count == 0L) {
                SysUserPosition userPosition = new SysUserPosition();
                userPosition.setPositionId(positionId);
                userPosition.setUserId(userId);
                this.sysUserPositionMapper.insert(userPosition);
                continue;
            }
            userBuilder.append(userId).append(",");
        }
        String uIds = userBuilder.toString();
        if (oConvertUtils.isNotEmpty((Object)uIds)) {
            List sysUsers = this.userMapper.selectBatchIds(Arrays.asList(uIds.split(",")));
            String realnames = sysUsers.stream().map(SysUser::getRealname).collect(Collectors.joining(","));
            throw new JeecgBootException(realnames + "\u5df2\u5b58\u5728\u8be5\u804c\u4f4d\u4e2d");
        }
    }

    @Override
    public void removeByPositionId(String positionId) {
        this.sysUserPositionMapper.removeByPositionId(positionId);
    }

    @Override
    public void removePositionUser(String userIds, String positionId) {
        String[] userIdArray = userIds.split(",");
        this.sysUserPositionMapper.removePositionUser(Arrays.asList(userIdArray), positionId);
    }
}

