/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.aop.TenantLog;
import org.jeecg.modules.system.entity.SysPackPermission;
import org.jeecg.modules.system.entity.SysTenantPack;
import org.jeecg.modules.system.entity.SysTenantPackUser;
import org.jeecg.modules.system.mapper.SysPackPermissionMapper;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysTenantPackMapper;
import org.jeecg.modules.system.mapper.SysTenantPackUserMapper;
import org.jeecg.modules.system.service.ISysTenantPackService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysTenantPackServiceImpl
extends ServiceImpl<SysTenantPackMapper, SysTenantPack>
implements ISysTenantPackService {
    @Autowired
    private SysTenantPackMapper sysTenantPackMapper;
    @Autowired
    private SysTenantPackUserMapper sysTenantPackUserMapper;
    @Autowired
    private SysPackPermissionMapper sysPackPermissionMapper;
    @Autowired
    private SysRoleMapper sysRoleMapper;

    @Override
    public void addPackPermission(SysTenantPack sysTenantPack) {
        this.sysTenantPackMapper.insert(sysTenantPack);
        String permissionIds = sysTenantPack.getPermissionIds();
        if (oConvertUtils.isNotEmpty((Object)permissionIds)) {
            String[] permissionIdArray;
            String packId = sysTenantPack.getId();
            for (String permissionId : permissionIdArray = permissionIds.split(",")) {
                this.addPermission(packId, permissionId);
            }
        }
    }

    @Override
    public List<SysTenantPack> setPermissions(List<SysTenantPack> records) {
        for (SysTenantPack pack : records) {
            List<String> permissionIds = this.sysPackPermissionMapper.getPermissionsByPackId(pack.getId());
            if (null == permissionIds || permissionIds.size() <= 0) continue;
            String ids = String.join((CharSequence)",", permissionIds);
            pack.setPermissionIds(ids);
        }
        return records;
    }

    @Override
    public void editPackPermission(SysTenantPack sysTenantPack) {
        List<String> oldPermissionIds = this.sysPackPermissionMapper.getPermissionsByPackId(sysTenantPack.getId());
        String permissionIds = sysTenantPack.getPermissionIds();
        if (oConvertUtils.isEmpty((Object)permissionIds)) {
            this.deletePackPermission(sysTenantPack.getId(), null);
        } else if (oConvertUtils.isNotEmpty((Object)permissionIds) && oConvertUtils.isEmpty(oldPermissionIds)) {
            this.addPermission(sysTenantPack.getId(), permissionIds);
        } else if (oConvertUtils.isNotEmpty(oldPermissionIds)) {
            List permissionAddList;
            List permissionList = oldPermissionIds.stream().filter(item -> !permissionIds.contains((CharSequence)item)).collect(Collectors.toList());
            if (permissionList.size() > 0) {
                for (String permission : permissionList) {
                    this.deletePackPermission(sysTenantPack.getId(), permission);
                }
            }
            if ((permissionAddList = Arrays.stream(permissionIds.split(",")).filter(item -> !oldPermissionIds.contains(item)).collect(Collectors.toList())).size() > 0) {
                for (String permission : permissionAddList) {
                    this.addPermission(sysTenantPack.getId(), permission);
                }
            }
        }
        this.sysTenantPackMapper.updateById(sysTenantPack);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTenantPack(String ids) {
        String[] idsArray;
        for (String id : idsArray = ids.split(",")) {
            this.deletePackPermission(id, null);
            this.deletePackUser(id);
            this.sysTenantPackMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public void exitTenant(String tenantId, String userId) {
        this.getById((Serializable)((Object)tenantId));
    }

    @Override
    public void addDefaultTenantPack(Integer tenantId) {
        ISysTenantPackService currentService = (ISysTenantPackService)SpringContextUtils.getApplicationContext().getBean(ISysTenantPackService.class);
        SysTenantPack superAdminPack = new SysTenantPack(tenantId, "\u8d85\u7ea7\u7ba1\u7406\u5458", "superAdmin");
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenantPack::getTenantId, (Object)tenantId);
        query.eq(SysTenantPack::getPackCode, (Object)"superAdmin");
        SysTenantPack sysTenantPackSuperAdmin = (SysTenantPack)currentService.getOne((Wrapper)query);
        String packId = "";
        packId = null == sysTenantPackSuperAdmin ? currentService.saveOne(superAdminPack) : sysTenantPackSuperAdmin.getId();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        SysTenantPackUser packUser = new SysTenantPackUser(tenantId, packId, sysUser.getId());
        packUser.setRealname(sysUser.getRealname());
        packUser.setPackName(superAdminPack.getPackName());
        currentService.savePackUser(packUser);
        query.eq(SysTenantPack::getTenantId, (Object)tenantId);
        query.eq(SysTenantPack::getPackCode, (Object)"accountAdmin");
        SysTenantPack sysTenantPackAccountAdmin = (SysTenantPack)currentService.getOne((Wrapper)query);
        if (null == sysTenantPackAccountAdmin) {
            SysTenantPack accountAdminPack = new SysTenantPack(tenantId, "\u7ec4\u7ec7\u8d26\u6237\u7ba1\u7406\u5458", "accountAdmin");
            currentService.saveOne(accountAdminPack);
        }
        query.eq(SysTenantPack::getTenantId, (Object)tenantId);
        query.eq(SysTenantPack::getPackCode, (Object)"appAdmin");
        SysTenantPack sysTenantPackAppAdmin = (SysTenantPack)currentService.getOne((Wrapper)query);
        if (null == sysTenantPackAppAdmin) {
            SysTenantPack appAdminPack = new SysTenantPack(tenantId, "\u7ec4\u7ec7\u5e94\u7528\u7ba1\u7406\u5458", "appAdmin");
            currentService.saveOne(appAdminPack);
        }
    }

    @Override
    @TenantLog(value=2)
    public String saveOne(SysTenantPack sysTenantPack) {
        this.sysTenantPackMapper.insert(sysTenantPack);
        return sysTenantPack.getId();
    }

    @Override
    @TenantLog(value=2)
    public void savePackUser(SysTenantPackUser sysTenantPackUser) {
        sysTenantPackUser.setStatus(1);
        this.sysTenantPackUserMapper.insert(sysTenantPackUser);
    }

    @Override
    public SysTenantPack getSysTenantPack(Integer tenantId, String packCode) {
        SysTenantPack pack;
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPack::getPackCode, (Object)packCode)).eq(SysTenantPack::getTenantId, (Object)tenantId);
        List list = ((SysTenantPackMapper)this.baseMapper).selectList((Wrapper)query);
        if (list != null && list.size() > 0 && (pack = (SysTenantPack)list.get(0)) != null && pack.getId() != null) {
            return pack;
        }
        return null;
    }

    public void addPermission(String packId, String permissionId) {
        SysPackPermission permission = new SysPackPermission();
        permission.setPermissionId(permissionId);
        permission.setPackId(packId);
        this.sysPackPermissionMapper.insert(permission);
    }

    public void deletePackPermission(String packId, String permissionId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysPackPermission::getPackId, (Object)packId);
        if (oConvertUtils.isNotEmpty((Object)permissionId)) {
            query.eq(SysPackPermission::getPermissionId, (Object)permissionId);
        }
        this.sysPackPermissionMapper.delete((Wrapper)query);
    }

    @Override
    public void addTenantDefaultPack(Integer tenantId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenantPack::getPackType, (Object)"default");
        List sysTenantPacks = this.sysTenantPackMapper.selectList((Wrapper)query);
        for (SysTenantPack sysTenantPack : sysTenantPacks) {
            this.syncDefaultPack2CurrentTenant(tenantId, sysTenantPack);
        }
    }

    @Override
    public void syncDefaultPack(Integer tenantId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenantPack::getPackType, (Object)"default");
        List sysDefaultTenantPacks = this.sysTenantPackMapper.selectList((Wrapper)query);
        query = new LambdaQueryWrapper();
        query.eq(SysTenantPack::getPackType, (Object)"custom");
        query.eq(SysTenantPack::getTenantId, (Object)tenantId);
        List currentTenantPacks = this.sysTenantPackMapper.selectList((Wrapper)query);
        Map<Object, Object> currentTenantPackMap = new HashMap();
        if (oConvertUtils.listIsNotEmpty((Collection)currentTenantPacks)) {
            currentTenantPackMap = currentTenantPacks.stream().collect(Collectors.toMap(SysTenantPack::getPackName, o -> o, (existing, replacement) -> existing));
        }
        for (SysTenantPack defaultPacks : sysDefaultTenantPacks) {
            if (currentTenantPackMap.containsKey(defaultPacks.getPackName())) continue;
            this.syncDefaultPack2CurrentTenant(tenantId, defaultPacks);
        }
    }

    private void syncDefaultPack2CurrentTenant(Integer tenantId, SysTenantPack defaultPacks) {
        SysTenantPack pack = new SysTenantPack();
        BeanUtils.copyProperties((Object)defaultPacks, (Object)pack);
        pack.setTenantId(tenantId);
        pack.setPackType("custom");
        pack.setId("");
        this.sysTenantPackMapper.insert(pack);
        List<String> permissionsByPackId = this.sysPackPermissionMapper.getPermissionsByPackId(defaultPacks.getId());
        for (String permission : permissionsByPackId) {
            SysPackPermission packPermission = new SysPackPermission();
            packPermission.setPackId(pack.getId());
            packPermission.setPermissionId(permission);
            this.sysPackPermissionMapper.insert(packPermission);
        }
    }

    private void deletePackUser(String packId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenantPackUser::getPackId, (Object)packId);
        this.sysTenantPackUserMapper.delete((Wrapper)query);
    }
}

