/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.enums.FileTypeEnum;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.SysFilesModel;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysComment;
import org.jeecg.modules.system.entity.SysFormFile;
import org.jeecg.modules.system.mapper.SysCommentMapper;
import org.jeecg.modules.system.mapper.SysFormFileMapper;
import org.jeecg.modules.system.service.ISysCommentService;
import org.jeecg.modules.system.vo.SysCommentFileVo;
import org.jeecg.modules.system.vo.SysCommentVO;
import org.jeecg.modules.system.vo.UserAvatar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class SysCommentServiceImpl
extends ServiceImpl<SysCommentMapper, SysComment>
implements ISysCommentService {
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Autowired
    private SysFormFileMapper sysFormFileMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${jeecg.path.upload}")
    private String uploadpath;
    @Value(value="${jeecg.uploadType}")
    private String uploadType;
    private static final String SYS_FORM_FILE_TABLE_NAME = "sys_comment";

    @Override
    public List<SysCommentVO> queryFormCommentInfo(SysComment sysComment) {
        String tableName = sysComment.getTableName();
        String dataId = sysComment.getTableDataId();
        List<SysCommentVO> list = ((SysCommentMapper)this.baseMapper).queryCommentList(tableName, dataId);
        HashSet<String> personSet = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (SysCommentVO vo : list) {
                if (oConvertUtils.isNotEmpty((Object)vo.getFromUserId())) {
                    personSet.add(vo.getFromUserId());
                }
                if (!oConvertUtils.isNotEmpty((Object)vo.getToUserId())) continue;
                personSet.add(vo.getToUserId());
            }
        }
        if (personSet.size() > 0) {
            Map<String, UserAvatar> userAvatarMap = this.queryUserAvatar(personSet);
            for (SysCommentVO vo : list) {
                UserAvatar toUser;
                UserAvatar fromUser;
                String formId = vo.getFromUserId();
                String toId = vo.getToUserId();
                if (oConvertUtils.isNotEmpty((Object)formId) && (fromUser = userAvatarMap.get(formId)) != null) {
                    vo.setFromUserId_dictText(fromUser.getRealname());
                    vo.setFromUserAvatar(fromUser.getAvatar());
                }
                if (!oConvertUtils.isNotEmpty((Object)toId) || (toUser = userAvatarMap.get(toId)) == null) continue;
                vo.setToUserId_dictText(toUser.getRealname());
                vo.setToUserAvatar(toUser.getAvatar());
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOneFileComment(HttpServletRequest request) {
        String existFileId = request.getParameter("fileId");
        if (oConvertUtils.isEmpty((Object)existFileId)) {
            String savePath = "";
            String bizPath = request.getParameter("biz");
            if (oConvertUtils.isNotEmpty((Object)bizPath) && (bizPath.contains("../") || bizPath.contains("..\\"))) {
                throw new JeecgBootException("\u4e0a\u4f20\u76ee\u5f55bizPath\uff0c\u683c\u5f0f\u975e\u6cd5\uff01");
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile file = multipartRequest.getFile("file");
            if (oConvertUtils.isEmpty((Object)bizPath)) {
                bizPath = "alioss".equals(this.uploadType) ? "upload" : "";
            }
            savePath = "local".equals(this.uploadType) ? this.uploadLocal(file, bizPath) : CommonUtils.upload((MultipartFile)file, (String)bizPath, (String)this.uploadType);
            String orgName = file.getOriginalFilename();
            orgName = CommonUtils.getFileName((String)orgName);
            long size = file.getSize();
            String type = orgName.substring(orgName.lastIndexOf("."), orgName.length());
            FileTypeEnum fileType = FileTypeEnum.getByType((String)type);
            SysFilesModel sysFiles = new SysFilesModel();
            sysFiles.setFileName(orgName);
            sysFiles.setUrl(savePath);
            sysFiles.setFileType(fileType.getValue());
            sysFiles.setStoreType("temp");
            if (size > 0L) {
                sysFiles.setFileSize(Double.valueOf(Double.parseDouble(String.valueOf(size))));
            }
            String fileId = String.valueOf(IdWorker.getId());
            sysFiles.setId(fileId);
            String tenantId = oConvertUtils.getString((String)TenantContext.getTenant());
            sysFiles.setTenantId(tenantId);
            String tableName = SYS_FORM_FILE_TABLE_NAME;
            String tableDataId = request.getParameter("commentId");
            SysFormFile sysFormFile = new SysFormFile();
            sysFormFile.setTableName(tableName);
            sysFormFile.setFileType(fileType.getValue());
            sysFormFile.setTableDataId(tableDataId);
            sysFormFile.setFileId(fileId);
            this.sysFormFileMapper.insert(sysFormFile);
        } else {
            String tableName = SYS_FORM_FILE_TABLE_NAME;
            String tableDataId = request.getParameter("commentId");
            SysFormFile sysFormFile = new SysFormFile();
            sysFormFile.setTableName(tableName);
            sysFormFile.setFileType("");
            sysFormFile.setTableDataId(tableDataId);
            sysFormFile.setFileId(existFileId);
            this.sysFormFileMapper.insert(sysFormFile);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void appSaveOneFileComment(HttpServletRequest request) {
        String orgName = request.getParameter("fileName");
        String fileSize = request.getParameter("fileSize");
        String savePath = request.getParameter("savePath");
        orgName = CommonUtils.getFileName((String)orgName);
        long size = Long.valueOf(fileSize);
        String type = orgName.substring(orgName.lastIndexOf("."), orgName.length());
        FileTypeEnum fileType = FileTypeEnum.getByType((String)type);
        SysFilesModel sysFiles = new SysFilesModel();
        sysFiles.setFileName(orgName);
        sysFiles.setUrl(savePath);
        sysFiles.setFileType(fileType.getValue());
        sysFiles.setStoreType("temp");
        if (size > 0L) {
            sysFiles.setFileSize(Double.valueOf(Double.parseDouble(String.valueOf(size))));
        }
        String defaultValue = "0";
        String fileId = String.valueOf(IdWorker.getId());
        sysFiles.setId(fileId);
        String tenantId = oConvertUtils.getString((String)TenantContext.getTenant());
        sysFiles.setTenantId(tenantId);
        String tableName = SYS_FORM_FILE_TABLE_NAME;
        String tableDataId = request.getParameter("commentId");
        SysFormFile sysFormFile = new SysFormFile();
        sysFormFile.setTableName(tableName);
        sysFormFile.setFileType(fileType.getValue());
        sysFormFile.setTableDataId(tableDataId);
        sysFormFile.setFileId(fileId);
        this.sysFormFileMapper.insert(sysFormFile);
    }

    @Override
    public List<SysCommentFileVo> queryFormFileList(String tableName, String formDataId) {
        List<SysCommentFileVo> list = ((SysCommentMapper)this.baseMapper).queryFormFileList(tableName, formDataId);
        return list;
    }

    @Override
    public String saveOne(SysComment sysComment) {
        Set<String> set;
        this.save(sysComment);
        String content = sysComment.getCommentContent();
        if (content.indexOf("@") >= 0 && (set = this.getCommentUsername(content)).size() > 0) {
            String users = String.join((CharSequence)",", set);
            MessageDTO md = new MessageDTO();
            md.setTitle("\u6709\u4eba\u5728\u8868\u5355\u8bc4\u8bba\u4e2d\u63d0\u5230\u4e86\u4f60");
            md.setContent(content);
            md.setToAll(Boolean.valueOf(false));
            md.setToUser(users);
            md.setFromUser("system");
            md.setType(MessageTypeEnum.XT.getType());
            String tableName = sysComment.getTableName();
            String prefix = "desform:";
            if (tableName != null) {
                if (tableName.startsWith(prefix)) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("NOTICE_MSG_BUS_TYPE", "comment");
                    JSONObject params = new JSONObject();
                    params.put("code", (Object)tableName.substring(prefix.length()));
                    params.put("dataId", (Object)sysComment.getTableDataId());
                    params.put("type", (Object)"designForm");
                    data.put("NOTICE_MSG_SUMMARY", (String)params);
                    md.setData(data);
                } else if (oConvertUtils.isNotEmpty((Object)sysComment.getTableId())) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("NOTICE_MSG_BUS_TYPE", "comment");
                    JSONObject params = new JSONObject();
                    params.put("code", (Object)tableName);
                    params.put("formId", (Object)sysComment.getTableId());
                    params.put("dataId", (Object)sysComment.getTableDataId());
                    params.put("type", (Object)"cgform");
                    data.put("NOTICE_MSG_SUMMARY", (String)params);
                    md.setData(data);
                }
            }
            this.sysBaseApi.sendTemplateMessage(md);
        }
        return sysComment.getId();
    }

    @Override
    public void deleteOne(String id) {
        this.removeById((Serializable)((Object)id));
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFormFile::getTableDataId, (Object)id)).eq(SysFormFile::getTableName, (Object)SYS_FORM_FILE_TABLE_NAME);
        this.sysFormFileMapper.delete((Wrapper)query);
    }

    private Set<String> getCommentUsername(String content) {
        HashSet<String> set = new HashSet<String>(3);
        String reg = "(@(.*?)\\[(.*?)\\])";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(content);
        while (m.find()) {
            if (m.groupCount() != 3) continue;
            String username = m.group(3);
            set.add(username);
        }
        return set;
    }

    private String uploadLocal(MultipartFile mf, String bizPath) {
        if (oConvertUtils.isNotEmpty((Object)bizPath) && (bizPath.contains("../") || bizPath.contains("..\\"))) {
            throw new JeecgBootException("\u4e0a\u4f20\u76ee\u5f55bizPath\uff0c\u683c\u5f0f\u975e\u6cd5\uff01");
        }
        try {
            String ctxPath = this.uploadpath;
            String fileName = null;
            File file = new File(ctxPath + File.separator + bizPath + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            String orgName = mf.getOriginalFilename();
            fileName = (orgName = CommonUtils.getFileName((String)orgName)).indexOf(".") != -1 ? orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf(".")) : orgName + "_" + System.currentTimeMillis();
            String savePath = file.getPath() + File.separator + fileName;
            File savefile = new File(savePath);
            FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            String dbpath = null;
            dbpath = oConvertUtils.isNotEmpty((Object)bizPath) ? bizPath + File.separator + fileName : fileName;
            if (dbpath.contains("\\")) {
                dbpath = dbpath.replace("\\", "/");
            }
            return dbpath;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private Map<String, UserAvatar> queryUserAvatar(Set<String> idSet) {
        List<UserAvatar> list = ((SysCommentMapper)this.baseMapper).queryUserAvatarList(idSet);
        HashMap<String, UserAvatar> map = new HashMap<String, UserAvatar>();
        if (list != null && list.size() > 0) {
            for (UserAvatar user : list) {
                map.put(user.getId(), user);
            }
        }
        return map;
    }
}

