/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jeecg.dingtalk.api.core.response.Response;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysThirdAppConfig;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysThirdAppConfigService;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.vo.thirdapp.JwSysUserDepartVo;
import org.jeecg.modules.system.vo.thirdapp.JwUserDepartVo;
import org.jeecg.modules.system.vo.thirdapp.SyncInfoVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="thirdAppController")
@RequestMapping(value={"/sys/thirdApp"})
public class ThirdAppController {
    private static final Logger log = LoggerFactory.getLogger(ThirdAppController.class);
    @Autowired
    ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    ThirdAppDingtalkServiceImpl dingtalkService;
    @Autowired
    private ISysThirdAppConfigService appConfigService;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;

    @GetMapping(value={"/getEnabledType"})
    public Result getEnabledType() {
        HashMap<String, Boolean> enabledMap = new HashMap<String, Boolean>(5);
        int tenantId = MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL != false ? oConvertUtils.getInt((String)TenantContext.getTenant(), (int)-1) : oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        List<SysThirdAppConfig> list = this.appConfigService.getThirdConfigListByThirdType(tenantId);
        boolean dingConfig = false;
        boolean qywxConfig = false;
        if (null != list && list.size() > 0) {
            for (SysThirdAppConfig config : list) {
                if (MessageTypeEnum.DD.getType().equals(config.getThirdType())) {
                    dingConfig = true;
                    continue;
                }
                if (!MessageTypeEnum.QYWX.getType().equals(config.getThirdType())) continue;
                qywxConfig = true;
            }
        }
        enabledMap.put("wechatEnterprise", qywxConfig);
        enabledMap.put("dingtalk", dingConfig);
        return Result.OK(enabledMap);
    }

    @GetMapping(value={"/sync/wechatEnterprise/user/toApp"})
    public Result syncWechatEnterpriseUserToApp(@RequestParam(value="ids", required=false) String ids) {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.QYWX.getType());
        if (null != config) {
            SyncInfoVo syncInfo = this.wechatEnterpriseService.syncLocalUserToThirdApp(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1");
    }

    @GetMapping(value={"/sync/wechatEnterprise/user/toLocal"})
    public Result syncWechatEnterpriseUserToLocal(@RequestParam(value="ids", required=false) String ids) {
        return Result.error((String)"\u7531\u4e8e\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3\u8c03\u6574\uff0c\u540c\u6b65\u5230\u672c\u5730\u529f\u80fd\u5df2\u5931\u6548");
    }

    @GetMapping(value={"/sync/wechatEnterprise/depart/toApp"})
    public Result syncWechatEnterpriseDepartToApp(@RequestParam(value="ids", required=false) String ids) {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.QYWX.getType());
        if (null != config) {
            SyncInfoVo syncInfo = this.wechatEnterpriseService.syncLocalDepartmentToThirdApp(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", null);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1");
    }

    @GetMapping(value={"/sync/wechatEnterprise/depart/toLocal"})
    public Result syncWechatEnterpriseDepartToLocal(@RequestParam(value="ids", required=false) String ids) {
        return Result.error((String)"\u7531\u4e8e\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3\u8c03\u6574\uff0c\u4f01\u4e1a\u5fae\u4fe1\u540c\u6b65\u672c\u5730\u90e8\u95e8\u5931\u6548");
    }

    @GetMapping(value={"/sync/dingtalk/depart/toApp"})
    public Result syncDingtalkDepartToApp(@RequestParam(value="ids", required=false) String ids) {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
        if (null != config) {
            SyncInfoVo syncInfo = this.dingtalkService.syncLocalDepartmentToThirdApp(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", null);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u9489\u9489\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u9489\u9489");
    }

    @GetMapping(value={"/sync/dingtalk/user/toApp"})
    public Result syncDingtalkUserToApp(@RequestParam(value="ids", required=false) String ids) {
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        SysThirdAppConfig appConfig = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
        if (null != appConfig) {
            SyncInfoVo syncInfo = this.dingtalkService.syncLocalUserToThirdApp(ids);
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u9489\u9489\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u9489\u9489");
    }

    @PostMapping(value={"/sendMessageTest"})
    public Result sendMessageTest(@RequestBody JSONObject params, HttpServletRequest request) {
        String app = params.getString("app");
        boolean sendAll = params.getBooleanValue("sendAll");
        String receiver = params.getString("receiver");
        String content = params.getString("content");
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        String fromUser = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        String title = "\u7b2c\u4e09\u65b9APP\u6d88\u606f\u6d4b\u8bd5";
        MessageDTO message = new MessageDTO(fromUser, receiver, title, content);
        message.setToAll(Boolean.valueOf(sendAll));
        String weChatType = MessageTypeEnum.QYWX.getType();
        String dingType = MessageTypeEnum.DD.getType();
        if (weChatType.toUpperCase().equals(app)) {
            SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, weChatType);
            if (null != config) {
                JSONObject response = this.wechatEnterpriseService.sendMessageResponse(message, false);
                return Result.OK((Object)response);
            }
            return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1");
        }
        if (dingType.toUpperCase().equals(app)) {
            SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, dingType);
            if (null != config) {
                Response<String> response = this.dingtalkService.sendMessageResponse(message, false);
                return Result.OK(response);
            }
            return Result.error((String)"\u9489\u9489\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u9489\u9489");
        }
        return Result.error((String)"\u4e0d\u8bc6\u522b\u7684\u7b2c\u4e09\u65b9APP");
    }

    @PostMapping(value={"/recallMessageTest"})
    public Result recallMessageTest(@RequestBody JSONObject params) {
        String app = params.getString("app");
        String msgTaskId = params.getString("msg_task_id");
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        if ("WECHAT_ENTERPRISE".equals(app)) {
            SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.QYWX.getType());
            if (null != config) {
                return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u652f\u6301\u64a4\u56de\u6d88\u606f");
            }
            return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1");
        }
        if ("DINGTALK".equals(app)) {
            SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
            if (null != config) {
                Response<JSONObject> response = this.dingtalkService.recallMessageResponse(msgTaskId);
                if (response.isSuccess()) {
                    return Result.OK((String)"\u64a4\u56de\u6210\u529f", response);
                }
                return Result.error((String)("\u64a4\u56de\u5931\u8d25\uff1a" + response.getErrcode() + "\u2014\u2014" + response.getErrmsg()), response);
            }
            return Result.error((String)"\u9489\u9489\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u9489\u9489");
        }
        return Result.error((String)"\u4e0d\u8bc6\u522b\u7684\u7b2c\u4e09\u65b9APP");
    }

    @RequestMapping(value={"/addThirdAppConfig"}, method={RequestMethod.POST})
    public Result<String> addThirdAppConfig(@RequestBody SysThirdAppConfig appConfig) {
        Result result = new Result();
        Integer tenantId = oConvertUtils.isNotEmpty((Object)appConfig.getTenantId()) ? appConfig.getTenantId() : oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, appConfig.getThirdType());
        if (null != config) {
            result.error500("\u64cd\u4f5c\u5931\u8d25,\u540c\u4e00\u4e2a\u79df\u6237\u4e0b\u53ea\u5141\u8bb8\u7ed1\u5b9a\u4e00\u4e2a\u9489\u9489\u6216\u8005\u4f01\u4e1a\u5fae\u4fe1");
            return result;
        }
        String clientId = appConfig.getClientId();
        List<SysThirdAppConfig> thirdAppConfigByClientId = this.appConfigService.getThirdAppConfigByClientId(clientId);
        if (CollectionUtil.isNotEmpty(thirdAppConfigByClientId)) {
            result.error500("AppKey\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return result;
        }
        try {
            appConfig.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
            this.appConfigService.save(appConfig);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/editThirdAppConfig"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> editThirdAppConfig(@RequestBody SysThirdAppConfig appConfig) {
        List<SysThirdAppConfig> thirdAppConfigByClientId;
        Result result = new Result();
        SysThirdAppConfig config = (SysThirdAppConfig)this.appConfigService.getById((Serializable)((Object)appConfig.getId()));
        if (null == config) {
            result.error500("\u6570\u636e\u4e0d\u5b58\u5728");
            return result;
        }
        String clientId = appConfig.getClientId();
        if (!clientId.equals(config.getClientId()) && CollectionUtil.isNotEmpty(thirdAppConfigByClientId = this.appConfigService.getThirdAppConfigByClientId(clientId))) {
            result.error500("AppKey\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return result;
        }
        try {
            this.appConfigService.updateById(appConfig);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @GetMapping(value={"/getThirdConfigByTenantId"})
    public Result<SysThirdAppConfig> getThirdAppByTenantId(@RequestParam(name="tenantId", required=false) Integer tenantId, @RequestParam(name="thirdType") String thirdType) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            if (tenantId == null) {
                return Result.error((String)"\u5f00\u542f\u591a\u79df\u6237\u6a21\u5f0f\uff0c\u79df\u6237ID\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            }
        } else if (tenantId == null) {
            tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        }
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysThirdAppConfig::getThirdType, (Object)thirdType);
        query.eq(SysThirdAppConfig::getTenantId, (Object)tenantId);
        SysThirdAppConfig sysThirdAppConfig = (SysThirdAppConfig)this.appConfigService.getOne((Wrapper)query);
        result.setSuccess(true);
        result.setResult((Object)sysThirdAppConfig);
        return result;
    }

    @GetMapping(value={"/sync/dingtalk/departAndUser/toLocal"})
    public Result syncDingTalkDepartAndUserToLocal(@RequestParam(value="ids", required=false) String ids) {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.DD.getType());
        if (null != config) {
            SyncInfoVo syncInfo = this.dingtalkService.syncThirdAppDepartmentUserToLocal();
            if (syncInfo.getFailInfo().size() == 0) {
                return Result.OK((String)"\u540c\u6b65\u6210\u529f", (Object)syncInfo);
            }
            return Result.error((String)"\u540c\u6b65\u5931\u8d25", (Object)syncInfo);
        }
        return Result.error((String)"\u9489\u9489\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u9489\u9489");
    }

    @GetMapping(value={"/getThirdAccountByUserId"})
    public Result<List<SysThirdAccount>> getThirdAccountByUserId(@RequestParam(name="thirdType") String thirdType) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysThirdAccount::getSysUserId, (Object)sysUser.getId());
        query.eq(SysThirdAccount::getTenantId, (Object)CommonConstant.TENANT_ID_DEFAULT_VALUE);
        if (oConvertUtils.isNotEmpty((Object)thirdType)) {
            query.in(SysThirdAccount::getThirdType, Arrays.asList(thirdType.split(",")));
        }
        List list = this.sysThirdAccountService.list((Wrapper)query);
        return Result.ok((Object)list);
    }

    @PostMapping(value={"/bindThirdAppAccount"})
    public Result<SysThirdAccount> bindThirdAppAccount(@RequestBody SysThirdAccount sysThirdAccount) {
        SysThirdAccount thirdAccount = this.sysThirdAccountService.bindThirdAppAccountByUserId(sysThirdAccount);
        return Result.ok((Object)thirdAccount);
    }

    @DeleteMapping(value={"/deleteThirdAccount"})
    public Result<String> deleteThirdAccountById(@RequestBody SysThirdAccount sysThirdAccount) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!sysUser.getId().equals(sysThirdAccount.getSysUserId())) {
            return Result.error((String)"\u65e0\u6743\u4fee\u6539\u4ed6\u4eba\u4fe1\u606f");
        }
        SysThirdAccount thirdAccount = (SysThirdAccount)this.sysThirdAccountService.getById((Serializable)((Object)sysThirdAccount.getId()));
        if (null == thirdAccount) {
            return Result.error((String)"\u672a\u627e\u5230\u6539\u7b2c\u4e09\u65b9\u8d26\u6237\u4fe1\u606f");
        }
        this.sysThirdAccountService.removeById((Serializable)((Object)thirdAccount.getId()));
        return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
    }

    @GetMapping(value={"/getThirdUserByWechat"})
    public Result<JwSysUserDepartVo> getThirdUserByWechat(HttpServletRequest request) {
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request), (int)0);
        SysThirdAppConfig config = this.appConfigService.getThirdConfigByThirdType(tenantId, MessageTypeEnum.QYWX.getType());
        if (null != config) {
            JwSysUserDepartVo list = this.wechatEnterpriseService.getThirdUserByWechat(tenantId);
            return Result.ok((Object)list);
        }
        return Result.error((String)"\u4f01\u4e1a\u5fae\u4fe1\u5c1a\u672a\u914d\u7f6e,\u8bf7\u914d\u7f6e\u4f01\u4e1a\u5fae\u4fe1");
    }

    @GetMapping(value={"/sync/wechatEnterprise/departAndUser/toLocal"})
    public Result<SyncInfoVo> syncWechatEnterpriseDepartAndUserToLocal(@RequestParam(name="jwUserDepartJson") String jwUserDepartJson, HttpServletRequest request) {
        int tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request), (int)0);
        SyncInfoVo syncInfoVo = this.wechatEnterpriseService.syncWechatEnterpriseDepartAndUserToLocal(jwUserDepartJson, tenantId);
        return Result.ok((Object)syncInfoVo);
    }

    @GetMapping(value={"/getThirdUserBindByWechat"})
    public Result<List<JwUserDepartVo>> getThirdUserBindByWechat(HttpServletRequest request) {
        int tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request), (int)0);
        List<JwUserDepartVo> jwSysUserDepartVos = this.wechatEnterpriseService.getThirdUserBindByWechat(tenantId);
        return Result.ok(jwSysUserDepartVos);
    }
}

