/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.impl.SysBaseApiImpl;
import org.jeecg.modules.system.vo.SysUserOnlineVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/online"})
public class SysUserOnlineController {
    private static final Logger log = LoggerFactory.getLogger(SysUserOnlineController.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    public RedisTemplate redisTemplate;
    @Autowired
    public ISysUserService userService;
    @Autowired
    private SysBaseApiImpl sysBaseApi;
    @Resource
    private BaseCommonService baseCommonService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<Page<SysUserOnlineVO>> list(@RequestParam(name="username", required=false) String username, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        List keys = this.redisUtil.scan("prefix_user_token:*");
        ArrayList<SysUserOnlineVO> onlineList = new ArrayList<SysUserOnlineVO>();
        for (String key : keys) {
            String token = (String)this.redisUtil.get(key);
            if (!StringUtils.isNotEmpty((String)token)) continue;
            SysUserOnlineVO online = new SysUserOnlineVO();
            online.setToken(token);
            LoginUser loginUser = this.sysBaseApi.getUserByName(JwtUtil.getUsername((String)token));
            if (loginUser == null || "_reserve_user_external".equals(loginUser.getUsername())) continue;
            boolean isMatchUsername = true;
            if (oConvertUtils.isNotEmpty((Object)username) && !loginUser.getUsername().contains(username)) {
                isMatchUsername = false;
            }
            if (!isMatchUsername) continue;
            BeanUtils.copyProperties((Object)loginUser, (Object)online);
            onlineList.add(online);
        }
        Collections.reverse(onlineList);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int count = onlineList.size();
        ArrayList<SysUserOnlineVO> pages = new ArrayList<SysUserOnlineVO>();
        int currId = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        for (int i = 0; i < pageSize && i < count - currId; ++i) {
            pages.add((SysUserOnlineVO)onlineList.get(currId + i));
        }
        page.setSize((long)pageSize.intValue());
        page.setCurrent((long)pageNo.intValue());
        page.setTotal((long)count);
        page.setPages(count % 10 == 0 ? (long)(count / 10) : (long)(count / 10 + 1));
        page.setRecords(pages);
        Result result = new Result();
        result.setSuccess(true);
        result.setResult((Object)page);
        return result;
    }

    @RequestMapping(value={"/forceLogout"}, method={RequestMethod.POST})
    public Result<Object> forceLogout(@RequestBody SysUserOnlineVO online) {
        if (oConvertUtils.isEmpty((Object)online.getToken())) {
            return Result.error((String)"\u9000\u51fa\u767b\u5f55\u5931\u8d25\uff01");
        }
        String username = JwtUtil.getUsername((String)online.getToken());
        LoginUser sysUser = this.sysBaseApi.getUserByName(username);
        if (sysUser != null) {
            this.baseCommonService.addLog("\u5f3a\u5236: " + sysUser.getRealname() + "\u9000\u51fa\u6210\u529f\uff01", Integer.valueOf(1), null, sysUser);
            log.info(" \u5f3a\u5236  " + sysUser.getRealname() + "\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del(new String[]{"prefix_user_token:" + online.getToken()});
            this.redisUtil.del(new String[]{"shiro:cache:org.jeecg.config.shiro.ShiroRealm.authorizationCache:" + sysUser.getId()});
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:encrypt:user", sysUser.getUsername())});
            SecurityUtils.getSubject().logout();
            return Result.ok((String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
        }
        return Result.error((String)"Token\u65e0\u6548!");
    }
}

