/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.modules.redis.client.JeecgRedisClient;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.IpUtils;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserAgent;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysUserSysDepartModel;
import org.jeecg.modules.system.service.ISysDepartRoleService;
import org.jeecg.modules.system.service.ISysDepartRoleUserService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysPositionService;
import org.jeecg.modules.system.service.ISysUserAgentService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserRoleService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.ISysUserTenantService;
import org.jeecg.modules.system.vo.SysDepartUsersVO;
import org.jeecg.modules.system.vo.SysUserRoleVO;
import org.jeecg.modules.system.vo.lowapp.DepartAndUserInfo;
import org.jeecg.modules.system.vo.lowapp.UpdateDepartInfo;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Autowired
    private ISysDepartRoleUserService departRoleUserService;
    @Autowired
    private ISysDepartRoleService departRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${jeecg.path.upload}")
    private String upLoadPath;
    @Autowired
    private BaseCommonService baseCommonService;
    @Autowired
    private ISysUserAgentService sysUserAgentService;
    @Autowired
    private ISysPositionService sysPositionService;
    @Autowired
    private ISysUserTenantService userTenantService;
    @Autowired
    private JeecgRedisClient jeecgRedisClient;

    @PermissionData(pageComponent="system/UserList")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> queryPageList(SysUser user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)user, (Map)req.getParameterMap());
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            String tenantId = oConvertUtils.getString((String)TenantContext.getTenant(), (String)"-1");
            List<String> userIds = this.userTenantService.getUserIdsByTenantId(Integer.valueOf(tenantId));
            if (oConvertUtils.listIsNotEmpty(userIds)) {
                queryWrapper.in((Object)"id", userIds);
            } else {
                queryWrapper.eq((Object)"id", (Object)"\u901a\u8fc7\u79df\u6237\u67e5\u8be2\u4e0d\u5230\u4efb\u4f55\u7528\u6237");
            }
        }
        return this.sysUserService.queryPageList(req, (QueryWrapper<SysUser>)queryWrapper, pageSize, pageNo);
    }

    @RequiresPermissions(value={"system:user:listAll"})
    @RequestMapping(value={"/listAll"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> queryAllPageList(SysUser user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)user, (Map)req.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!sysUser.getUsername().equals("admin")) {
            queryWrapper.ne((Object)"username", (Object)"admin");
        }
        return this.sysUserService.queryPageList(req, (QueryWrapper<SysUser>)queryWrapper, pageSize, pageNo);
    }

    @RequiresPermissions(value={"system:user:add"})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysUser> add(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String selectedRoles = jsonObject.getString("selectedroles");
        String selectedDeparts = jsonObject.getString("selecteddeparts");
        try {
            SysUser user = (SysUser)JSON.parseObject((String)jsonObject.toJSONString(), SysUser.class);
            user.setCreateTime(new Date());
            String salt = oConvertUtils.randomGen((int)8);
            user.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt((String)user.getUsername(), (String)user.getPassword(), (String)salt);
            user.setPassword(passwordEncode);
            user.setStatus(1);
            user.setDelFlag(CommonConstant.DEL_FLAG_0);
            user.setOrgCode(null);
            String relTenantIds = jsonObject.getString("relTenantIds");
            this.sysUserService.saveUser(user, selectedRoles, selectedDeparts, relTenantIds);
            this.baseCommonService.addLog("\u6dfb\u52a0\u7528\u6237\uff0cusername\uff1a " + user.getUsername(), Integer.valueOf(2), Integer.valueOf(2));
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequiresPermissions(value={"system:user:edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysUser> edit(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        try {
            SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)jsonObject.getString("id")));
            this.baseCommonService.addLog("\u7f16\u8f91\u7528\u6237\uff0cusername\uff1a " + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(2));
            if (sysUser == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            } else {
                SysUser user = (SysUser)JSON.parseObject((String)jsonObject.toJSONString(), SysUser.class);
                user.setUpdateTime(new Date());
                user.setPassword(sysUser.getPassword());
                String roles = jsonObject.getString("selectedroles");
                String departs = jsonObject.getString("selecteddeparts");
                if (oConvertUtils.isEmpty((Object)departs)) {
                    departs = user.getDepartIds();
                }
                user.setOrgCode(null);
                String relTenantIds = jsonObject.getString("relTenantIds");
                String updateFromPage = jsonObject.getString("updateFromPage");
                this.sysUserService.editUser(user, roles, departs, relTenantIds, updateFromPage);
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequiresPermissions(value={"system:user:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.baseCommonService.addLog("\u5220\u9664\u7528\u6237\uff0cid\uff1a " + id, Integer.valueOf(2), Integer.valueOf(3));
        List<String> userNameList = this.sysUserService.userIdToUsername(Arrays.asList(id));
        this.sysUserService.deleteUser(id);
        if (!userNameList.isEmpty()) {
            String string = String.join((CharSequence)",", userNameList);
        }
        return Result.ok((String)"\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @RequiresPermissions(value={"system:user:deleteBatch"})
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.baseCommonService.addLog("\u6279\u91cf\u5220\u9664\u7528\u6237\uff0c ids\uff1a " + ids, Integer.valueOf(2), Integer.valueOf(3));
        List<String> userNameList = this.sysUserService.userIdToUsername(Arrays.asList(ids.split(",")));
        this.sysUserService.deleteBatchUsers(ids);
        if (!userNameList.isEmpty()) {
            String string = String.join((CharSequence)",", userNameList);
        }
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    @RequiresPermissions(value={"system:user:frozenBatch"})
    @RequestMapping(value={"/frozenBatch"}, method={RequestMethod.PUT})
    public Result<SysUser> frozenBatch(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        try {
            String[] arr;
            String ids = jsonObject.getString("ids");
            this.sysUserService.checkUserAdminRejectDel(ids);
            String status = jsonObject.getString("status");
            for (String id : arr = ids.split(",")) {
                if (!oConvertUtils.isNotEmpty((Object)id)) continue;
                this.sysUserService.updateStatus(id, status);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25" + e.getMessage());
        }
        result.success("\u64cd\u4f5c\u6210\u529f!");
        return result;
    }

    @RequiresPermissions(value={"system:user:queryById"})
    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysUser> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)id));
        if (sysUser == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysUser);
            result.setSuccess(true);
        }
        return result;
    }

    @RequiresPermissions(value={"system:user:queryUserRole"})
    @RequestMapping(value={"/queryUserRole"}, method={RequestMethod.GET})
    public Result<List<String>> queryUserRole(@RequestParam(name="userid", required=true) String userid) {
        Result result = new Result();
        ArrayList<String> list = new ArrayList<String>();
        List userRole = this.sysUserRoleService.list((Wrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)userid));
        if (userRole == null || userRole.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u7528\u6237\u76f8\u5173\u89d2\u8272\u4fe1\u606f");
        } else {
            for (SysUserRole sysUserRole : userRole) {
                list.add(sysUserRole.getRoleId());
            }
            result.setSuccess(true);
            result.setResult(list);
        }
        return result;
    }

    @RequestMapping(value={"/checkOnlyUser"}, method={RequestMethod.GET})
    public Result<Boolean> checkOnlyUser(SysUser sysUser) {
        Result result = new Result();
        result.setResult((Object)true);
        try {
            sysUser.setPassword(null);
            SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)new QueryWrapper((Object)sysUser));
            if (user != null) {
                result.setSuccess(false);
                result.setMessage("\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728");
                return result;
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @RequiresPermissions(value={"system:user:changepwd"})
    @RequestMapping(value={"/changePassword"}, method={RequestMethod.PUT})
    public Result<?> changePassword(@RequestBody SysUser sysUser) {
        SysUser u = (SysUser)this.sysUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUser::getUsername, (Object)sysUser.getUsername()));
        if (u == null) {
            return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        sysUser.setId(u.getId());
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.baseCommonService.addLog("\u4fee\u6539\u7528\u6237 " + sysUser.getUsername() + " \u7684\u5bc6\u7801\uff0c\u64cd\u4f5c\u4eba\uff1a " + loginUser.getUsername(), Integer.valueOf(2), Integer.valueOf(2));
        return this.sysUserService.changePassword(sysUser);
    }

    @RequestMapping(value={"/userDepartList"}, method={RequestMethod.GET})
    public Result<List<DepartIdModel>> getUserDepartsList(@RequestParam(name="userId", required=true) String userId) {
        Result result = new Result();
        try {
            List<DepartIdModel> depIdModelList = this.sysUserDepartService.queryDepartIdsOfUser(userId);
            if (depIdModelList != null && depIdModelList.size() > 0) {
                result.setSuccess(true);
                result.setMessage("\u67e5\u627e\u6210\u529f");
                result.setResult(depIdModelList);
            } else {
                result.setSuccess(false);
                result.setMessage("\u67e5\u627e\u5931\u8d25");
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u67e5\u627e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u4e86\u5f02\u5e38: " + e.getMessage());
            return result;
        }
    }

    @RequestMapping(value={"/generateUserId"}, method={RequestMethod.GET})
    public Result<String> generateUserId() {
        Result result = new Result();
        System.out.println("\u6211\u6267\u884c\u4e86,\u751f\u6210\u7528\u6237ID==============================");
        String userId = UUID.randomUUID().toString().replace("-", "");
        result.setSuccess(true);
        result.setResult((Object)userId);
        return result;
    }

    @RequestMapping(value={"/queryUserByDepId"}, method={RequestMethod.GET})
    public Result<List<SysUser>> queryUserByDepId(@RequestParam(name="id", required=true) String id, @RequestParam(name="realname", required=false) String realname) {
        Result result = new Result();
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)id));
        List<SysUser> userList = this.sysUserDepartService.queryUserByDepCode(sysDepart.getOrgCode(), realname);
        List<String> userIds = userList.stream().map(SysUser::getId).collect(Collectors.toList());
        if (userIds != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            userList.forEach(item -> item.setOrgCodeTxt((String)useDepNames.get(item.getId())));
        }
        try {
            result.setSuccess(true);
            result.setResult(userList);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            return result;
        }
    }

    @RequestMapping(value={"/queryUserComponentData"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> queryUserComponentData(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="departId", required=false) String departId, @RequestParam(name="realname", required=false) String realname, @RequestParam(name="username", required=false) String username, @RequestParam(name="isMultiTranslate", required=false) String isMultiTranslate, @RequestParam(name="id", required=false) String id) {
        String[] arr = new String[]{departId, realname, username, id};
        SqlInjectionUtil.filterContent((String[])arr, (String)"'");
        IPage<SysUser> pageList = this.sysUserDepartService.queryDepartUserPageList(departId, username, realname, pageSize, pageNo, id, isMultiTranslate);
        return Result.OK(pageList);
    }

    @RequiresPermissions(value={"system:user:export"})
    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysUser sysUser, HttpServletRequest request) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysUser, (Map)request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        String selections = request.getParameter("selections");
        if (!oConvertUtils.isEmpty((Object)selections)) {
            queryWrapper.in((Object)"id", (Object[])selections.split(","));
        }
        List pageList = this.sysUserService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u7528\u6237\u5217\u8868");
        mv.addObject("entity", SysUser.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ExportParams exportParams = new ExportParams("\u7528\u6237\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f");
        exportParams.setImageBasePath(this.upLoadPath);
        mv.addObject("params", (Object)exportParams);
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"system:user:import"})
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<String> errorMessage = new ArrayList<String>();
        int successLines = 0;
        int errorLines = 0;
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysUsers = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysUser.class, (ImportParams)params);
                for (int i = 0; i < listSysUsers.size(); ++i) {
                    SysUser sysUserExcel = (SysUser)listSysUsers.get(i);
                    if (StringUtils.isBlank((String)sysUserExcel.getPassword())) {
                        sysUserExcel.setPassword("123456");
                    }
                    String salt = oConvertUtils.randomGen((int)8);
                    sysUserExcel.setSalt(salt);
                    String passwordEncode = PasswordUtil.encrypt((String)sysUserExcel.getUsername(), (String)sysUserExcel.getPassword(), (String)salt);
                    sysUserExcel.setPassword(passwordEncode);
                    try {
                        this.sysUserService.save(sysUserExcel);
                        ++successLines;
                    }
                    catch (Exception e) {
                        ++errorLines;
                        String message = e.getMessage().toLowerCase();
                        int lineNumber = i + 1;
                        if (message.contains("uniq_sys_user_username")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("uniq_sys_user_work_no")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u5de5\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("uniq_sys_user_phone")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("uniq_sys_user_email")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7535\u5b50\u90ae\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                        }
                        if (message.contains("\u552f\u4e00\u6027\u7ea6\u675f")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u8fdd\u53cd\u8868\u552f\u4e00\u6027\u7ea6\u675f\u3002");
                        }
                        errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u5bfc\u5165");
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    String departIds = sysUserExcel.getDepartIds();
                    if (!StringUtils.isNotBlank((String)departIds)) continue;
                    String userId = sysUserExcel.getId();
                    String[] departIdArray = departIds.split(",");
                    ArrayList<SysUserDepart> userDepartList = new ArrayList<SysUserDepart>(departIdArray.length);
                    for (String departId : departIdArray) {
                        userDepartList.add(new SysUserDepart(userId, departId));
                    }
                    this.sysUserDepartService.saveBatch(userDepartList);
                }
            }
            catch (Exception e) {
                errorMessage.add("\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return ImportExcelUtil.imporReturnRes((int)errorLines, (int)successLines, errorMessage);
    }

    @RequestMapping(value={"/queryByIds"}, method={RequestMethod.GET})
    public Result<Collection<SysUser>> queryByIds(@RequestParam(name="userIds") String userIds) {
        Result result = new Result();
        String[] userId = userIds.split(",");
        List<String> idList = Arrays.asList(userId);
        List userRole = this.sysUserService.listByIds(idList);
        result.setSuccess(true);
        result.setResult((Object)userRole);
        return result;
    }

    @RequestMapping(value={"/queryByNames"}, method={RequestMethod.GET})
    public Result<Collection<SysUser>> queryByNames(@RequestParam(name="userNames") String userNames) {
        Result result = new Result();
        Object[] names = userNames.split(",");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(true, SysUser::getUsername, names);
        List userRole = this.sysUserService.list((Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)userRole);
        return result;
    }

    @RequiresPermissions(value={"system:user:updatepwd"})
    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.PUT})
    public Result<?> updatePassword(@RequestBody JSONObject json) {
        String username = json.getString("username");
        String oldpassword = json.getString("oldpassword");
        String password = json.getString("password");
        String confirmpassword = json.getString("confirmpassword");
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!sysUser.getUsername().equals(username)) {
            return Result.error((String)"\u53ea\u5141\u8bb8\u4fee\u6539\u81ea\u5df1\u7684\u5bc6\u7801\uff01");
        }
        SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUser::getUsername, (Object)username));
        if (user == null) {
            return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.baseCommonService.addLog("\u4fee\u6539\u5bc6\u7801\uff0cusername\uff1a " + loginUser.getUsername(), Integer.valueOf(2), Integer.valueOf(2));
        return this.sysUserService.resetPassword(username, oldpassword, password, confirmpassword);
    }

    @RequestMapping(value={"/userRoleList"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> userRoleList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String roleId = req.getParameter("roleId");
        String username = req.getParameter("username");
        IPage<SysUser> pageList = this.sysUserService.getUserByRoleId((Page<SysUser>)page, roleId, username);
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequiresPermissions(value={"system:user:addUserRole"})
    @RequestMapping(value={"/addSysUserRole"}, method={RequestMethod.POST})
    public Result<String> addSysUserRole(@RequestBody SysUserRoleVO sysUserRoleVO) {
        Result result = new Result();
        try {
            String sysRoleId = sysUserRoleVO.getRoleId();
            for (String sysUserId : sysUserRoleVO.getUserIdList()) {
                SysUserRole sysUserRole = new SysUserRole(sysUserId, sysRoleId);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)sysRoleId)).eq((Object)"user_id", (Object)sysUserId);
                SysUserRole one = (SysUserRole)this.sysUserRoleService.getOne((Wrapper)queryWrapper);
                if (one != null) continue;
                this.sysUserRoleService.save(sysUserRole);
            }
            result.setMessage("\u6dfb\u52a0\u6210\u529f!");
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u51fa\u9519\u4e86: " + e.getMessage());
            return result;
        }
    }

    @RequiresPermissions(value={"system:user:deleteRole"})
    @RequestMapping(value={"/deleteUserRole"}, method={RequestMethod.DELETE})
    public Result<SysUserRole> deleteUserRole(@RequestParam(name="roleId") String roleId, @RequestParam(name="userId", required=true) String userId) {
        Result result = new Result();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).eq((Object)"user_id", (Object)userId);
            this.sysUserRoleService.remove((Wrapper)queryWrapper);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequiresPermissions(value={"system:user:deleteRoleBatch"})
    @RequestMapping(value={"/deleteUserRoleBatch"}, method={RequestMethod.DELETE})
    public Result<SysUserRole> deleteUserRoleBatch(@RequestParam(name="roleId") String roleId, @RequestParam(name="userIds", required=true) String userIds) {
        Result result = new Result();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"role_id", (Object)roleId)).in((Object)"user_id", Arrays.asList(userIds.split(",")));
            this.sysUserRoleService.remove((Wrapper)queryWrapper);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/departUserList"}, method={RequestMethod.GET})
    public Result<IPage<SysUser>> departUserList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String depId = req.getParameter("depId");
        String username = req.getParameter("username");
        List<Object> subDepids = new ArrayList();
        if (oConvertUtils.isEmpty((Object)depId)) {
            LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            int userIdentity = user.getUserIdentity() != null ? user.getUserIdentity() : CommonConstant.USER_IDENTITY_1;
            if (oConvertUtils.isNotEmpty((Object)userIdentity) && userIdentity == CommonConstant.USER_IDENTITY_2 && oConvertUtils.isNotEmpty((Object)user.getDepartIds())) {
                subDepids = this.sysDepartService.getMySubDepIdsByDepId(user.getDepartIds());
            }
        } else {
            subDepids = this.sysDepartService.getSubDepIdsByDepId(depId);
        }
        if (subDepids != null && subDepids.size() > 0) {
            IPage<SysUser> pageList = this.sysUserService.getUserByDepIds((Page<SysUser>)page, subDepids, username);
            List<String> userIds = pageList.getRecords().stream().map(SysUser::getId).collect(Collectors.toList());
            if (userIds != null && userIds.size() > 0) {
                Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
                pageList.getRecords().forEach(item -> item.setOrgCode((String)useDepNames.get(item.getId())));
            }
            page.setRecords(this.userTenantService.setUserTenantIds(page.getRecords()));
            result.setSuccess(true);
            result.setResult(pageList);
        } else {
            result.setSuccess(true);
            result.setResult(null);
        }
        return result;
    }

    @GetMapping(value={"/queryByOrgCode"})
    public Result<?> queryByDepartId(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orgCode") String orgCode, SysUser userParams) {
        IPage<SysUserSysDepartModel> pageList = this.sysUserService.queryUserByOrgCode(orgCode, userParams, (IPage)new Page((long)pageNo.intValue(), (long)pageSize.intValue()));
        return Result.ok(pageList);
    }

    @GetMapping(value={"/queryByOrgCodeForAddressList"})
    public Result<?> queryByOrgCodeForAddressList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="orgCode", required=false) String orgCode, SysUser userParams) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysUserSysDepartModel> pageList = this.sysUserService.queryUserByOrgCode(orgCode, userParams, (IPage)page);
        List list = pageList.getRecords();
        HashMap<String, JSONObject> hasUser = new HashMap<String, JSONObject>(list.size());
        JSONArray resultJson = new JSONArray(list.size());
        for (SysUserSysDepartModel item : list) {
            String userId = item.getId();
            JSONObject getModel = (JSONObject)hasUser.get(userId);
            if (getModel != null) {
                String departName = getModel.get((Object)"departName").toString();
                getModel.put("departName", (Object)(departName + " | " + item.getDepartName()));
                continue;
            }
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)item));
            json.remove((Object)"id");
            json.put("userId", (Object)userId);
            json.put("departId", (Object)item.getDepartId());
            json.put("departName", (Object)item.getDepartName());
            resultJson.add((Object)json);
            hasUser.put(userId, json);
        }
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue(), pageList.getTotal());
        result.setRecords(resultJson.toJavaList(JSONObject.class));
        return Result.ok((Object)result);
    }

    @RequiresPermissions(value={"system:user:editDepartWithUser"})
    @RequestMapping(value={"/editSysDepartWithUser"}, method={RequestMethod.POST})
    public Result<String> editSysDepartWithUser(@RequestBody SysDepartUsersVO sysDepartUsersVO) {
        Result result = new Result();
        try {
            String sysDepId = sysDepartUsersVO.getDepId();
            for (String sysUserId : sysDepartUsersVO.getUserIdList()) {
                SysUserDepart sysUserDepart = new SysUserDepart(null, sysUserId, sysDepId);
                QueryWrapper queryWrapper = new QueryWrapper();
                ((QueryWrapper)queryWrapper.eq((Object)"dep_id", (Object)sysDepId)).eq((Object)"user_id", (Object)sysUserId);
                SysUserDepart one = (SysUserDepart)this.sysUserDepartService.getOne((Wrapper)queryWrapper);
                if (one != null) continue;
                this.sysUserDepartService.save(sysUserDepart);
            }
            result.setMessage("\u6dfb\u52a0\u6210\u529f!");
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage("\u51fa\u9519\u4e86: " + e.getMessage());
            return result;
        }
    }

    @RequiresPermissions(value={"system:user:deleteUserInDepart"})
    @RequestMapping(value={"/deleteUserInDepart"}, method={RequestMethod.DELETE})
    public Result<SysUserDepart> deleteUserInDepart(@RequestParam(name="depId") String depId, @RequestParam(name="userId", required=true) String userId) {
        Result result = new Result();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"dep_id", (Object)depId)).eq((Object)"user_id", (Object)userId);
            boolean b = this.sysUserDepartService.remove((Wrapper)queryWrapper);
            if (b) {
                List sysDepartRoleList = this.departRoleService.list((Wrapper)new QueryWrapper().eq((Object)"depart_id", (Object)depId));
                List roleIds = sysDepartRoleList.stream().map(SysDepartRole::getId).collect(Collectors.toList());
                if (roleIds != null && roleIds.size() > 0) {
                    QueryWrapper query = new QueryWrapper();
                    ((QueryWrapper)query.eq((Object)"user_id", (Object)userId)).in((Object)"drole_id", roleIds);
                    this.departRoleUserService.remove((Wrapper)query);
                }
                result.success("\u5220\u9664\u6210\u529f!");
            } else {
                result.error500("\u5f53\u524d\u9009\u4e2d\u90e8\u95e8\u4e0e\u7528\u6237\u65e0\u5173\u8054\u5173\u7cfb!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequiresPermissions(value={"system:user:deleteUserInDepartBatch"})
    @RequestMapping(value={"/deleteUserInDepartBatch"}, method={RequestMethod.DELETE})
    public Result<SysUserDepart> deleteUserInDepartBatch(@RequestParam(name="depId") String depId, @RequestParam(name="userIds", required=true) String userIds) {
        Result result = new Result();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"dep_id", (Object)depId)).in((Object)"user_id", Arrays.asList(userIds.split(",")));
            boolean b = this.sysUserDepartService.remove((Wrapper)queryWrapper);
            if (!b) {
                result.error500("\u5220\u9664\u5931\u8d25\uff0c\u76ee\u6807\u7528\u6237\u4e0d\u5728\u5f53\u524d\u90e8\u95e8\uff01");
                return result;
            }
            this.departRoleUserService.removeDeptRoleUser(Arrays.asList(userIds.split(",")), depId);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(value={"/getCurrentUserDeparts"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> getCurrentUserDeparts() {
        Result result = new Result();
        try {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            List<SysDepart> list = this.sysDepartService.queryUserDeparts(sysUser.getId());
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("list", list);
            map.put("orgCode", sysUser.getOrgCode());
            result.setSuccess(true);
            result.setResult(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return result;
    }

    @PostMapping(value={"/register"})
    public Result<JSONObject> userRegister(@RequestBody JSONObject jsonObject, SysUser user) {
        SysUser sysUser3;
        String password;
        Result result = new Result();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        String redisKey = "phone_msg" + phone;
        Object code = this.redisUtil.get(redisKey);
        String username = jsonObject.getString("username");
        if (oConvertUtils.isEmpty((Object)username)) {
            username = phone;
        }
        if (oConvertUtils.isEmpty((Object)(password = jsonObject.getString("password")))) {
            password = RandomUtil.randomString((int)8);
        }
        String email = jsonObject.getString("email");
        SysUser sysUser1 = this.sysUserService.getUserByName(username);
        if (sysUser1 != null) {
            result.setMessage("\u7528\u6237\u540d\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        SysUser sysUser2 = this.sysUserService.getUserByPhone(phone);
        if (sysUser2 != null) {
            result.setMessage("\u8be5\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        if (oConvertUtils.isNotEmpty((Object)email) && (sysUser3 = this.sysUserService.getUserByEmail(email)) != null) {
            result.setMessage("\u90ae\u7bb1\u5df2\u88ab\u6ce8\u518c");
            result.setSuccess(false);
            return result;
        }
        if (null == code) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(code.toString())) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        String realname = jsonObject.getString("realname");
        if (oConvertUtils.isEmpty((Object)realname)) {
            realname = username;
        }
        try {
            user.setCreateTime(new Date());
            String salt = oConvertUtils.randomGen((int)8);
            String passwordEncode = PasswordUtil.encrypt((String)username, (String)password, (String)salt);
            user.setSalt(salt);
            user.setUsername(username);
            user.setRealname(realname);
            user.setPassword(passwordEncode);
            user.setEmail(email);
            user.setPhone(phone);
            user.setStatus(CommonConstant.USER_UNFREEZE);
            user.setDelFlag(CommonConstant.DEL_FLAG_0);
            user.setActivitiSync(CommonConstant.ACT_SYNC_1);
            this.sysUserService.addUserWithRole(user, "");
            result.success("\u6ce8\u518c\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u6ce8\u518c\u5931\u8d25");
        }
        return result;
    }

    @PostMapping(value={"/phoneVerification"})
    public Result<Map<String, String>> phoneVerification(@RequestBody JSONObject jsonObject) {
        String redisKey;
        Object code;
        Result result = new Result();
        String phone = jsonObject.getString("phone");
        String smscode = jsonObject.getString("smscode");
        if (!smscode.equals(code = this.redisUtil.get(redisKey = "phone_msg" + phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setSuccess(false);
            return result;
        }
        this.redisUtil.set(redisKey, (Object)smscode, 600L);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUser::getPhone, (Object)phone);
        SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)query);
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("smscode", smscode);
        if (null == user) {
            result.setMessage("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            result.setSuccess(false);
            return result;
        }
        map.put("username", user.getUsername());
        result.setResult(map);
        result.setSuccess(true);
        return result;
    }

    @GetMapping(value={"/passwordChange"})
    public Result<SysUser> passwordChange(@RequestParam(name="username") String username, @RequestParam(name="password") String password, @RequestParam(name="smscode") String smscode, @RequestParam(name="phone") String phone) {
        Result result = new Result();
        if (oConvertUtils.isEmpty((Object)username) || oConvertUtils.isEmpty((Object)password) || oConvertUtils.isEmpty((Object)smscode) || oConvertUtils.isEmpty((Object)phone)) {
            result.setMessage("\u91cd\u7f6e\u5bc6\u7801\u5931\u8d25\uff01");
            result.setSuccess(false);
            return result;
        }
        SysUser sysUser = new SysUser();
        String redisKey = "phone_msg" + phone;
        Object object = this.redisUtil.get(redisKey);
        if (null == object) {
            result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(object.toString())) {
            result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u5339\u914d\uff01");
            result.setSuccess(false);
            return result;
        }
        sysUser = (SysUser)this.sysUserService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUser::getUsername, (Object)username)).eq(SysUser::getPhone, (Object)phone));
        if (sysUser == null) {
            result.setMessage("\u5f53\u524d\u767b\u5f55\u7528\u6237\u548c\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fee\u6539\u5bc6\u7801\uff01");
            result.setSuccess(false);
            return result;
        }
        String salt = oConvertUtils.randomGen((int)8);
        sysUser.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setPassword(passwordEncode);
        this.sysUserService.updateById(sysUser);
        this.baseCommonService.addLog("\u91cd\u7f6e " + username + " \u7684\u5bc6\u7801\uff0c\u64cd\u4f5c\u4eba\uff1a " + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(2));
        result.setSuccess(true);
        result.setMessage("\u5bc6\u7801\u91cd\u7f6e\u5b8c\u6210\uff01");
        this.redisUtil.removeAll(redisKey);
        return result;
    }

    @GetMapping(value={"/getUserSectionInfoByToken"})
    public Result<?> getUserSectionInfoByToken(HttpServletRequest request, @RequestParam(name="token", required=false) String token) {
        try {
            String username = null;
            username = oConvertUtils.isEmpty((Object)token) ? JwtUtil.getUserNameByToken((HttpServletRequest)request) : JwtUtil.getUsername((String)token);
            log.debug(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u90e8\u5206\u7528\u6237\u4fe1\u606f\uff0c\u5f53\u524d\u7528\u6237\uff1a " + username);
            SysUser sysUser = this.sysUserService.getUserByName(username);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sysUserId", sysUser.getId());
            map.put("sysUserCode", sysUser.getUsername());
            map.put("sysUserName", sysUser.getRealname());
            map.put("sysOrgCode", sysUser.getOrgCode());
            log.debug(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u90e8\u5206\u7528\u6237\u4fe1\u606f\uff0c\u5df2\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\uff1a " + map);
            return Result.ok(map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((int)500, (String)("\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/appUserList"})
    public Result<?> appUserList(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="username", required=false) String username, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="syncFlow", required=false) String syncFlow) {
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            if (oConvertUtils.isNotEmpty((Object)syncFlow)) {
                query.eq(SysUser::getActivitiSync, (Object)CommonConstant.ACT_SYNC_1);
            }
            query.eq(SysUser::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            if (oConvertUtils.isNotEmpty((Object)username)) {
                if (username.contains(",")) {
                    query.in(SysUser::getUsername, (Object[])username.split(","));
                } else {
                    query.eq(SysUser::getUsername, (Object)username);
                }
            } else {
                query.and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysUser::getUsername, (Object)keyword)).or()).like(SysUser::getRealname, (Object)keyword));
            }
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage res = this.sysUserService.page((IPage)page, (Wrapper)query);
            return Result.ok((Object)res);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((int)500, (String)("\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }

    @GetMapping(value={"/recycleBin"})
    public Result getRecycleBin() {
        List<SysUser> logicDeletedUserList = this.sysUserService.queryLogicDeleted();
        if (logicDeletedUserList.size() > 0) {
            List<String> userIds = logicDeletedUserList.stream().map(SysUser::getId).collect(Collectors.toList());
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            logicDeletedUserList.forEach(item -> item.setOrgCode((String)useDepNames.get(item.getId())));
        }
        return Result.ok(logicDeletedUserList);
    }

    @RequestMapping(value={"/putRecycleBin"}, method={RequestMethod.PUT})
    public Result putRecycleBin(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String userIds = jsonObject.getString("userIds");
        if (StringUtils.isNotBlank((String)userIds)) {
            SysUser updateUser = new SysUser();
            updateUser.setUpdateBy(JwtUtil.getUserNameByToken((HttpServletRequest)request));
            updateUser.setUpdateTime(new Date());
            this.sysUserService.revertLogicDeleted(Arrays.asList(userIds.split(",")), updateUser);
        }
        return Result.ok((String)"\u8fd8\u539f\u6210\u529f");
    }

    @RequiresPermissions(value={"system:user:deleteRecycleBin"})
    @RequestMapping(value={"/deleteRecycleBin"}, method={RequestMethod.DELETE})
    public Result deleteRecycleBin(@RequestParam(value="userIds") String userIds) {
        if (StringUtils.isNotBlank((String)userIds)) {
            this.sysUserService.removeLogicDeleted(Arrays.asList(userIds.split(",")));
        }
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @RequiresPermissions(value={"system:user:app:edit"})
    @RequestMapping(value={"/appEdit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysUser> appEdit(HttpServletRequest request, @RequestBody JSONObject jsonObject) {
        Result result = new Result();
        try {
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            SysUser sysUser = this.sysUserService.getUserByName(username);
            this.baseCommonService.addLog("\u79fb\u52a8\u7aef\u7f16\u8f91\u7528\u6237\uff0cid\uff1a " + jsonObject.getString("id"), Integer.valueOf(2), Integer.valueOf(2));
            String realname = jsonObject.getString("realname");
            String avatar = jsonObject.getString("avatar");
            String sex = jsonObject.getString("sex");
            String phone = jsonObject.getString("phone");
            String email = jsonObject.getString("email");
            Date birthday = jsonObject.getDate("birthday");
            SysUser userPhone = this.sysUserService.getUserByPhone(phone);
            if (sysUser == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237!");
            } else {
                String userPhonename;
                if (userPhone != null && !(userPhonename = userPhone.getUsername()).equals(username)) {
                    result.error500("\u624b\u673a\u53f7\u5df2\u5b58\u5728!");
                    return result;
                }
                if (StringUtils.isNotBlank((String)realname)) {
                    sysUser.setRealname(realname);
                }
                if (StringUtils.isNotBlank((String)avatar)) {
                    sysUser.setAvatar(avatar);
                }
                if (StringUtils.isNotBlank((String)sex)) {
                    sysUser.setSex(Integer.parseInt(sex));
                }
                if (StringUtils.isNotBlank((String)phone)) {
                    sysUser.setPhone(phone);
                }
                if (StringUtils.isNotBlank((String)email)) {
                    LambdaQueryWrapper emailQuery = new LambdaQueryWrapper();
                    emailQuery.eq(SysUser::getEmail, (Object)email);
                    long count = this.sysUserService.count((Wrapper)emailQuery);
                    if (!email.equals(sysUser.getEmail()) && count != 0L) {
                        result.error500("\u4fdd\u5b58\u5931\u8d25\uff0c\u90ae\u7bb1\u5df2\u5b58\u5728!");
                        return result;
                    }
                    sysUser.setEmail(email);
                }
                if (null != birthday) {
                    sysUser.setBirthday(birthday);
                }
                sysUser.setUpdateTime(new Date());
                this.sysUserService.updateById(sysUser);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u4fdd\u5b58\u5931\u8d25!");
        }
        return result;
    }

    @RequestMapping(value={"/saveClientId"}, method={RequestMethod.GET})
    public Result<SysUser> saveClientId(HttpServletRequest request, @RequestParam(value="clientId") String clientId) {
        Result result = new Result();
        try {
            String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
            SysUser sysUser = this.sysUserService.getUserByName(username);
            if (sysUser == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237!");
            } else {
                sysUser.setClientId(clientId);
                this.sysUserService.updateById(sysUser);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25!");
        }
        return result;
    }

    @GetMapping(value={"/queryChildrenByUsername"})
    public Result queryChildrenByUsername(@RequestParam(value="userId") String userId) {
        String departIds;
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        SysUser sysUser = (SysUser)this.sysUserService.getById((Serializable)((Object)userId));
        String username = sysUser.getUsername();
        Integer identity = sysUser.getUserIdentity();
        map.put("sysUser", sysUser);
        if (identity != null && identity == 2 && StringUtils.isNotBlank((String)(departIds = sysUser.getDepartIds()))) {
            List<String> departIdList = Arrays.asList(departIds.split(","));
            List<SysUser> childrenUser = this.sysUserService.queryByDepIds(departIdList, username);
            map.put("children", childrenUser);
        }
        return Result.ok(map);
    }

    @GetMapping(value={"/appQueryByDepartId"})
    public Result<List<SysUser>> appQueryByDepartId(@RequestParam(name="departId", required=false) String departId) {
        Result result = new Result();
        ArrayList<String> list = new ArrayList<String>();
        list.add(departId);
        List<SysUser> childrenUser = this.sysUserService.queryByDepIds(list, null);
        result.setResult(childrenUser);
        return result;
    }

    @GetMapping(value={"/appQueryUser"})
    public Result<List<SysUser>> appQueryUser(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="username", required=false) String username, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        Page page;
        IPage pageList;
        List<String> userIds;
        String tenantId;
        List<String> userIds2;
        Result result = new Result();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(SysUser::getUsername, (Object)"_reserve_user_external");
        if (oConvertUtils.isNotEmpty((Object)username)) {
            if (username.contains(",")) {
                queryWrapper.in(SysUser::getUsername, (Object[])username.split(","));
            } else {
                queryWrapper.eq(SysUser::getUsername, (Object)username);
            }
        } else if (StringUtils.isNotBlank((String)keyword)) {
            queryWrapper.and(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysUser::getUsername, (Object)keyword)).or()).like(SysUser::getRealname, (Object)keyword));
        }
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && oConvertUtils.listIsNotEmpty(userIds2 = this.userTenantService.getUserIdsByTenantId(Integer.valueOf(tenantId = oConvertUtils.getString((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request), (String)"-1"))))) {
            queryWrapper.in(SysUser::getId, userIds2);
        }
        if ((userIds = (pageList = this.sysUserService.page((IPage)(page = new Page((long)pageNo.intValue(), (long)pageSize.intValue())), (Wrapper)queryWrapper)).getRecords().stream().map(SysUser::getId).collect(Collectors.toList())) != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            pageList.getRecords().forEach(item -> item.setOrgCodeTxt((String)useDepNames.get(item.getId())));
        }
        result.setResult((Object)pageList.getRecords());
        return result;
    }

    @RequestMapping(value={"/updateMobile"}, method={RequestMethod.PUT})
    public Result<?> changMobile(@RequestBody JSONObject json, HttpServletRequest request) {
        String smscode = json.getString("smscode");
        String phone = json.getString("phone");
        Result result = new Result();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        if (oConvertUtils.isEmpty((Object)username) || oConvertUtils.isEmpty((Object)smscode) || oConvertUtils.isEmpty((Object)phone)) {
            result.setMessage("\u4fee\u6539\u624b\u673a\u53f7\u5931\u8d25\uff01");
            result.setSuccess(false);
            return result;
        }
        String redisKey = "phone_msg" + phone;
        Object object = this.redisUtil.get(redisKey);
        if (null == object) {
            result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        if (!smscode.equals(object.toString())) {
            result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u5339\u914d\uff01");
            result.setSuccess(false);
            return result;
        }
        SysUser user = this.sysUserService.getUserByName(username);
        if (user == null) {
            return Result.error((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        user.setPhone(phone);
        this.sysUserService.updateById(user);
        return Result.ok((String)"\u624b\u673a\u53f7\u8bbe\u7f6e\u6210\u529f!");
    }

    @GetMapping(value={"/getMultiUser"})
    public List<SysUser> getMultiUser(SysUser sysUser) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysUser, null);
        queryWrapper.eq((Object)"status", (Object)Integer.parseInt("1"));
        List ls = this.sysUserService.list((Wrapper)queryWrapper);
        for (SysUser user : ls) {
            user.setPassword(null);
            user.setSalt(null);
        }
        return ls;
    }

    @GetMapping(value={"/getUserInformation"})
    public Result<IPage<SysUser>> getUserInformation(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="departId", required=false) String departId, @RequestParam(name="keyword", required=false) String keyword) {
        Integer tenantId = null;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        }
        IPage<SysUser> pageList = this.sysUserDepartService.getUserInformation(tenantId, departId, keyword, pageSize, pageNo);
        return Result.OK(pageList);
    }

    @GetMapping(value={"/selectUserList"})
    public Result<IPage<SysUser>> selectUserList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="departId", required=false) String departId, @RequestParam(name="roleId", required=false) String roleId, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="excludeUserIdList", required=false) String excludeUserIdList, HttpServletRequest req) {
        Integer tenantId = null;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            String tenantStr = TenantContext.getTenant();
            tenantId = oConvertUtils.getInteger((Object)tenantStr, (Integer)oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)req), (int)-1));
            log.info("---------\u7b80\u6d41\u4e2d\u9009\u62e9\u7528\u6237\u63a5\u53e3\uff0c\u901a\u8fc7\u79df\u6237\u7b5b\u9009\uff0c\u79df\u6237ID={}", (Object)tenantId);
        }
        IPage<SysUser> pageList = this.sysUserDepartService.getUserInformation(tenantId, departId, roleId, keyword, pageSize, pageNo, excludeUserIdList);
        return Result.OK(pageList);
    }

    @PutMapping(value={"/userQuitAgent"})
    public Result<String> userQuitAgent(@RequestBody SysUserAgent sysUserAgent) {
        if (oConvertUtils.isNotEmpty((Object)sysUserAgent.getId())) {
            this.sysUserAgentService.updateById(sysUserAgent);
        } else {
            this.sysUserAgentService.save(sysUserAgent);
        }
        this.sysUserService.userQuit(sysUserAgent.getUserName());
        return Result.ok((String)"\u79bb\u804c\u6210\u529f");
    }

    @GetMapping(value={"/getQuitList"})
    public Result<List<SysUser>> getQuitList(HttpServletRequest req) {
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)req), (int)0);
        List<SysUser> quitList = this.sysUserService.getQuitList(tenantId);
        if (null != quitList && quitList.size() > 0) {
            List<String> userIds = quitList.stream().map(SysUser::getId).collect(Collectors.toList());
            Map<String, String> useDepNames = this.sysUserService.getDepNamesByUserIds(userIds);
            quitList.forEach(item -> item.setOrgCode((String)useDepNames.get(item.getId())));
        }
        return Result.ok(quitList);
    }

    @PutMapping(value={"/putCancelQuit"})
    public Result<String> putCancelQuit(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String userIds = jsonObject.getString("userIds");
        String usernames = jsonObject.getString("usernames");
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request), (int)0);
        if (StringUtils.isNotBlank((String)userIds)) {
            this.userTenantService.putCancelQuit(Arrays.asList(userIds.split(",")), tenantId);
        }
        if (StringUtils.isNotEmpty((String)usernames)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.in(SysUserAgent::getUserName, Arrays.asList(usernames.split(",")));
            this.sysUserAgentService.remove((Wrapper)query);
        }
        return Result.ok((String)"\u53d6\u6d88\u79bb\u804c\u6210\u529f");
    }

    @GetMapping(value={"/login/setting/getUserData"})
    public Result<SysUser> getUserData(HttpServletRequest request) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        SysUser user = this.sysUserService.getUserByName(username);
        if (user == null) {
            return Result.error((String)"\u672a\u627e\u5230\u8be5\u7528\u6237\u6570\u636e");
        }
        List<SysPosition> sysPositionList = this.sysPositionService.getPositionList(user.getId());
        if (null != sysPositionList && sysPositionList.size() > 0) {
            String ids;
            StringBuilder nameBuilder = new StringBuilder();
            StringBuilder idBuilder = new StringBuilder();
            String verticalBar = " | ";
            for (SysPosition sysPosition : sysPositionList) {
                nameBuilder.append(sysPosition.getName()).append(verticalBar);
                idBuilder.append(sysPosition.getId()).append(",");
            }
            String names = nameBuilder.toString();
            if (oConvertUtils.isNotEmpty((Object)names)) {
                names = names.substring(0, names.lastIndexOf(verticalBar));
                user.setPostText(names);
            }
            if (oConvertUtils.isNotEmpty((Object)(ids = idBuilder.toString()))) {
                ids = ids.substring(0, ids.lastIndexOf(","));
                user.setPost(ids);
            }
        }
        return Result.ok((Object)user);
    }

    @PostMapping(value={"/login/setting/userEdit"})
    @RequiresPermissions(value={"system:user:setting:edit"})
    public Result<String> userEdit(@RequestBody SysUser sysUser, HttpServletRequest request) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        SysUser user = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUser.getId()));
        if (user == null) {
            return Result.error((String)"\u672a\u627e\u5230\u8be5\u7528\u6237\u6570\u636e");
        }
        if (!username.equals(user.getUsername())) {
            return Result.error((String)"\u53ea\u80fd\u4fee\u6539\u81ea\u5df1\u7684\u6570\u636e");
        }
        this.sysUserService.updateById(sysUser);
        return Result.ok((String)"\u66f4\u65b0\u4e2a\u4eba\u4fe1\u606f\u6210\u529f");
    }

    @PutMapping(value={"/batchEditUsers"})
    public Result<SysUser> batchEditUsers(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        try {
            this.sysUserService.batchEditUsers(jsonObject);
            result.setSuccess(true);
            result.setMessage("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @GetMapping(value={"/searchByKeyword"})
    public Result<DepartAndUserInfo> searchByKeyword(@RequestParam(name="keyword", required=false) String keyword) {
        DepartAndUserInfo info = this.sysUserService.searchByKeyword(keyword);
        return Result.ok((Object)info);
    }

    @GetMapping(value={"/getUpdateDepartInfo"})
    public Result<UpdateDepartInfo> getUpdateDepartInfo(@RequestParam(name="id", required=false) String id) {
        UpdateDepartInfo info = this.sysUserService.getUpdateDepartInfo(id);
        return Result.ok((Object)info);
    }

    @PutMapping(value={"/doUpdateDepartInfo"})
    public Result<?> doUpdateDepartInfo(@RequestBody UpdateDepartInfo updateDepartInfo) {
        this.sysUserService.doUpdateDepartInfo(updateDepartInfo);
        return Result.ok();
    }

    @PutMapping(value={"/changeDepartChargePerson"})
    public Result<?> changeDepartChargePerson(@RequestBody JSONObject json) {
        this.sysUserService.changeDepartChargePerson(json);
        return Result.ok();
    }

    @RequestMapping(value={"/editTenantUser"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> editTenantUser(@RequestBody SysUser sysUser, HttpServletRequest req) {
        Result result = new Result();
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)req);
        if (oConvertUtils.isEmpty((Object)tenantId)) {
            return result.error500("\u65e0\u6743\u4fee\u6539\u4ed6\u4eba\u4fe1\u606f\uff01");
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getTenantId, (Object)Integer.valueOf(tenantId));
        query.eq(SysUserTenant::getUserId, (Object)sysUser.getId());
        SysUserTenant one = (SysUserTenant)this.userTenantService.getOne((Wrapper)query);
        if (null == one) {
            return result.error500("\u975e\u5f53\u524d\u79df\u6237\u4e0b\u7684\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        String departs = req.getParameter("selecteddeparts");
        this.sysUserService.editTenantUser(sysUser, tenantId, departs, null);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @PutMapping(value={"/changeLoginTenantId"})
    public Result<?> changeLoginTenantId(@RequestBody SysUser sysUser) {
        Result result = new Result();
        Integer tenantId = sysUser.getLoginTenantId();
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = loginUser.getId();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getTenantId, (Object)tenantId);
        query.eq(SysUserTenant::getUserId, (Object)userId);
        SysUserTenant one = (SysUserTenant)this.userTenantService.getOne((Wrapper)query);
        if (null == one) {
            return result.error500("\u975e\u79df\u6237\u4e0b\u7684\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        LambdaQueryWrapper update = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUser::getId, (Object)userId);
        SysUser updateUser = new SysUser();
        updateUser.setLoginTenantId(tenantId);
        this.sysUserService.update(updateUser, (Wrapper)update);
        return Result.ok();
    }

    @RequestMapping(value={"/exportAppUser"})
    public ModelAndView exportAppUser(HttpServletRequest request) {
        return this.sysUserService.exportAppUser(request);
    }

    @RequestMapping(value={"/importAppUser"}, method={RequestMethod.POST})
    public Result<?> importAppUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.sysUserService.importAppUser(request);
    }

    @PutMapping(value={"/changePhone"})
    public Result<String> changePhone(@RequestBody JSONObject json, HttpServletRequest request) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        this.sysUserService.changePhone(json, username);
        return Result.ok((String)"\u4fee\u6539\u624b\u673a\u53f7\u6210\u529f\uff01");
    }

    @PostMapping(value={"/sendChangePhoneSms"})
    public Result<String> sendChangePhoneSms(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        String ipAddress = IpUtils.getIpAddr((HttpServletRequest)request);
        this.sysUserService.sendChangePhoneSms(jsonObject, username, ipAddress);
        return Result.ok((String)"\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f\uff01");
    }

    @PostMapping(value={"/sendLogOffPhoneSms"})
    public Result<String> sendLogOffPhoneSms(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        Result result = new Result();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        String name = jsonObject.getString("username");
        if (oConvertUtils.isEmpty((Object)name) || !name.equals(username)) {
            result.setSuccess(false);
            result.setMessage("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5339\u914d\uff01");
            return result;
        }
        String ipAddress = IpUtils.getIpAddr((HttpServletRequest)request);
        this.sysUserService.sendLogOffPhoneSms(jsonObject, username, ipAddress);
        result.setSuccess(true);
        result.setMessage("\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f\uff01");
        return result;
    }
}

