/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.modules.redis.client.JeecgRedisClient;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysRolePermission;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.model.TreeModel;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.jeecg.modules.system.service.ISysRolePermissionService;
import org.jeecg.modules.system.service.ISysRoleService;
import org.jeecg.modules.system.service.ISysUserRoleService;
import org.jeecg.modules.system.vo.SysUserRoleCountVo;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/role"})
public class SysRoleController {
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ISysRolePermissionService sysRolePermissionService;
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private BaseCommonService baseCommonService;
    @Autowired
    private JeecgRedisClient jeecgRedisClient;

    @RequiresPermissions(value={"system:role:list"})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysRole>> queryPageList(SysRole role, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page<SysRole> pageList = this.sysRoleService.listAllSysRole((Page<SysRole>)page, role);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!sysUser.getUsername().equals("admin")) {
            List filteredRecords = pageList.getRecords().stream().filter(userRole -> !userRole.getRoleCode().equalsIgnoreCase("admin")).collect(Collectors.toList());
            pageList.setRecords(filteredRecords);
        }
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/listByTenant"}, method={RequestMethod.GET})
    public Result<IPage<SysRole>> listByTenant(SysRole role, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result result = new Result();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            role.setTenantId(oConvertUtils.getInt((String)(!"0".equals(TenantContext.getTenant()) ? TenantContext.getTenant() : ""), (int)-1));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)role, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysRoleService.page((IPage)page, (Wrapper)queryWrapper);
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"system:role:add"})
    public Result<SysRole> add(@RequestBody SysRole role) {
        Result result = new Result();
        try {
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && oConvertUtils.isEmpty((Object)role.getRoleCode())) {
                role.setRoleCode(RandomUtil.randomString((int)10));
            }
            role.setCreateTime(new Date());
            this.sysRoleService.save(role);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequiresPermissions(value={"system:role:edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<SysRole> edit(@RequestBody SysRole role) {
        Result result = new Result();
        SysRole sysrole = (SysRole)this.sysRoleService.getById((Serializable)((Object)role.getId()));
        if (sysrole == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u89d2\u8272\uff01");
        } else {
            boolean ok;
            role.setUpdateTime(new Date());
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
                String username = "admin";
                if (!tenantId.equals(sysrole.getTenantId()) && !username.equals(sysUser.getUsername())) {
                    this.baseCommonService.addLog("\u672a\u7ecf\u6388\u6743\uff0c\u4fee\u6539\u975e\u672c\u79df\u6237\u4e0b\u7684\u89d2\u8272ID\uff1a" + role.getId() + "\uff0c\u64cd\u4f5c\u4eba\uff1a" + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(3));
                    return Result.error((String)"\u4fee\u6539\u89d2\u8272\u5931\u8d25,\u5f53\u524d\u89d2\u8272\u4e0d\u5728\u6b64\u79df\u6237\u4e2d\u3002");
                }
            }
            if (ok = this.sysRoleService.updateById(role)) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequiresPermissions(value={"system:role:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
            Long getRoleCount = this.sysRoleService.getRoleCountByTenantId(id, tenantId);
            String username = "admin";
            if (getRoleCount == 0L && !username.equals(sysUser.getUsername())) {
                this.baseCommonService.addLog("\u672a\u7ecf\u6388\u6743\uff0c\u5220\u9664\u975e\u672c\u79df\u6237\u4e0b\u7684\u89d2\u8272ID\uff1a" + id + "\uff0c\u64cd\u4f5c\u4eba\uff1a" + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(4));
                return Result.error((String)"\u5220\u9664\u89d2\u8272\u5931\u8d25,\u5f53\u524d\u89d2\u8272\u4e0d\u5728\u6b64\u79df\u6237\u4e2d\u3002");
            }
        }
        this.sysRoleService.checkAdminRoleRejectDel(id);
        this.sysRoleService.deleteRole(id);
        return Result.ok((String)"\u5220\u9664\u89d2\u8272\u6210\u529f");
    }

    @RequiresPermissions(value={"system:role:deleteBatch"})
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<SysRole> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.baseCommonService.addLog("\u5220\u9664\u89d2\u8272\u64cd\u4f5c\uff0c\u89d2\u8272ids\uff1a" + ids, Integer.valueOf(2), Integer.valueOf(4));
        Result result = new Result();
        if (oConvertUtils.isEmpty((Object)ids)) {
            result.error500("\u672a\u9009\u4e2d\u89d2\u8272\uff01");
        } else {
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
                String[] roleIds = ids.split(",");
                LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
                String username = "admin";
                for (String id : roleIds) {
                    Long getRoleCount = this.sysRoleService.getRoleCountByTenantId(id, tenantId);
                    if (getRoleCount != 0L || username.equals(sysUser.getUsername())) continue;
                    this.baseCommonService.addLog("\u672a\u7ecf\u6388\u6743\uff0c\u5220\u9664\u975e\u672c\u79df\u6237\u4e0b\u7684\u89d2\u8272ID\uff1a" + id + "\uff0c\u64cd\u4f5c\u4eba\uff1a" + sysUser.getUsername(), Integer.valueOf(2), Integer.valueOf(4));
                    return Result.error((String)"\u6279\u91cf\u5220\u9664\u89d2\u8272\u5931\u8d25,\u5b58\u5728\u89d2\u8272\u4e0d\u5728\u6b64\u79df\u6237\u4e2d\uff0c\u7981\u6b62\u6279\u91cf\u5220\u9664");
                }
            }
            this.sysRoleService.checkAdminRoleRejectDel(ids);
            this.sysRoleService.deleteBatchRole(ids.split(","));
            result.success("\u5220\u9664\u89d2\u8272\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysRole> queryById(@RequestParam(name="id", required=true) String id) {
        Result result = new Result();
        SysRole sysrole = (SysRole)this.sysRoleService.getById((Serializable)((Object)id));
        if (sysrole == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult((Object)sysrole);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/queryall"}, method={RequestMethod.GET})
    public Result<List<SysRole>> queryall() {
        List list;
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysRole::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        if ((list = this.sysRoleService.list((Wrapper)query)) == null || list.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
        } else {
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        return result;
    }

    @RequiresPermissions(value={"system:role:queryallNoByTenant"})
    @RequestMapping(value={"/queryallNoByTenant"}, method={RequestMethod.GET})
    public Result<List<SysRole>> queryallNoByTenant() {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        List list = this.sysRoleService.list((Wrapper)query);
        if (list == null || list.size() <= 0) {
            result.error500("\u672a\u627e\u5230\u89d2\u8272\u4fe1\u606f");
        } else {
            result.setResult((Object)list);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/checkRoleCode"}, method={RequestMethod.GET})
    public Result<Boolean> checkUsername(String id, String roleCode) {
        Result result = new Result();
        result.setResult((Object)true);
        log.info("--\u9a8c\u8bc1\u89d2\u8272\u7f16\u7801\u662f\u5426\u552f\u4e00---id:" + id + "--roleCode:" + roleCode);
        try {
            SysRole newRole;
            SysRole role = null;
            if (oConvertUtils.isNotEmpty((Object)id)) {
                role = (SysRole)this.sysRoleService.getById((Serializable)((Object)id));
            }
            if ((newRole = this.sysRoleService.getRoleNoTenant(roleCode)) != null) {
                if (role == null) {
                    result.setSuccess(false);
                    result.setMessage("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    return result;
                }
                if (!id.equals(newRole.getId())) {
                    result.setSuccess(false);
                    result.setMessage("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    return result;
                }
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setResult((Object)false);
            result.setMessage(e.getMessage());
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysRole sysRole, HttpServletRequest request) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            sysRole.setTenantId(oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysRole, (Map)request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.sysRoleService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u89d2\u8272\u5217\u8868");
        mv.addObject("entity", SysRole.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u89d2\u8272\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                Result result = this.sysRoleService.importExcelCheckRoleCode(file, params);
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/datarule/{permissionId}/{roleId}"})
    public Result<?> loadDatarule(@PathVariable(value="permissionId") String permissionId, @PathVariable(value="roleId") String roleId) {
        String drChecked;
        List<SysPermissionDataRule> list = this.sysPermissionDataRuleService.getPermRuleListByPermId(permissionId);
        if (list == null || list.size() == 0) {
            return Result.error((String)"\u672a\u627e\u5230\u6743\u9650\u914d\u7f6e\u4fe1\u606f");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("datarule", list);
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRolePermission::getPermissionId, (Object)permissionId)).isNotNull(SysRolePermission::getDataRuleIds)).eq(SysRolePermission::getRoleId, (Object)roleId);
        SysRolePermission sysRolePermission = (SysRolePermission)this.sysRolePermissionService.getOne((Wrapper)query);
        if (sysRolePermission != null && oConvertUtils.isNotEmpty((Object)(drChecked = sysRolePermission.getDataRuleIds()))) {
            map.put("drChecked", drChecked.endsWith(",") ? drChecked.substring(0, drChecked.length() - 1) : drChecked);
        }
        return Result.ok(map);
    }

    @PostMapping(value={"/datarule"})
    public Result<?> saveDatarule(@RequestBody JSONObject jsonObject) {
        try {
            String permissionId = jsonObject.getString("permissionId");
            String roleId = jsonObject.getString("roleId");
            String dataRuleIds = jsonObject.getString("dataRuleIds");
            log.info("\u4fdd\u5b58\u6570\u636e\u89c4\u5219>>\u83dc\u5355ID:" + permissionId + "\u89d2\u8272ID:" + roleId + "\u6570\u636e\u6743\u9650ID:" + dataRuleIds);
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRolePermission::getPermissionId, (Object)permissionId)).eq(SysRolePermission::getRoleId, (Object)roleId);
            SysRolePermission sysRolePermission = (SysRolePermission)this.sysRolePermissionService.getOne((Wrapper)query);
            if (sysRolePermission == null) {
                return Result.error((String)"\u8bf7\u5148\u4fdd\u5b58\u89d2\u8272\u83dc\u5355\u6743\u9650!");
            }
            sysRolePermission.setDataRuleIds(dataRuleIds);
            this.sysRolePermissionService.updateById(sysRolePermission);
        }
        catch (Exception e) {
            log.error("SysRoleController.saveDatarule()\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return Result.ok((String)"\u4fdd\u5b58\u6210\u529f!");
    }

    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList(HttpServletRequest request) {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(SysPermission::getSortNo);
            List list = this.sysPermissionService.list((Wrapper)query);
            for (SysPermission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>(5);
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<SysPermission> metaList, TreeModel temp) {
        for (SysPermission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission.getId(), tempPid, permission.getName(), permission.getRuleFlag(), permission.isLeaf());
            if (temp == null && oConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }

    @RequestMapping(value={"/queryPageRoleCount"}, method={RequestMethod.GET})
    public Result<IPage<SysUserRoleCountVo>> queryPageRoleCount(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Result result = new Result();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysRole::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysRoleService.page((IPage)page, (Wrapper)query);
        List records = pageList.getRecords();
        PageDTO sysRoleCountPage = new PageDTO();
        ArrayList<SysUserRoleCountVo> sysCountVoList = new ArrayList<SysUserRoleCountVo>();
        for (SysRole role : records) {
            LambdaQueryWrapper countQuery = new LambdaQueryWrapper();
            countQuery.eq(SysUserRole::getRoleId, (Object)role.getId());
            long count = this.sysUserRoleService.count((Wrapper)countQuery);
            SysUserRoleCountVo countVo = new SysUserRoleCountVo();
            BeanUtils.copyProperties((Object)role, (Object)countVo);
            countVo.setCount(count);
            sysCountVoList.add(countVo);
        }
        sysRoleCountPage.setRecords(sysCountVoList);
        sysRoleCountPage.setTotal(pageList.getTotal());
        sysRoleCountPage.setSize(pageList.getSize());
        result.setSuccess(true);
        result.setResult((Object)sysRoleCountPage);
        return result;
    }
}

