/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysGatewayRoute;
import org.jeecg.modules.system.service.ISysGatewayRouteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"gateway\u8def\u7531\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/gatewayRoute"})
public class SysGatewayRouteController
extends JeecgController<SysGatewayRoute, ISysGatewayRouteService> {
    private static final Logger log = LoggerFactory.getLogger(SysGatewayRouteController.class);
    @Autowired
    private ISysGatewayRouteService sysGatewayRouteService;

    @PostMapping(value={"/updateAll"})
    public Result<?> updateAll(@RequestBody JSONObject json) {
        this.sysGatewayRouteService.updateAll(json);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysGatewayRoute sysGatewayRoute) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        List ls = this.sysGatewayRouteService.list((Wrapper)query);
        JSONArray array = new JSONArray();
        for (SysGatewayRoute rt : ls) {
            JSONObject obj = (JSONObject)JSONObject.toJSON((Object)rt);
            if (oConvertUtils.isNotEmpty((Object)rt.getPredicates())) {
                obj.put("predicates", (Object)JSONArray.parseArray((String)rt.getPredicates()));
            }
            if (oConvertUtils.isNotEmpty((Object)rt.getFilters())) {
                obj.put("filters", (Object)JSONArray.parseArray((String)rt.getFilters()));
            }
            array.add((Object)obj);
        }
        return Result.ok((Object)array);
    }

    @GetMapping(value={"/clearRedis"})
    public Result<?> clearRedis() {
        this.sysGatewayRouteService.clearRedis();
        return Result.ok((String)"\u6e05\u9664\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"system:getway:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysGatewayRouteService.deleteById(id);
        return Result.ok((String)"\u5220\u9664\u8def\u7531\u6210\u529f");
    }

    @RequestMapping(value={"/deleteList"}, method={RequestMethod.GET})
    public Result<List<SysGatewayRoute>> deleteList(HttpServletRequest request) {
        Result result = new Result();
        List<SysGatewayRoute> list = this.sysGatewayRouteService.getDeletelist();
        result.setSuccess(true);
        result.setResult(list);
        return result;
    }

    @RequiresPermissions(value={"system:gateway:putRecycleBin"})
    @RequestMapping(value={"/putRecycleBin"}, method={RequestMethod.PUT})
    public Result putRecycleBin(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        try {
            String ids = jsonObject.getString("ids");
            if (StringUtils.isNotBlank((String)ids)) {
                this.sysGatewayRouteService.revertLogicDeleted(Arrays.asList(ids.split(",")));
                return Result.ok((String)"\u64cd\u4f5c\u6210\u529f!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"\u64cd\u4f5c\u5931\u8d25!");
        }
        return Result.ok((String)"\u8fd8\u539f\u6210\u529f");
    }

    @RequiresPermissions(value={"system:gateway:deleteRecycleBin"})
    @RequestMapping(value={"/deleteRecycleBin"}, method={RequestMethod.DELETE})
    public Result deleteRecycleBin(@RequestParam(value="ids") String ids) {
        try {
            if (StringUtils.isNotBlank((String)ids)) {
                this.sysGatewayRouteService.deleteLogicDeleted(Arrays.asList(ids.split(",")));
            }
            return Result.ok((String)"\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)"\u5220\u9664\u5931\u8d25!");
        }
    }

    @RequiresPermissions(value={"system:gateway:copyRoute"})
    @RequestMapping(value={"/copyRoute"}, method={RequestMethod.GET})
    public Result<SysGatewayRoute> copyRoute(@RequestParam(name="id", required=true) String id, HttpServletRequest req) {
        Result result = new Result();
        SysGatewayRoute sysGatewayRoute = this.sysGatewayRouteService.copyRoute(id);
        result.setResult((Object)sysGatewayRoute);
        result.setSuccess(true);
        return result;
    }
}

