/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.filter.SsrfFileTypeFilter;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/sys/common"})
public class CommonController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Value(value="${jeecg.path.upload}")
    private String uploadpath;
    @Value(value="${jeecg.uploadType}")
    private String uploadType;

    @GetMapping(value={"/403"})
    public Result<?> noauth() {
        return Result.error((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01");
    }

    @PostMapping(value={"/upload"})
    public Result<?> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Result result = new Result();
        String savePath = "";
        String bizPath = request.getParameter("biz");
        if (oConvertUtils.isNotEmpty((Object)bizPath) && (bizPath.contains("../") || bizPath.contains("..\\"))) {
            throw new JeecgBootException("\u4e0a\u4f20\u76ee\u5f55bizPath\uff0c\u683c\u5f0f\u975e\u6cd5\uff01");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = multipartRequest.getFile("file");
        if (oConvertUtils.isEmpty((Object)bizPath)) {
            bizPath = "alioss".equals(this.uploadType) ? "upload" : "";
        }
        if ("local".equals(this.uploadType)) {
            SsrfFileTypeFilter.checkUploadFileType((MultipartFile)file);
            savePath = this.uploadLocal(file, bizPath);
        } else {
            savePath = CommonUtils.upload((MultipartFile)file, (String)bizPath, (String)this.uploadType);
        }
        if (oConvertUtils.isNotEmpty((Object)savePath)) {
            result.setMessage(savePath);
            result.setSuccess(true);
        } else {
            result.setMessage("\u4e0a\u4f20\u5931\u8d25\uff01");
            result.setSuccess(false);
        }
        return result;
    }

    private String uploadLocal(MultipartFile mf, String bizPath) {
        try {
            String ctxPath = this.uploadpath;
            String fileName = null;
            File file = new File(ctxPath + File.separator + bizPath + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            String orgName = mf.getOriginalFilename();
            fileName = (orgName = CommonUtils.getFileName((String)orgName)).indexOf(".") != -1 ? orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf(".")) : orgName + "_" + System.currentTimeMillis();
            String savePath = file.getPath() + File.separator + fileName;
            File savefile = new File(savePath);
            FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            String dbpath = null;
            dbpath = oConvertUtils.isNotEmpty((Object)bizPath) ? bizPath + File.separator + fileName : fileName;
            if (dbpath.contains("\\")) {
                dbpath = dbpath.replace("\\", "/");
            }
            return dbpath;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/static/**"})
    public void view(HttpServletRequest request, HttpServletResponse response) {
        String imgPath = CommonController.extractPathFromPattern(request);
        if (oConvertUtils.isEmpty((Object)imgPath) || "null".equals(imgPath)) {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int len;
            imgPath = imgPath.replace("..", "").replace("../", "");
            if (imgPath.endsWith(",")) {
                imgPath = imgPath.substring(0, imgPath.length() - 1);
            }
            SsrfFileTypeFilter.checkDownloadFileType((String)imgPath);
            String filePath = this.uploadpath + File.separator + imgPath;
            File file = new File(filePath);
            if (!file.exists()) {
                response.setStatus(404);
                log.error("\u6587\u4ef6[" + imgPath + "]\u4e0d\u5b58\u5728..");
                return;
            }
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + new String(file.getName().getBytes("UTF-8"), "iso-8859-1"));
            inputStream = new BufferedInputStream(new FileInputStream(filePath));
            outputStream = response.getOutputStream();
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error("\u9884\u89c8\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.setStatus(404);
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @RequestMapping(value={"/pdf/pdfPreviewIframe"})
    public ModelAndView pdfPreviewIframe(ModelAndView modelAndView) {
        modelAndView.setViewName("pdfPreviewIframe");
        return modelAndView;
    }

    private static String extractPathFromPattern(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        return new AntPathMatcher().extractPathWithinPattern(bestMatchPattern, path);
    }
}

