/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.quartz.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.quartz.entity.QuartzJob;
import org.jeecg.modules.quartz.mapper.QuartzJobMapper;
import org.jeecg.modules.quartz.service.IQuartzJobService;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuartzJobServiceImpl
extends ServiceImpl<QuartzJobMapper, QuartzJob>
implements IQuartzJobService {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobServiceImpl.class);
    @Autowired
    private QuartzJobMapper quartzJobMapper;
    @Autowired
    private Scheduler scheduler;
    private static final String JOB_TEST_GROUP = "test_group";

    @Override
    public List<QuartzJob> findByJobClassName(String jobClassName) {
        return this.quartzJobMapper.findByJobClassName(jobClassName);
    }

    @Override
    @Transactional(rollbackFor={JeecgBootException.class})
    public boolean saveAndScheduleJob(QuartzJob quartzJob) {
        quartzJob.setDelFlag(CommonConstant.DEL_FLAG_0);
        boolean success = this.save(quartzJob);
        if (success && CommonConstant.STATUS_NORMAL.equals(quartzJob.getStatus())) {
            this.schedulerAdd(quartzJob.getId(), quartzJob.getJobClassName().trim(), quartzJob.getCronExpression().trim(), quartzJob.getParameter());
        }
        return success;
    }

    @Override
    @Transactional(rollbackFor={JeecgBootException.class})
    public boolean resumeJob(QuartzJob quartzJob) {
        this.schedulerDelete(quartzJob.getId());
        this.schedulerAdd(quartzJob.getId(), quartzJob.getJobClassName().trim(), quartzJob.getCronExpression().trim(), quartzJob.getParameter());
        quartzJob.setStatus(CommonConstant.STATUS_NORMAL);
        return this.updateById(quartzJob);
    }

    @Override
    @Transactional(rollbackFor={JeecgBootException.class})
    public boolean editAndScheduleJob(QuartzJob quartzJob) throws SchedulerException {
        if (CommonConstant.STATUS_NORMAL.equals(quartzJob.getStatus())) {
            this.schedulerDelete(quartzJob.getId());
            this.schedulerAdd(quartzJob.getId(), quartzJob.getJobClassName().trim(), quartzJob.getCronExpression().trim(), quartzJob.getParameter());
        } else {
            this.scheduler.pauseJob(JobKey.jobKey((String)quartzJob.getId()));
        }
        return this.updateById(quartzJob);
    }

    @Override
    @Transactional(rollbackFor={JeecgBootException.class})
    public boolean deleteAndStopJob(QuartzJob job) {
        this.schedulerDelete(job.getId());
        boolean ok = this.removeById((Serializable)((Object)job.getId()));
        return ok;
    }

    @Override
    public void execute(QuartzJob quartzJob) throws Exception {
        String jobName = quartzJob.getJobClassName().trim();
        Date startDate = new Date();
        String ymd = DateUtils.date2Str((Date)startDate, (SimpleDateFormat)((SimpleDateFormat)DateUtils.yyyymmddhhmmss.get()));
        String identity = jobName + ymd;
        startDate.setTime(startDate.getTime() + 100L);
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(identity, JOB_TEST_GROUP).startAt(startDate).build();
        JobDetail jobDetail = JobBuilder.newJob(QuartzJobServiceImpl.getClass(jobName).getClass()).withIdentity(identity).usingJobData("parameter", quartzJob.getParameter()).build();
        this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        this.scheduler.start();
    }

    @Override
    @Transactional(rollbackFor={JeecgBootException.class})
    public void pause(QuartzJob quartzJob) {
        this.schedulerDelete(quartzJob.getId());
        quartzJob.setStatus(CommonConstant.STATUS_DISABLE);
        this.updateById(quartzJob);
    }

    private void schedulerAdd(String id, String jobClassName, String cronExpression, String parameter) {
        try {
            this.scheduler.start();
            JobDetail jobDetail = JobBuilder.newJob(QuartzJobServiceImpl.getClass(jobClassName).getClass()).withIdentity(id).usingJobData("parameter", parameter).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(id).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new JeecgBootException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new JeecgBootException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new JeecgBootException("\u540e\u53f0\u627e\u4e0d\u5230\u8be5\u7c7b\u540d\uff1a" + jobClassName, (Throwable)e);
        }
    }

    private void schedulerDelete(String id) {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)id));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)id));
            this.scheduler.deleteJob(JobKey.jobKey((String)id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JeecgBootException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    private static Job getClass(String classname) throws Exception {
        Class<?> class1 = Class.forName(classname);
        return (Job)class1.newInstance();
    }
}

