/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.openapi.filter;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.openapi.entity.OpenApi;
import org.jeecg.modules.openapi.entity.OpenApiAuth;
import org.jeecg.modules.openapi.entity.OpenApiPermission;
import org.jeecg.modules.openapi.entity.OpenApiRecord;
import org.jeecg.modules.openapi.service.OpenApiAuthService;
import org.jeecg.modules.openapi.service.OpenApiPermissionService;
import org.jeecg.modules.openapi.service.OpenApiRecordService;
import org.jeecg.modules.openapi.service.OpenApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class ApiAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ApiAuthFilter.class);
    private OpenApiRecordService openApiRecordService;
    private OpenApiAuthService openApiAuthService;
    private OpenApiPermissionService openApiPermissionService;
    private OpenApiService openApiService;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        Date callTime = new Date();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String ip = request.getRemoteAddr();
        String appkey = request.getHeader("appkey");
        String signature = request.getHeader("signature");
        String timestamp = request.getHeader("timestamp");
        OpenApi openApi = this.findOpenApi(request);
        this.checkBlackList(openApi, ip);
        this.checkSignValid(appkey, signature, timestamp);
        OpenApiAuth openApiAuth = this.openApiAuthService.getByAppkey(appkey);
        this.checkSignature(appkey, signature, timestamp, openApiAuth);
        this.checkPermission(openApi, openApiAuth);
        filterChain.doFilter(servletRequest, servletResponse);
        long endTime = System.currentTimeMillis();
        OpenApiRecord record = new OpenApiRecord();
        record.setApiId(openApi.getId());
        record.setCallAuthId(openApiAuth.getId());
        record.setCallTime(callTime);
        record.setUsedTime(endTime - startTime);
        record.setResponseTime(new Date());
        this.openApiRecordService.save(record);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        WebApplicationContext applicationContext = (WebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.openApiService = (OpenApiService)applicationContext.getBean(OpenApiService.class);
        this.openApiRecordService = (OpenApiRecordService)applicationContext.getBean(OpenApiRecordService.class);
        this.openApiAuthService = (OpenApiAuthService)applicationContext.getBean(OpenApiAuthService.class);
        this.openApiPermissionService = (OpenApiPermissionService)applicationContext.getBean(OpenApiPermissionService.class);
    }

    protected void checkBlackList(OpenApi openApi, String ip) {
        if (!StringUtils.hasText((String)openApi.getBlackList())) {
            return;
        }
        List<String> blackList = Arrays.asList(openApi.getBlackList().split(","));
        if (blackList.contains(ip)) {
            throw new JeecgBootException("\u76ee\u6807\u63a5\u53e3\u9650\u5236IP[" + ip + "]\u8fdb\u884c\u8bbf\u95ee\uff0cIP\u5df2\u8bb0\u5f55\uff0c\u8bf7\u505c\u6b62\u8bbf\u95ee");
        }
    }

    protected void checkSignValid(String appkey, String signature, String timestamp) {
        if (!StringUtils.hasText((String)appkey)) {
            throw new JeecgBootException("appkey\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)signature)) {
            throw new JeecgBootException("signature\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)timestamp)) {
            throw new JeecgBootException("timastamp\u65f6\u95f4\u6233\u4e3a\u7a7a");
        }
        if (!timestamp.matches("[0-9]*")) {
            throw new JeecgBootException("timastamp\u65f6\u95f4\u6233\u4e0d\u5408\u6cd5");
        }
        if (System.currentTimeMillis() - Long.parseLong(timestamp) > 300000L) {
            throw new JeecgBootException("signature\u7b7e\u540d\u5df2\u8fc7\u671f(\u8d85\u8fc7\u4e94\u5206\u949f)");
        }
    }

    protected void checkSignature(String appKey, String signature, String timestamp, OpenApiAuth openApiAuth) {
        if (openApiAuth == null) {
            throw new JeecgBootException("\u4e0d\u5b58\u5728\u8ba4\u8bc1\u4fe1\u606f");
        }
        if (!appKey.equals(openApiAuth.getAk())) {
            throw new JeecgBootException("appkey\u9519\u8bef");
        }
        if (!signature.equals(ApiAuthFilter.md5(appKey + openApiAuth.getSk() + timestamp))) {
            throw new JeecgBootException("signature\u7b7e\u540d\u9519\u8bef");
        }
    }

    protected void checkPermission(OpenApi openApi, OpenApiAuth openApiAuth) {
        List<OpenApiPermission> permissionList = this.openApiPermissionService.findByAuthId(openApiAuth.getId());
        boolean hasPermission = false;
        for (OpenApiPermission permission : permissionList) {
            if (!permission.getApiId().equals(openApi.getId())) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            throw new JeecgBootException("\u8be5appKey\u672a\u6388\u6743\u5f53\u524d\u63a5\u53e3");
        }
    }

    protected static String md5(String sourceStr) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sourceStr.getBytes("utf-8"));
            byte[] hash = md.digest();
            StringBuffer buf = new StringBuffer(32);
            for (int offset = 0; offset < hash.length; ++offset) {
                int i = hash[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            result = buf.toString();
        }
        catch (Exception e) {
            log.error("sign\u7b7e\u540d\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    protected OpenApi findOpenApi(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String path = uri.substring(uri.lastIndexOf("/") + 1);
        return this.openApiService.findByPath(path);
    }

    public static void main(String[] args) {
        long timestamp = System.currentTimeMillis();
        System.out.println("timestamp:" + timestamp);
        System.out.println("signature:" + ApiAuthFilter.md5("ak-eAU25mrMxhtaZsySrjxMqB6YyUXpSHAz4DCIz8vZ5aozQQiV" + timestamp));
    }
}

