/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.monitor.actuator.httptrace;

import java.util.List;
import org.jeecg.modules.monitor.actuator.httptrace.CustomInMemoryHttpTraceRepository;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.trace.http.HttpTrace;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Endpoint(id="jeecghttptrace")
public class CustomHttpTraceEndpoint {
    private final CustomInMemoryHttpTraceRepository repository;

    public CustomHttpTraceEndpoint(CustomInMemoryHttpTraceRepository repository) {
        Assert.notNull((Object)((Object)repository), (String)"Repository must not be null");
        this.repository = repository;
    }

    @ReadOperation
    public HttpTraceDescriptor traces(@Selector(match=Selector.Match.ALL_REMAINING) String query) {
        return new HttpTraceDescriptor(this.repository.findAll(query));
    }

    public static final class HttpTraceDescriptor {
        private final List<HttpTrace> traces;

        private HttpTraceDescriptor(List<HttpTrace> traces) {
            this.traces = traces;
        }

        public List<HttpTrace> getTraces() {
            return this.traces;
        }
    }
}

