/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.handle.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.Vue3MessageHrefEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.message.handle.ISendMsgHandle;
import org.jeecg.modules.message.websocket.WebSocket;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.mapper.SysAnnouncementMapper;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.springframework.stereotype.Component;

@Component(value="systemSendMsgHandle")
public class SystemSendMsgHandle
implements ISendMsgHandle {
    public static final String FROM_USER = "system";
    @Resource
    private SysAnnouncementMapper sysAnnouncementMapper;
    @Resource
    private SysUserMapper userMapper;
    @Resource
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Resource
    private WebSocket webSocket;

    @Override
    public void sendMsg(String esReceiver, String esTitle, String esContent) {
        if (oConvertUtils.isEmpty((Object)esReceiver)) {
            throw new JeecgBootException("\u88ab\u53d1\u9001\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ISysBaseAPI sysBaseApi = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        MessageDTO messageDTO = new MessageDTO(FROM_USER, esReceiver, esTitle, esContent);
        sysBaseApi.sendSysAnnouncement(messageDTO);
    }

    @Override
    public void sendMessage(MessageDTO messageDTO) {
        String[] arr;
        String title = messageDTO.getTitle();
        String content = messageDTO.getContent();
        String fromUser = messageDTO.getFromUser();
        Map data = messageDTO.getData();
        for (String username : arr = messageDTO.getToUser().split(",")) {
            this.doSend(title, content, fromUser, username, data);
        }
    }

    private void doSend(String title, String msgContent, String fromUser, String toUser, Map<String, Object> data) {
        SysAnnouncement announcement = new SysAnnouncement();
        if (data != null) {
            Object busType;
            Object taskId;
            Object msgAbstract = data.get("NOTICE_MSG_SUMMARY");
            if (msgAbstract != null) {
                announcement.setMsgAbstract(msgAbstract.toString());
            }
            if ((taskId = data.get("NOTICE_MSG_BUS_ID")) != null) {
                announcement.setBusId(taskId.toString());
                announcement.setBusType(Vue3MessageHrefEnum.BPM_TASK.getBusType());
            }
            if ((busType = data.get("NOTICE_MSG_BUS_TYPE")) != null) {
                announcement.setBusType(busType.toString());
            }
        }
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
    }
}

