/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.api.controller;

import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jeecg.common.api.dto.DataLogDTO;
import org.jeecg.common.api.dto.OnlineAuthDTO;
import org.jeecg.common.api.dto.message.BusMessageDTO;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.dto.message.TemplateDTO;
import org.jeecg.common.api.dto.message.TemplateMessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.desensitization.util.SensitiveInfoUtil;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysCategoryModel;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.impl.SysBaseApiImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/api"})
public class SystemApiController {
    private static final Logger log = LoggerFactory.getLogger(SystemApiController.class);
    @Autowired
    private SysBaseApiImpl sysBaseApi;
    @Autowired
    private ISysUserService sysUserService;

    @PostMapping(value={"/sendSysAnnouncement"})
    public void sendSysAnnouncement(@RequestBody MessageDTO message) {
        this.sysBaseApi.sendSysAnnouncement(message);
    }

    @PostMapping(value={"/sendBusAnnouncement"})
    public void sendBusAnnouncement(@RequestBody BusMessageDTO message) {
        this.sysBaseApi.sendBusAnnouncement(message);
    }

    @PostMapping(value={"/sendTemplateAnnouncement"})
    public void sendTemplateAnnouncement(@RequestBody TemplateMessageDTO message) {
        this.sysBaseApi.sendTemplateAnnouncement(message);
    }

    @PostMapping(value={"/sendBusTemplateAnnouncement"})
    public void sendBusTemplateAnnouncement(@RequestBody BusTemplateMessageDTO message) {
        this.sysBaseApi.sendBusTemplateAnnouncement(message);
    }

    @PostMapping(value={"/parseTemplateByCode"})
    public String parseTemplateByCode(@RequestBody TemplateDTO templateDTO) {
        return this.sysBaseApi.parseTemplateByCode(templateDTO);
    }

    @GetMapping(value={"/updateSysAnnounReadFlag"})
    public void updateSysAnnounReadFlag(@RequestParam(value="busType") String busType, @RequestParam(value="busId") String busId) {
        this.sysBaseApi.updateSysAnnounReadFlag(busType, busId);
    }

    @GetMapping(value={"/getUserByName"})
    public LoginUser getUserByName(@RequestParam(value="username") String username) {
        LoginUser loginUser = this.sysBaseApi.getUserByName(username);
        try {
            SensitiveInfoUtil.handlerObject((Object)loginUser, (boolean)true);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return loginUser;
    }

    @GetMapping(value={"/getUserIdByName"})
    public String getUserIdByName(@RequestParam(value="username") String username) {
        String userId = this.sysBaseApi.getUserIdByName(username);
        return userId;
    }

    @GetMapping(value={"/getUserById"})
    LoginUser getUserById(@RequestParam(value="id") String id) {
        LoginUser loginUser = this.sysBaseApi.getUserById(id);
        try {
            SensitiveInfoUtil.handlerObject((Object)loginUser, (boolean)true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return loginUser;
    }

    @GetMapping(value={"/getRolesByUsername"})
    List<String> getRolesByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getRolesByUsername(username);
    }

    @GetMapping(value={"/getRolesByUserId"})
    List<String> getRolesByUserId(@RequestParam(value="userId") String userId) {
        return this.sysBaseApi.getRolesByUserId(userId);
    }

    @GetMapping(value={"/getDepartIdsByUsername"})
    List<String> getDepartIdsByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getDepartIdsByUsername(username);
    }

    @GetMapping(value={"/getDepartIdsByUserId"})
    List<String> getDepartIdsByUserId(@RequestParam(value="userId") String userId) {
        return this.sysBaseApi.getDepartIdsByUserId(userId);
    }

    @GetMapping(value={"/getDepartParentIdsByUsername"})
    Set<String> getDepartParentIdsByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getDepartParentIdsByUsername(username);
    }

    @GetMapping(value={"/getDepartParentIdsByDepIds"})
    Set<String> getDepartParentIdsByDepIds(@RequestParam(value="depIds") Set<String> depIds) {
        return this.sysBaseApi.getDepartParentIdsByDepIds(depIds);
    }

    @GetMapping(value={"/getDepartNamesByUsername"})
    List<String> getDepartNamesByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getDepartNamesByUsername(username);
    }

    @GetMapping(value={"/queryDictItemsByCode"})
    List<DictModel> queryDictItemsByCode(@RequestParam(value="code") String code) {
        return this.sysBaseApi.queryDictItemsByCode(code);
    }

    @GetMapping(value={"/queryEnableDictItemsByCode"})
    List<DictModel> queryEnableDictItemsByCode(@RequestParam(value="code") String code) {
        return this.sysBaseApi.queryEnableDictItemsByCode(code);
    }

    @GetMapping(value={"/queryAllDict"})
    List<DictModel> queryAllDict() {
        log.info("--\u6211\u662fjeecg-system\u670d\u52a1\u8282\u70b9\uff0c\u5fae\u670d\u52a1\u63a5\u53e3queryAllDict\u88ab\u8c03\u7528--");
        return this.sysBaseApi.queryAllDict();
    }

    @GetMapping(value={"/queryAllSysCategory"})
    List<SysCategoryModel> queryAllSysCategory() {
        return this.sysBaseApi.queryAllSysCategory();
    }

    @GetMapping(value={"/queryAllDepartBackDictModel"})
    List<DictModel> queryAllDepartBackDictModel() {
        return this.sysBaseApi.queryAllDepartBackDictModel();
    }

    @GetMapping(value={"/queryAllRole"})
    public List<ComboModel> queryAllRole(@RequestParam(name="roleIds", required=false) String[] roleIds) {
        if (roleIds == null || roleIds.length == 0) {
            return this.sysBaseApi.queryAllRole();
        }
        return this.sysBaseApi.queryAllRole(roleIds);
    }

    @GetMapping(value={"/getRoleIdsByUsername"})
    public List<String> getRoleIdsByUsername(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getRoleIdsByUsername(username);
    }

    @GetMapping(value={"/getDepartIdsByOrgCode"})
    public String getDepartIdsByOrgCode(@RequestParam(value="orgCode") String orgCode) {
        return this.sysBaseApi.getDepartIdsByOrgCode(orgCode);
    }

    @GetMapping(value={"/getAllSysDepart"})
    public List<SysDepartModel> getAllSysDepart() {
        return this.sysBaseApi.getAllSysDepart();
    }

    @GetMapping(value={"/getDynamicDbSourceById"})
    DynamicDataSourceModel getDynamicDbSourceById(@RequestParam(value="dbSourceId") String dbSourceId) {
        return this.sysBaseApi.getDynamicDbSourceById(dbSourceId);
    }

    @GetMapping(value={"/getDeptHeadByDepId"})
    public List<String> getDeptHeadByDepId(@RequestParam(value="deptId") String deptId) {
        return this.sysBaseApi.getDeptHeadByDepId(deptId);
    }

    @GetMapping(value={"/getParentDepartId"})
    public DictModel getParentDepartId(@RequestParam(value="departId") String departId) {
        return this.sysBaseApi.getParentDepartId(departId);
    }

    @GetMapping(value={"/getDynamicDbSourceByCode"})
    public DynamicDataSourceModel getDynamicDbSourceByCode(@RequestParam(value="dbSourceCode") String dbSourceCode) {
        return this.sysBaseApi.getDynamicDbSourceByCode(dbSourceCode);
    }

    @GetMapping(value={"/sendWebSocketMsg"})
    public void sendWebSocketMsg(String[] userIds, String cmd) {
        this.sysBaseApi.sendWebSocketMsg(userIds, cmd);
    }

    @GetMapping(value={"/queryAllUserByIds"})
    public List<UserAccountInfo> queryAllUserByIds(@RequestParam(value="userIds") String[] userIds) {
        return this.sysBaseApi.queryAllUserByIds(userIds);
    }

    @GetMapping(value={"/queryAllUserBackCombo"})
    public List<ComboModel> queryAllUserBackCombo() {
        return this.sysBaseApi.queryAllUserBackCombo();
    }

    @GetMapping(value={"/queryAllUser"})
    public JSONObject queryAllUser(@RequestParam(name="userIds", required=false) String userIds, @RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        return this.sysBaseApi.queryAllUser(userIds, pageNo, pageSize);
    }

    @GetMapping(value={"/meetingSignWebsocket"})
    public void meetingSignWebsocket(@RequestParam(value="userId") String userId) {
        this.sysBaseApi.meetingSignWebsocket(userId);
    }

    @GetMapping(value={"/queryUserByNames"})
    public List<UserAccountInfo> queryUserByNames(@RequestParam(value="userNames") String[] userNames) {
        return this.sysBaseApi.queryUserByNames(userNames);
    }

    @GetMapping(value={"/getUserRoleSet"})
    public Set<String> getUserRoleSet(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getUserRoleSet(username);
    }

    @GetMapping(value={"/getUserRoleSetById"})
    public Set<String> getUserRoleSetById(@RequestParam(value="userId") String userId) {
        return this.sysBaseApi.getUserRoleSetById(userId);
    }

    @GetMapping(value={"/getUserPermissionSet"})
    public Set<String> getUserPermissionSet(@RequestParam(value="userId") String userId) {
        return this.sysBaseApi.getUserPermissionSet(userId);
    }

    @PostMapping(value={"/hasOnlineAuth"})
    public boolean hasOnlineAuth(@RequestBody OnlineAuthDTO onlineAuthDTO) {
        return this.sysBaseApi.hasOnlineAuth(onlineAuthDTO);
    }

    @GetMapping(value={"/queryUserRoles"})
    public Set<String> queryUserRoles(@RequestParam(value="username") String username) {
        return this.sysUserService.getUserRolesSet(username);
    }

    @GetMapping(value={"/queryUserRolesById"})
    public Set<String> queryUserRolesById(@RequestParam(value="userId") String userId) {
        return this.sysUserService.getUserRoleSetById(userId);
    }

    @GetMapping(value={"/queryUserAuths"})
    public Set<String> queryUserAuths(@RequestParam(value="userId") String userId) {
        return this.sysUserService.getUserPermissionsSet(userId);
    }

    @GetMapping(value={"/selectAllById"})
    public SysDepartModel selectAllById(@RequestParam(value="id") String id) {
        return this.sysBaseApi.selectAllById(id);
    }

    @GetMapping(value={"/queryDeptUsersByUserId"})
    public List<String> queryDeptUsersByUserId(@RequestParam(value="userId") String userId) {
        return this.sysBaseApi.queryDeptUsersByUserId(userId);
    }

    @GetMapping(value={"/queryPermissionDataRule"})
    public List<SysPermissionDataRuleModel> queryPermissionDataRule(@RequestParam(value="component") String component, @RequestParam(value="requestPath") String requestPath, @RequestParam(value="username") String username) {
        return this.sysBaseApi.queryPermissionDataRule(component, requestPath, username);
    }

    @GetMapping(value={"/getCacheUser"})
    public SysUserCacheInfo getCacheUser(@RequestParam(value="username") String username) {
        return this.sysBaseApi.getCacheUser(username);
    }

    @GetMapping(value={"/translateDict"})
    public String translateDict(@RequestParam(value="code") String code, @RequestParam(value="key") String key) {
        return this.sysBaseApi.translateDict(code, key);
    }

    @RequestMapping(value={"/queryUsersByUsernames"})
    List<JSONObject> queryUsersByUsernames(@RequestParam(value="usernames") String usernames) {
        return this.sysBaseApi.queryUsersByUsernames(usernames);
    }

    @RequestMapping(value={"/queryUsersByIds"})
    List<JSONObject> queryUsersByIds(@RequestParam(value="ids") String ids) {
        return this.sysBaseApi.queryUsersByIds(ids);
    }

    @GetMapping(value={"/queryDepartsByOrgcodes"})
    List<JSONObject> queryDepartsByOrgcodes(@RequestParam(value="orgCodes") String orgCodes) {
        return this.sysBaseApi.queryDepartsByOrgcodes(orgCodes);
    }

    @GetMapping(value={"/queryDepartsByIds"})
    List<JSONObject> queryDepartsByIds(@RequestParam(value="ids") String ids) {
        return this.sysBaseApi.queryDepartsByIds(ids);
    }

    @GetMapping(value={"/sendEmailMsg"})
    public void sendEmailMsg(@RequestParam(value="email") String email, @RequestParam(value="title") String title, @RequestParam(value="content") String content) {
        this.sysBaseApi.sendEmailMsg(email, title, content);
    }

    @GetMapping(value={"/getDeptUserByOrgCode"})
    List<Map> getDeptUserByOrgCode(@RequestParam(value="orgCode") String orgCode) {
        return this.sysBaseApi.getDeptUserByOrgCode(orgCode);
    }

    @GetMapping(value={"/loadCategoryDictItem"})
    public List<String> loadCategoryDictItem(@RequestParam(value="ids") String ids) {
        return this.sysBaseApi.loadCategoryDictItem(ids);
    }

    @GetMapping(value={"/loadCategoryDictItemByNames"})
    List<String> loadCategoryDictItemByNames(@RequestParam(value="names") String names, @RequestParam(value="delNotExist") boolean delNotExist) {
        return this.sysBaseApi.loadCategoryDictItemByNames(names, delNotExist);
    }

    @GetMapping(value={"/loadDictItem"})
    public List<String> loadDictItem(@RequestParam(value="dictCode") String dictCode, @RequestParam(value="keys") String keys) {
        return this.sysBaseApi.loadDictItem(dictCode, keys);
    }

    @GetMapping(value={"/copyLowAppDict"})
    Map<String, String> copyLowAppDict(@RequestParam(value="originalAppId") String originalAppId, @RequestParam(value="appId") String appId, @RequestParam(value="tenantId") String tenantId) {
        return this.sysBaseApi.copyLowAppDict(originalAppId, appId, tenantId);
    }

    @GetMapping(value={"/getDictItems"})
    public List<DictModel> getDictItems(@RequestParam(value="dictCode") String dictCode) {
        return this.sysBaseApi.getDictItems(dictCode);
    }

    @RequestMapping(value={"/getManyDictItems"})
    public Map<String, List<DictModel>> getManyDictItems(@RequestParam(value="dictCodeList") List<String> dictCodeList) {
        return this.sysBaseApi.getManyDictItems(dictCodeList);
    }

    @GetMapping(value={"/loadDictItemByKeyword"})
    public List<DictModel> loadDictItemByKeyword(@RequestParam(value="dictCode") String dictCode, @RequestParam(value="keyword") String keyword, @RequestParam(value="pageNo", defaultValue="1", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.sysBaseApi.loadDictItemByKeyword(dictCode, keyword, pageNo, pageSize);
    }

    @GetMapping(value={"/translateManyDict"})
    public Map<String, List<DictModel>> translateManyDict(@RequestParam(value="dictCodes") String dictCodes, @RequestParam(value="keys") String keys) {
        return this.sysBaseApi.translateManyDict(dictCodes, keys);
    }

    @GetMapping(value={"/queryTableDictItemsByCode"})
    List<DictModel> queryTableDictItemsByCode(@RequestParam(value="tableFilterSql") String tableFilterSql, @RequestParam(value="text") String text, @RequestParam(value="code") String code) {
        return this.sysBaseApi.queryTableDictItemsByCode(tableFilterSql, text, code);
    }

    @GetMapping(value={"/queryFilterTableDictInfo"})
    List<DictModel> queryFilterTableDictInfo(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="filterSql") String filterSql) {
        return this.sysBaseApi.queryFilterTableDictInfo(table, text, code, filterSql);
    }

    @Deprecated
    @GetMapping(value={"/queryTableDictByKeys"})
    public List<String> queryTableDictByKeys(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="keyArray") String[] keyArray) {
        return this.sysBaseApi.queryTableDictByKeys(table, text, code, keyArray);
    }

    @GetMapping(value={"/translateDictFromTable"})
    public String translateDictFromTable(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="key") String key) {
        return this.sysBaseApi.translateDictFromTable(table, text, code, key);
    }

    @GetMapping(value={"/translateDictFromTableByKeys"})
    public List<DictModel> translateDictFromTableByKeys(@RequestParam(value="table") String table, @RequestParam(value="text") String text, @RequestParam(value="code") String code, @RequestParam(value="keys") String keys, @RequestParam(value="ds") String ds) {
        return this.sysBaseApi.translateDictFromTableByKeys(table, text, code, keys, ds);
    }

    @PostMapping(value={"/sendTemplateMessage"})
    public void sendTemplateMessage(@RequestBody MessageDTO message) {
        this.sysBaseApi.sendTemplateMessage(message);
    }

    @GetMapping(value={"/getTemplateContent"})
    public String getTemplateContent(@RequestParam(value="code") String code) {
        return this.sysBaseApi.getTemplateContent(code);
    }

    @PostMapping(value={"/saveDataLog"})
    public void saveDataLog(@RequestBody DataLogDTO dataLogDto) {
        this.sysBaseApi.saveDataLog(dataLogDto);
    }

    @PutMapping(value={"/updateAvatar"})
    public void updateAvatar(@RequestBody LoginUser loginUser) {
        this.sysBaseApi.updateAvatar(loginUser);
    }

    @GetMapping(value={"/sendAppChatSocket"})
    public void sendAppChatSocket(@RequestParam(name="userId") String userId) {
        this.sysBaseApi.sendAppChatSocket(userId);
    }

    @GetMapping(value={"/queryRoleDictByCode"})
    public List<DictModel> queryRoleDictByCode(@RequestParam(name="roleCodes") String roleCodes) {
        return this.sysBaseApi.queryRoleDictByCode(roleCodes);
    }

    @GetMapping(value={"/getRoleCode"})
    public String getRoleCode(@RequestParam(value="id") String id) {
        return this.sysBaseApi.getRoleCodeById(id);
    }

    @ExceptionHandler(value={SQLException.class})
    public Result<?> handleSQLException(Exception e) {
        String msg = e.getMessage();
        String extractvalue = "extractvalue";
        String updatexml = "updatexml";
        if (msg != null && (msg.toLowerCase().indexOf(extractvalue) >= 0 || msg.toLowerCase().indexOf(updatexml) >= 0)) {
            return Result.error((String)"\u6821\u9a8c\u5931\u8d25\uff0csql\u89e3\u6790\u5f02\u5e38\uff01");
        }
        return Result.error((String)("\u6821\u9a8c\u5931\u8d25\uff0csql\u89e3\u6790\u5f02\u5e38\uff01" + msg));
    }

    @GetMapping(value={"/queryUserBySuperQuery"})
    public List<JSONObject> queryUserBySuperQuery(@RequestParam(value="superQuery") String superQuery, @RequestParam(value="matchType") String matchType) {
        return this.sysBaseApi.queryUserBySuperQuery(superQuery, matchType);
    }

    @GetMapping(value={"/queryUserById"})
    public JSONObject queryUserById(@RequestParam(value="id") String id) {
        return this.sysBaseApi.queryUserById(id);
    }

    @GetMapping(value={"/queryDeptBySuperQuery"})
    public List<JSONObject> queryDeptBySuperQuery(@RequestParam(value="superQuery") String superQuery, @RequestParam(value="matchType") String matchType) {
        return this.sysBaseApi.queryDeptBySuperQuery(superQuery, matchType);
    }

    @GetMapping(value={"/queryRoleBySuperQuery"})
    public List<JSONObject> queryRoleBySuperQuery(@RequestParam(value="superQuery") String superQuery, @RequestParam(value="matchType") String matchType) {
        return this.sysBaseApi.queryRoleBySuperQuery(superQuery, matchType);
    }

    @GetMapping(value={"/selectUserIdByTenantId"})
    public List<String> selectUserIdByTenantId(@RequestParam(value="tenantId") String tenantId) {
        return this.sysBaseApi.selectUserIdByTenantId(tenantId);
    }

    @GetMapping(value={"/queryUserIdsByDeptIds"})
    public List<String> queryUserIdsByDeptIds(@RequestParam(value="deptIds") List<String> deptIds) {
        return this.sysBaseApi.queryUserIdsByDeptIds(deptIds);
    }

    @GetMapping(value={"/queryUserAccountsByDeptIds"})
    public List<String> queryUserAccountsByDeptIds(@RequestParam(value="deptIds") List<String> deptIds) {
        return this.sysBaseApi.queryUserAccountsByDeptIds(deptIds);
    }

    @GetMapping(value={"/queryUserIdsByRoleds"})
    public List<String> queryUserIdsByRoleds(@RequestParam(value="roleCodes") List<String> roleCodes) {
        return this.sysBaseApi.queryUserIdsByRoleds(roleCodes);
    }

    @GetMapping(value={"/queryUserIdsByPositionIds"})
    public List<String> queryUserIdsByPositionIds(@RequestParam(value="positionIds") List<String> positionIds) {
        return this.sysBaseApi.queryUserIdsByPositionIds(positionIds);
    }

    @GetMapping(value={"/getUserAccountsByDepCode"})
    public List<String> getUserAccountsByDepCode(@RequestParam(value="orgCode") String orgCode) {
        return this.sysBaseApi.getUserAccountsByDepCode(orgCode);
    }

    @GetMapping(value={"/dictTableWhiteListCheckBySql"})
    public boolean dictTableWhiteListCheckBySql(@RequestParam(value="selectSql") String selectSql) {
        return this.sysBaseApi.dictTableWhiteListCheckBySql(selectSql);
    }

    @GetMapping(value={"/dictTableWhiteListCheckByDict"})
    public boolean dictTableWhiteListCheckByDict(@RequestParam(value="tableOrDictCode") String tableOrDictCode, String ... fields) {
        return this.sysBaseApi.dictTableWhiteListCheckByDict(tableOrDictCode, fields);
    }
}

