/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.jimureport;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jeecg.common.api.dto.LogDTO;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.drag.service.IOnlDragExternalService;
import org.jeecg.modules.drag.vo.DragDictModel;
import org.jeecg.modules.drag.vo.DragLogDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="onlDragExternalServiceImpl")
public class JimuDragExternalServiceImpl
implements IOnlDragExternalService {
    private static final Logger log = LoggerFactory.getLogger(JimuDragExternalServiceImpl.class);
    @Autowired
    @Lazy
    private BaseCommonService baseCommonService;
    @Autowired
    @Lazy
    private ISysBaseAPI sysBaseApi;

    public Map<String, List<DragDictModel>> getManyDictItems(List<String> codeList, List<JSONObject> tableDictList) {
        HashMap<String, List<DragDictModel>> manyDragDictItems = new HashMap<String, List<DragDictModel>>();
        if (!CollectionUtils.isEmpty(codeList)) {
            Map dictItemsMap = this.sysBaseApi.getManyDictItems(codeList);
            dictItemsMap.forEach((k, v) -> {
                ArrayList dictItems = new ArrayList();
                v.forEach(dictItem -> {
                    DragDictModel dictModel = new DragDictModel();
                    BeanUtils.copyProperties((Object)dictItem, (Object)dictModel);
                    dictItems.add(dictModel);
                });
                manyDragDictItems.put((String)k, dictItems);
            });
        }
        if (!CollectionUtils.isEmpty(tableDictList)) {
            tableDictList.forEach(item -> {
                ArrayList dictItems = new ArrayList();
                JSONObject object = JSONObject.parseObject((String)item.toString());
                String dictField = object.getString("dictField");
                String dictTable = object.getString("dictTable");
                String dictText = object.getString("dictText");
                String fieldName = object.getString("fieldName");
                List dictItemsList = this.sysBaseApi.queryTableDictItemsByCode(dictTable, dictText, dictField);
                dictItemsList.forEach(dictItem -> {
                    DragDictModel dictModel = new DragDictModel();
                    BeanUtils.copyProperties((Object)dictItem, (Object)dictModel);
                    dictItems.add(dictModel);
                });
                manyDragDictItems.put(fieldName, dictItems);
            });
        }
        return manyDragDictItems;
    }

    public List<DragDictModel> getDictItems(String dictCode) {
        ArrayList<DragDictModel> dictItems = new ArrayList<DragDictModel>();
        if (oConvertUtils.isNotEmpty((Object)dictCode)) {
            List dictItemsList = this.sysBaseApi.getDictItems(dictCode);
            dictItemsList.forEach(dictItem -> {
                DragDictModel dictModel = new DragDictModel();
                BeanUtils.copyProperties((Object)dictItem, (Object)dictModel);
                dictItems.add(dictModel);
            });
        }
        return dictItems;
    }

    public void addLog(DragLogDTO dragLogDTO) {
        if (oConvertUtils.isNotEmpty((Object)dragLogDTO)) {
            LogDTO dto = new LogDTO();
            BeanUtils.copyProperties((Object)dragLogDTO, (Object)dto);
            this.baseCommonService.addLog(dto);
        }
    }

    public void addLog(String logMsg, int logType, int operateType) {
        this.baseCommonService.addLog(logMsg, Integer.valueOf(logType), Integer.valueOf(operateType));
    }
}

