/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.firewall.SqlInjection.impl;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.sqlparse.JSqlParserUtils;
import org.jeecg.common.util.sqlparse.vo.SelectSqlInfo;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.firewall.SqlInjection.IDictTableWhiteListHandler;
import org.jeecg.modules.system.entity.SysTableWhiteList;
import org.jeecg.modules.system.service.ISysTableWhiteListService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dictTableWhiteListHandlerImpl")
public class DictTableWhiteListHandlerImpl
implements IDictTableWhiteListHandler {
    private static final Logger log = LoggerFactory.getLogger(DictTableWhiteListHandlerImpl.class);
    private static final Map<String, String> whiteTablesRuleMap = new HashMap<String, String>();
    private static Boolean LOW_CODE_IS_DEV = null;
    @Autowired
    private ISysTableWhiteListService sysTableWhiteListService;
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;

    private void init() {
        if (this.isDev()) {
            whiteTablesRuleMap.clear();
        }
        if (whiteTablesRuleMap.isEmpty()) {
            Map<String, String> ruleMap = this.sysTableWhiteListService.getAllConfigMap();
            log.info("\u8868\u5b57\u5178\u767d\u540d\u5355\u521d\u59cb\u5316\u5b8c\u6210\uff1a{}", ruleMap);
            whiteTablesRuleMap.putAll(ruleMap);
        }
    }

    public boolean isPassBySql(String sql) {
        Map parsedMap = null;
        try {
            parsedMap = JSqlParserUtils.parseAllSelectTable((String)sql);
        }
        catch (Exception e) {
            log.warn("\u6821\u9a8csql\u8bed\u53e5\uff0c\u89e3\u6790\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        if (parsedMap == null) {
            return true;
        }
        log.info("\u83b7\u53d6select sql\u4fe1\u606f \uff1a{} ", (Object)parsedMap);
        for (Map.Entry entry : parsedMap.entrySet()) {
            SelectSqlInfo sqlInfo = (SelectSqlInfo)entry.getValue();
            if (sqlInfo.isSelectAll()) {
                log.warn("\u67e5\u8be2\u8bed\u53e5\u4e2d\u5305\u542b * \u5b57\u6bb5\uff0c\u6682\u65f6\u5148\u901a\u8fc7");
                continue;
            }
            Set queryFields = sqlInfo.getAllRealSelectFields();
            String tableName = (String)entry.getKey();
            if (this.checkWhiteList(tableName, queryFields)) continue;
            return false;
        }
        return true;
    }

    public boolean isPassByDict(String dictCodeString) {
        if (oConvertUtils.isEmpty((Object)dictCodeString)) {
            return true;
        }
        try {
            dictCodeString = URLDecoder.decode(dictCodeString, "UTF-8");
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        dictCodeString = dictCodeString.trim();
        String[] arr = dictCodeString.split(",");
        String tableName = this.getTableName(arr[0]);
        arr = Arrays.copyOfRange(arr, 1, arr.length);
        String[] fields = (String[])Arrays.stream(arr).map(String::trim).distinct().toArray(String[]::new);
        return this.isPassByDict(tableName, fields);
    }

    public boolean isPassByDict(String tableName, String ... fields) {
        if (oConvertUtils.isEmpty((Object)tableName)) {
            return true;
        }
        if (fields == null || fields.length == 0) {
            fields = new String[]{"*"};
        }
        String sql = "select " + String.join((CharSequence)",", fields) + " from " + tableName;
        log.info("\u5b57\u5178\u62fc\u63a5\u7684\u67e5\u8be2SQL\uff1a{}", (Object)sql);
        try {
            JSqlParserUtils.parseSelectSqlInfo((String)sql);
        }
        catch (Exception e) {
            return this.checkWhiteList(tableName, new HashSet<String>(Arrays.asList(fields)));
        }
        return this.isPassBySql(sql);
    }

    public boolean checkWhiteList(String tableName, Set<String> queryFields) {
        this.init();
        if (oConvertUtils.isEmpty((Object)tableName)) {
            log.error("\u767d\u540d\u5355\u6821\u9a8c\uff1a\u8868\u540d\u4e3a\u7a7a");
            this.throwException();
        }
        tableName = tableName.toLowerCase();
        String allowFieldStr = whiteTablesRuleMap.get(tableName);
        log.info("checkWhiteList tableName: {}", (Object)tableName);
        if (oConvertUtils.isEmpty((Object)allowFieldStr)) {
            if (this.isDev()) {
                this.autoAddWhiteList(tableName, String.join((CharSequence)",", queryFields));
                allowFieldStr = whiteTablesRuleMap.get(tableName);
            } else {
                log.error("\u767d\u540d\u5355\u6821\u9a8c\uff1a\u8868\"{}\"\u672a\u901a\u8fc7\u6821\u9a8c", (Object)tableName);
                this.throwException();
            }
        }
        allowFieldStr = allowFieldStr.toLowerCase();
        HashSet<String> allowFields = new HashSet<String>(Arrays.asList(allowFieldStr.split(",")));
        HashSet<String> waitMergerFields = new HashSet<String>();
        for (String field : queryFields) {
            if (oConvertUtils.isEmpty((Object)field) || allowFields.contains(field = field.toLowerCase())) continue;
            if (this.isDev()) {
                waitMergerFields.add(field);
                continue;
            }
            log.error("\u767d\u540d\u5355\u6821\u9a8c\uff1a\u5b57\u6bb5 {} \u4e0d\u5728 {} \u8303\u56f4\u5185\uff0c\u62d2\u7edd\u8bbf\u95ee\uff01", (Object)field, allowFields);
            this.throwException();
        }
        if (!waitMergerFields.isEmpty()) {
            this.autoAddWhiteList(tableName, String.join((CharSequence)",", waitMergerFields));
        }
        log.info("\u767d\u540d\u5355\u6821\u9a8c\uff1a\u67e5\u8be2\u8868\"{}\"\uff0c\u67e5\u8be2\u5b57\u6bb5 {} \u901a\u8fc7\u6821\u9a8c", (Object)tableName, queryFields);
        return true;
    }

    private void autoAddWhiteList(String tableName, String allowFieldStr) {
        try {
            SysTableWhiteList entity = this.sysTableWhiteListService.autoAdd(tableName, allowFieldStr);
            whiteTablesRuleMap.put(tableName, entity.getFieldName());
            log.warn("\u8868\"{}\"\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u4e14\u5f53\u524d\u4e3a dev \u6a21\u5f0f\uff0c\u5df2\u81ea\u52a8\u5411\u6570\u636e\u5e93\u4e2d\u589e\u52a0\u767d\u540d\u5355\u6570\u636e\u3002\u67e5\u8be2\u5b57\u6bb5\uff1a{}", (Object)tableName, (Object)allowFieldStr);
        }
        catch (Exception e) {
            log.error("\u8868\"{}\"\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u4e14\u5f53\u524d\u4e3a dev \u6a21\u5f0f\uff0c\u4f46\u81ea\u52a8\u5411\u6570\u636e\u5e93\u4e2d\u589e\u52a0\u767d\u540d\u5355\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u6392\u67e5\u540e\u91cd\u8bd5\u3002\u9519\u8bef\u539f\u56e0\uff1a{}", new Object[]{tableName, e.getMessage(), e});
            this.throwException();
        }
    }

    private boolean isDev() {
        if (LOW_CODE_IS_DEV == null) {
            if (this.jeecgBaseConfig.getFirewall() != null) {
                String lowCodeMode = this.jeecgBaseConfig.getFirewall().getLowCodeMode();
                LOW_CODE_IS_DEV = "dev".equals(lowCodeMode);
            } else {
                LOW_CODE_IS_DEV = false;
            }
        }
        return LOW_CODE_IS_DEV;
    }

    public boolean clear() {
        whiteTablesRuleMap.clear();
        return true;
    }

    private String getTableName(String str) {
        String[] arr = str.split("\\s+(?i)where\\s+");
        String tableName = arr[0].trim();
        if (tableName.contains(".")) {
            tableName = tableName.substring(tableName.indexOf(".") + 1, tableName.length()).trim();
        }
        if (tableName.contains(" ")) {
            tableName = tableName.substring(0, tableName.indexOf(" ")).trim();
        }
        String reg = "\\s+|\\(|\\)|`";
        return tableName.replaceAll(reg, "");
    }

    private void throwException() throws JeecgSqlInjectionException {
        this.throwException(this.getErrorMsg());
    }

    private void throwException(String message) throws JeecgSqlInjectionException {
        if (oConvertUtils.isEmpty((Object)message)) {
            message = this.getErrorMsg();
        }
        log.error(message);
        throw new JeecgSqlInjectionException(message);
    }

    public String getErrorMsg() {
        return "\u767d\u540d\u5355\u6821\u9a8c\u672a\u901a\u8fc7\uff01";
    }
}

