/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

@SpringBootApplication
public class JeecgSystemApplication
extends SpringBootServletInitializer {
    private static final Logger log = LoggerFactory.getLogger(JeecgSystemApplication.class);

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{JeecgSystemApplication.class});
    }

    public static void main(String[] args) throws UnknownHostException {
        SpringApplication app = new SpringApplication(new Class[]{JeecgSystemApplication.class});
        HashMap<String, Boolean> defaultProperties = new HashMap<String, Boolean>();
        defaultProperties.put("management.health.elasticsearch.enabled", false);
        app.setDefaultProperties(defaultProperties);
        log.info("[JEECG] Elasticsearch Health Check Enabled: false");
        ConfigurableApplicationContext application = app.run(args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = oConvertUtils.getString((String)env.getProperty("server.servlet.context-path"));
        log.info("\n----------------------------------------------------------\n\tApplication Jeecg-Boot is running! Access URLs:\n\tLocal: \t\thttp://localhost:" + port + path + "/\n\tExternal: \thttp://" + ip + ":" + port + path + "/\n\tSwagger\u6587\u6863: \thttp://" + ip + ":" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

