/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.init;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import org.jeecg.modules.jmreport.common.a.a;
import org.jeecg.modules.jmreport.common.expetion.JimuAlertException;
import org.jeecg.modules.jmreport.common.interceptor.JimuReportSignatureInterceptor;
import org.jeecg.modules.jmreport.common.util.JimuI18nUtils;
import org.jeecg.modules.jmreport.config.firewall.interceptor.JimuReportTokenInterceptor;
import org.jeecg.modules.jmreport.config.firewall.interceptor.handlers.JmIPermissionsVerifyHandler;
import org.jeecg.modules.jmreport.config.locale.JimuLocaleInterceptor;
import org.jeecg.modules.jmreport.config.locale.JimuLocaleResolver;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.jeecg.modules.jmreport.desreport.service.IJmreportNoSqlService;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="jimuReportConfiguration")
@PropertySource(value={"classpath:config/default-config.properties"})
@ComponentScan(basePackages={"org.jeecg.modules.jmreport", "org.jeecg.modules.drag"})
public class JimuReportConfiguration
implements InitializingBean,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(JimuReportConfiguration.class);
    @Autowired
    private JmReportUploadConfig jmReportUploadConfig;

    @Bean(value={"jmPermissionsVerifyHandler"})
    JmIPermissionsVerifyHandler jmPermissionsVerifyHandler() {
        return new JmIPermissionsVerifyHandler();
    }

    @Bean
    public JimuReportTokenInterceptor jimuReportInterceptor() {
        return new JimuReportTokenInterceptor();
    }

    @Bean
    public JimuReportSignatureInterceptor jmSignatureInterceptor() {
        return new JimuReportSignatureInterceptor();
    }

    @Bean
    public Filter jmFilter() {
        return new a();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        String[] stringArray = new String[]{"/*.js", "/*.css", "/*.svg", "/*.pdf", "/*.jpg", "/*.png", "/*.ico", "/*.html", "/html/**", "/js/**", "/css/**", "/images/**"};
        registry.addInterceptor((HandlerInterceptor)this.jimuReportInterceptor()).excludePathPatterns(stringArray).addPathPatterns(new String[]{"/jmreport/**", "/drag/**"});
        registry.addInterceptor((HandlerInterceptor)this.jmSignatureInterceptor()).addPathPatterns(new String[]{"/jmreport/queryFieldBySql", "/jmreport/loadTableData", "/jmreport/dictCodeSearch", "/jmreport/testConnection"});
        registry.addInterceptor((HandlerInterceptor)this.jimuLocaleInterceptor());
    }

    @Bean
    public FilterRegistrationBean jmFilterRegistration() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(this.jmFilter());
        filterRegistrationBean.setName("jmFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/jmreport/queryFieldBySql", "/jmreport/loadTableData", "/jmreport/show", "/jmreport/exportPdfStream", "/jmreport/exportAllExcelStream", "/jmreport/qurestSql", "/jmreport/map/queryMapByCode", "/jmreport/qurestApi", "/jmreport/getCharData", "/jmreport/testConnection", "/jmreport/save", "/jmreport/form/submit"});
        return filterRegistrationBean;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/jmreport/desreport_/**"}).addResourceLocations(new String[]{"classpath:/static/jmreport/desreport_/"});
        registry.addResourceHandler(new String[]{"/jmreport/img/**"}).addResourceLocations(new String[]{"file:" + this.jmReportUploadConfig.getPath().getUpload() + "//"});
    }

    @Bean(name={"jmTaskScheduler"})
    protected TaskScheduler jmTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(8);
        threadPoolTaskScheduler.setThreadNamePrefix("scheduled-thread-jm-");
        return threadPoolTaskScheduler;
    }

    @Bean(name={"jmreportNoSqlServiceImpl"})
    @ConditionalOnMissingBean(value={IJmreportNoSqlService.class})
    public IJmreportNoSqlService defaultJmreportNoSqlService() {
        return new IJmreportNoSqlService(){

            @Override
            public List<Map<String, Object>> findList(String sql, String dbKey) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }

            @Override
            public Boolean testConnection(JmreportDynamicDataSourceVo dbSource) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }

            @Override
            public List<Map<String, Object>> findListByCalcite(String dbKey, String sql, Map<String, Object> param) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }

            @Override
            public Object findOneByCalcite(String dbKey, String sql, Map<String, Object> param) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }
        };
    }

    @Bean(name={"jmMessageSource"})
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSource();
        reloadableResourceBundleMessageSource.setBasenames(new String[]{"file:" + this.getLocalExternalConfigPath(), "classpath:i18n/messages"});
        reloadableResourceBundleMessageSource.setDefaultEncoding("UTF-8");
        reloadableResourceBundleMessageSource.setCacheSeconds(3600);
        reloadableResourceBundleMessageSource.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return reloadableResourceBundleMessageSource;
    }

    private String getLocalExternalConfigPath() {
        String string = this.getClass().getResource("").toString();
        Path path = string.startsWith("jar:") ? Paths.get(System.getProperty("user.dir"), "config/i18n/messages") : Paths.get("config/i18n/messages", new String[0]).toAbsolutePath();
        return path.toString().replace("\\", "/");
    }

    @Bean(name={"jimuI18nUtils"})
    public JimuI18nUtils jimuI18nUtils(@Qualifier(value="jmMessageSource") MessageSource jmMessageSource) {
        return new JimuI18nUtils(jmMessageSource);
    }

    @Bean(name={"jimuLocaleInterceptor"})
    public JimuLocaleInterceptor jimuLocaleInterceptor() {
        return new JimuLocaleInterceptor(new JimuLocaleResolver());
    }
}

