/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class JimuI18nUtils {
    private static final Log logger = LogFactory.getLog(JimuI18nUtils.class);
    private final MessageSource messageSource;

    public JimuI18nUtils(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String get(String msgKey) {
        String string;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            string = this.messageSource.getMessage(msgKey, null, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            logger.warn((Object)noSuchMessageException.getMessage());
            string = msgKey;
        }
        return string;
    }

    public String getAndReplace(String msgKey, Object ... args) {
        String string;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            string = this.messageSource.getMessage(msgKey, args, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            logger.warn((Object)noSuchMessageException.getMessage());
            string = msgKey;
        }
        return string;
    }
}

