/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.handler.impl;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import org.jeewx.api.core.annotation.ReqType;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.handler.WeiXinReqHandler;
import org.jeewx.api.core.req.model.WeixinReqConfig;
import org.jeewx.api.core.req.model.WeixinReqParam;
import org.jeewx.api.core.req.model.message.IndustryTemplateMessageSend;
import org.jeewx.api.core.req.model.message.TemplateMessage;
import org.jeewx.api.core.util.HttpRequestProxy;
import org.jeewx.api.core.util.WeiXinReqUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinReqTemplateMessageHandler
implements WeiXinReqHandler {
    private static Logger logger = LoggerFactory.getLogger(WeixinReqTemplateMessageHandler.class);

    @Override
    public String doRequest(WeixinReqParam weixinReqParam) throws WexinReqException {
        String strReturnInfo = "";
        if (weixinReqParam.getClass().isAnnotationPresent(ReqType.class)) {
            ReqType reqType = weixinReqParam.getClass().getAnnotation(ReqType.class);
            WeixinReqConfig objConfig = WeiXinReqUtil.getWeixinReqConfig(reqType.value());
            if (objConfig != null) {
                String reqUrl = objConfig.getUrl();
                IndustryTemplateMessageSend mc = (IndustryTemplateMessageSend)weixinReqParam;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("access_token", mc.getAccess_token());
                String jsonData = this.getMsgJson(mc);
                logger.info("\u5904\u7406\u6a21\u677f\u6d88\u606f" + jsonData);
                strReturnInfo = HttpRequestProxy.doJsonPost(reqUrl, parameters, jsonData);
            }
        } else {
            logger.info("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        return strReturnInfo;
    }

    private String getMsgJson(IndustryTemplateMessageSend mc) {
        StringBuffer json = new StringBuffer();
        TemplateMessage tm = mc.getData();
        mc.setData(null);
        String objJson = JSON.toJSONString((Object)mc);
        mc.setData(tm);
        json.append(objJson);
        json.setLength(json.length() - 1);
        json.append(",");
        json.append("\"data\":{");
        objJson = JSON.toJSONString((Object)tm.getFirst());
        json.append(" \"first\":");
        json.append(objJson);
        json.append(",");
        objJson = JSON.toJSONString((Object)tm.getKeynote1());
        json.append(" \"keynote1\":");
        json.append(objJson);
        json.append(",");
        objJson = JSON.toJSONString((Object)tm.getKeynote2());
        json.append(" \"keynote2\":");
        json.append(objJson);
        json.append(",");
        objJson = JSON.toJSONString((Object)tm.getKeynote3());
        json.append(" \"keynote3\":");
        json.append(objJson);
        json.append(",");
        objJson = JSON.toJSONString((Object)tm.getRemark());
        json.append(" \"remark\":");
        json.append(objJson);
        json.append("}}");
        return json.toString();
    }
}

