/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.sign.interceptor;

import javax.annotation.Resource;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.util.PathMatcherUtil;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.filter.RequestBodyReserveFilter;
import org.jeecg.config.sign.interceptor.SignAuthInterceptor;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SignAuthConfiguration
implements WebMvcConfigurer {
    @Resource
    JeecgBaseConfig jeecgBaseConfig;

    @Bean
    public SignAuthInterceptor signAuthInterceptor() {
        return new SignAuthInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        String signUrls = this.jeecgBaseConfig.getSignUrls();
        String[] signUrlsArray = null;
        signUrlsArray = StringUtils.isNotBlank((CharSequence)signUrls) ? signUrls.split(",") : PathMatcherUtil.SIGN_URL_LIST;
        registry.addInterceptor((HandlerInterceptor)this.signAuthInterceptor()).addPathPatterns(signUrlsArray);
    }

    @Bean
    public RequestBodyReserveFilter requestBodyReserveFilter() {
        return new RequestBodyReserveFilter();
    }

    @Bean
    public FilterRegistrationBean reqBodyFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.requestBodyReserveFilter());
        registration.setName("requestBodyReserveFilter");
        String signUrls = this.jeecgBaseConfig.getSignUrls();
        String[] signUrlsArray = null;
        signUrlsArray = StringUtils.isNotBlank((CharSequence)signUrls) ? signUrls.split(",") : PathMatcherUtil.SIGN_URL_LIST;
        registration.addUrlPatterns(signUrlsArray);
        return registration;
    }
}

