/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.shiro.filters;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.shiro.JwtToken;
import org.jeecg.config.shiro.ignore.InMemoryIgnoreAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtFilter.class);
    private boolean allowOrigin = true;

    public JwtFilter() {
    }

    public JwtFilter(boolean allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        try {
            if (InMemoryIgnoreAuth.contains(((HttpServletRequest)request).getServletPath())) {
                return true;
            }
            this.executeLogin(request, response);
            return true;
        }
        catch (Exception e) {
            JwtUtil.responseError(response, 401, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!");
            return false;
        }
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader("X-Access-Token");
        if (oConvertUtils.isEmpty(token)) {
            token = httpServletRequest.getParameter("token");
        }
        JwtToken jwtToken = new JwtToken(token);
        this.getSubject(request, response).login((AuthenticationToken)jwtToken);
        return true;
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.allowOrigin) {
            httpServletResponse.setHeader("Access-Control-Allow-Origin", httpServletRequest.getHeader("Origin"));
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
            String requestHeaders = httpServletRequest.getHeader("Access-Control-Request-Headers");
            if (StringUtils.isNotEmpty((String)requestHeaders)) {
                httpServletResponse.setHeader("Access-Control-Allow-Headers", requestHeaders);
            }
            httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
        }
        if (RequestMethod.OPTIONS.name().equalsIgnoreCase(httpServletRequest.getMethod())) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            return false;
        }
        String tenantId = httpServletRequest.getHeader("X-Tenant-Id");
        TenantContext.setTenant((String)tenantId);
        return super.preHandle(request, response);
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
        TenantContext.clear();
    }
}

