/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.shiro;

import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.config.shiro.JwtToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ShiroRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(ShiroRealm.class);
    @Lazy
    @Resource
    private CommonAPI commonApi;
    @Lazy
    @Resource
    private RedisUtil redisUtil;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JwtToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        log.debug("===============Shiro\u6743\u9650\u8ba4\u8bc1\u5f00\u59cb============ [ roles\u3001permissions]==========");
        String username = null;
        String userId = null;
        if (principals != null) {
            LoginUser sysUser = (LoginUser)principals.getPrimaryPrincipal();
            username = sysUser.getUsername();
            userId = sysUser.getId();
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Set<String> roleSet = this.commonApi.queryUserRolesById(userId);
        info.setRoles(roleSet);
        Set<String> permissionSet = this.commonApi.queryUserAuths(userId);
        info.addStringPermissions(permissionSet);
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u6210\u529f==============");
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken auth) throws AuthenticationException {
        log.debug("===============Shiro\u8eab\u4efd\u8ba4\u8bc1\u5f00\u59cb============doGetAuthenticationInfo==========");
        String token = (String)auth.getCredentials();
        if (token == null) {
            HttpServletRequest req = SpringContextUtils.getHttpServletRequest();
            log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014IP\u5730\u5740:  " + oConvertUtils.getIpAddrByRequest(req) + "\uff0cURL:" + req.getRequestURI());
            throw new AuthenticationException("token\u4e3a\u7a7a!");
        }
        LoginUser loginUser = null;
        try {
            loginUser = this.checkUserTokenIsEffect(token);
        }
        catch (AuthenticationException e) {
            JwtUtil.responseError((ServletResponse)SpringContextUtils.getHttpServletResponse(), 401, e.getMessage());
            e.printStackTrace();
            return null;
        }
        return new SimpleAuthenticationInfo((Object)loginUser, (Object)token, this.getName());
    }

    public LoginUser checkUserTokenIsEffect(String token) throws AuthenticationException {
        String username = JwtUtil.getUsername(token);
        if (username == null) {
            throw new AuthenticationException("token\u975e\u6cd5\u65e0\u6548!");
        }
        log.debug("\u2014\u2014\u2014\u6821\u9a8ctoken\u662f\u5426\u6709\u6548\u2014\u2014\u2014\u2014checkUserTokenIsEffect\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
        LoginUser loginUser = TokenUtils.getLoginUser(username, this.commonApi, this.redisUtil);
        if (loginUser == null) {
            throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        if (loginUser.getStatus() != 1) {
            throw new AuthenticationException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (!this.jwtTokenRefresh(token, username, loginUser.getPassword())) {
            throw new AuthenticationException("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!");
        }
        String userTenantIds = loginUser.getRelTenantIds();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && oConvertUtils.isNotEmpty(userTenantIds)) {
            String[] arr;
            String contextTenantId = TenantContext.getTenant();
            log.debug("\u767b\u5f55\u79df\u6237\uff1a" + contextTenantId);
            log.debug("\u7528\u6237\u62e5\u6709\u90a3\u4e9b\u79df\u6237\uff1a" + userTenantIds);
            String str = "0";
            if (oConvertUtils.isNotEmpty(contextTenantId) && !str.equals(contextTenantId) && !oConvertUtils.isIn(contextTenantId, arr = userTenantIds.split(","))) {
                String[] newArray;
                boolean isAuthorization = false;
                String loginUserKey = "sys:cache:encrypt:user::" + username;
                this.redisUtil.del(new String[]{loginUserKey});
                LoginUser loginUserFromDb = this.commonApi.getUserByName(username);
                if (oConvertUtils.isNotEmpty(loginUserFromDb.getRelTenantIds()) && oConvertUtils.isIn(contextTenantId, newArray = loginUserFromDb.getRelTenantIds().split(","))) {
                    isAuthorization = true;
                }
                if (!isAuthorization) {
                    log.info("\u79df\u6237\u5f02\u5e38\u2014\u2014\u767b\u5f55\u79df\u6237\uff1a" + contextTenantId);
                    log.info("\u79df\u6237\u5f02\u5e38\u2014\u2014\u7528\u6237\u62e5\u6709\u79df\u6237\u7ec4\uff1a" + userTenantIds);
                    throw new AuthenticationException("\u767b\u5f55\u79df\u6237\u6388\u6743\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u767b\u9646!");
                }
            }
        }
        return loginUser;
    }

    public boolean jwtTokenRefresh(String token, String userName, String passWord) {
        String cacheToken = String.valueOf(this.redisUtil.get("prefix_user_token:" + token));
        if (oConvertUtils.isNotEmpty(cacheToken)) {
            if (!JwtUtil.verify(cacheToken, userName, passWord)) {
                String newAuthorization = JwtUtil.sign(userName, passWord);
                this.redisUtil.set("prefix_user_token:" + token, (Object)newAuthorization);
                this.redisUtil.expire("prefix_user_token:" + token, 604800L);
                log.debug("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u7528\u6237\u5728\u7ebf\u64cd\u4f5c\uff0c\u66f4\u65b0token\u4fdd\u8bc1\u4e0d\u6389\u7ebf\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014jwtTokenRefresh\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            }
            return true;
        }
        return false;
    }

    public void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
        super.clearCachedAuthorizationInfo(principals);
    }
}

