/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.ThreadLocalDataHelper;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"org.jeecg.**.mapper*"})
public class MybatisPlusSaasConfig {
    public static final Boolean OPEN_SYSTEM_TENANT_CONTROL = false;
    public static final List<String> TENANT_TABLE = new ArrayList<String>();

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                String tenantId = TenantContext.getTenant();
                if (oConvertUtils.isEmpty(tenantId)) {
                    try {
                        tenantId = TokenUtils.getTenantIdByRequest(SpringContextUtils.getHttpServletRequest());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oConvertUtils.isEmpty(tenantId)) {
                    tenantId = "0";
                }
                return new LongValue(tenantId);
            }

            public String getTenantIdColumn() {
                return "tenant_id";
            }

            public boolean ignoreTable(String tableName) {
                for (String temp : TENANT_TABLE) {
                    if (!temp.equalsIgnoreCase(tableName)) continue;
                    return false;
                }
                return true;
            }
        }));
        interceptor.addInnerInterceptor((InnerInterceptor)this.dynamicTableNameInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        return interceptor;
    }

    private DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor() {
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicTableNameInnerInterceptor.setTableNameHandler((sql, tableName) -> {
            Object version;
            String dynamicTableName = (String)ThreadLocalDataHelper.get("DYNAMIC_TABLE_NAME");
            if (ObjectUtil.isNotEmpty((Object)dynamicTableName) && dynamicTableName.equals(tableName) && ObjectUtil.isNotEmpty(version = ThreadLocalDataHelper.get("X-Version"))) {
                return tableName + "_" + version;
            }
            return tableName;
        });
        return dynamicTableNameInnerInterceptor;
    }

    static {
        if (OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            TENANT_TABLE.add("sys_depart");
            TENANT_TABLE.add("sys_category");
            TENANT_TABLE.add("sys_data_source");
            TENANT_TABLE.add("sys_position");
        }
    }
}

