/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class LowCodeModeInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LowCodeModeInterceptor.class);
    public static final String LOW_CODE_MODE_DEV = "dev";
    public static final String LOW_CODE_MODE_PROD = "prod";
    @Resource
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private CommonAPI commonAPI;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if (this.jeecgBaseConfig.getFirewall() != null && LOW_CODE_MODE_PROD.equals(this.jeecgBaseConfig.getFirewall().getLowCodeMode())) {
            String requestURI = request.getRequestURI().substring(request.getContextPath().length());
            log.info("\u4f4e\u4ee3\u7801\u6a21\u5f0f\uff0c\u62e6\u622a\u8bf7\u6c42\u8def\u5f84\uff1a" + requestURI);
            LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            Set<String> hasRoles = null;
            if (loginUser == null) {
                loginUser = this.commonAPI.getUserByName(JwtUtil.getUserNameByToken(SpringContextUtils.getHttpServletRequest()));
                hasRoles = this.commonAPI.queryUserRolesById(loginUser.getId());
            }
            log.info("get loginUser info: {}", (Object)loginUser);
            log.info("get loginRoles info: {}", (Object)(hasRoles != null ? hasRoles.toArray() : "\u7a7a"));
            boolean hasIntersection = CommonUtils.hasIntersection(hasRoles, CommonConstant.allowDevRoles);
            if (loginUser != null && ("admin".equals(loginUser.getUsername()) || hasIntersection)) {
                return true;
            }
            this.returnErrorMessage(response);
            return false;
        }
        return true;
    }

    private void returnErrorMessage(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            Result result = Result.error("\u4f4e\u4ee3\u7801\u5f00\u53d1\u6a21\u5f0f\u4e3a\u53d1\u5e03\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u5728\u7ebf\u914d\u7f6e\uff01\uff01");
            out.print(JSON.toJSON(result));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

