/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.sqlInjection;

import net.sf.jsqlparser.parser.CCJSqlParserVisitor;
import net.sf.jsqlparser.statement.StatementVisitor;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.util.sqlInjection.InjectionAstNodeVisitor;
import org.jeecg.common.util.sqlInjection.InjectionSyntaxObjectAnalyzer;
import org.jeecg.common.util.sqlInjection.parse.ParserSupport;

public class SqlInjectionAnalyzer {
    private boolean injectCheckEnable = true;
    private final InjectionSyntaxObjectAnalyzer injectionChecker = new InjectionSyntaxObjectAnalyzer();
    private final InjectionAstNodeVisitor injectionVisitor = new InjectionAstNodeVisitor();

    public SqlInjectionAnalyzer injectCheckEnable(boolean enable) {
        this.injectCheckEnable = enable;
        return this;
    }

    public ParserSupport.SqlParserInfo injectAnalyse(ParserSupport.SqlParserInfo sqlParserInfo) throws JeecgSqlInjectionException {
        if (null != sqlParserInfo && this.injectCheckEnable) {
            sqlParserInfo.statement.accept((StatementVisitor)this.injectionChecker);
            sqlParserInfo.simpleNode.jjtAccept((CCJSqlParserVisitor)this.injectionVisitor, null);
        }
        return sqlParserInfo;
    }

    public static void checkSql(String sql, boolean check) {
        SqlInjectionAnalyzer sqlInjectionAnalyzer = new SqlInjectionAnalyzer();
        sqlInjectionAnalyzer.injectCheckEnable(check);
        ParserSupport.SqlParserInfo sqlParserInfo = ParserSupport.parse0(sql, null, null);
        sqlInjectionAnalyzer.injectAnalyse(sqlParserInfo);
    }
}

