/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.sqlInjection;

import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.util.sqlInjection.parse.ConstAnalyzer;
import org.jeecg.common.util.sqlInjection.parse.ParserSupport;

public class InjectionSyntaxObjectAnalyzer
extends TablesNamesFinder {
    private static final String DANGROUS_FUNCTIONS = "(sleep|benchmark|extractvalue|updatexml|ST_LatFromGeoHash|ST_LongFromGeoHash|GTID_SUBSET|GTID_SUBTRACT|floor|ST_Pointfromgeohash|geometrycollection|multipoint|polygon|multipolygon|linestring|multilinestring)";
    private static ThreadLocal<Boolean> disableSubselect = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private ConstAnalyzer constAnalyzer = new ConstAnalyzer();

    public InjectionSyntaxObjectAnalyzer() {
        this.init(true);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        if (binaryExpression instanceof ComparisonOperator && this.isConst(binaryExpression.getLeftExpression()) && this.isConst(binaryExpression.getRightExpression())) {
            throw new JeecgSqlInjectionException("DISABLE IDENTICAL EQUATION " + binaryExpression);
        }
        super.visitBinaryExpression(binaryExpression);
    }

    public void visit(AndExpression andExpression) {
        super.visit(andExpression);
        this.checkConstExpress(andExpression.getLeftExpression());
        this.checkConstExpress(andExpression.getRightExpression());
    }

    public void visit(OrExpression orExpression) {
        super.visit(orExpression);
        this.checkConstExpress(orExpression.getLeftExpression());
        this.checkConstExpress(orExpression.getRightExpression());
    }

    public void visit(Function function) {
        if (function.getName().matches(DANGROUS_FUNCTIONS)) {
            throw new JeecgSqlInjectionException("DANGROUS FUNCTION: " + function.getName());
        }
        super.visit(function);
    }

    public void visit(WithItem withItem) {
        try {
            disableSubselect.set(false);
            super.visit(withItem);
        }
        finally {
            disableSubselect.set(true);
        }
    }

    public void visit(SubSelect subSelect) {
        try {
            disableSubselect.set(false);
            super.visit(subSelect);
        }
        finally {
            disableSubselect.set(true);
        }
    }

    public void visit(Column tableColumn) {
        if (ParserSupport.isBoolean(tableColumn)) {
            throw new JeecgSqlInjectionException("DISABLE CONST BOOL " + tableColumn);
        }
        super.visit(tableColumn);
    }

    public void visit(PlainSelect plainSelect) {
        if (plainSelect.getSelectItems() != null) {
            for (SelectItem item : plainSelect.getSelectItems()) {
                item.accept((SelectItemVisitor)this);
            }
        }
        if (plainSelect.getFromItem() != null) {
            plainSelect.getFromItem().accept((FromItemVisitor)this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
                for (Expression e : join.getOnExpressions()) {
                    e.accept((ExpressionVisitor)this);
                }
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept((ExpressionVisitor)this);
            this.checkConstExpress(plainSelect.getWhere());
        }
        if (plainSelect.getHaving() != null) {
            plainSelect.getHaving().accept((ExpressionVisitor)this);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept((ExpressionVisitor)this);
        }
        if (plainSelect.getOrderByElements() != null) {
            for (OrderByElement orderByElement : plainSelect.getOrderByElements()) {
                orderByElement.getExpression().accept((ExpressionVisitor)this);
            }
        }
        if (plainSelect.getGroupBy() != null) {
            for (Expression expression : plainSelect.getGroupBy().getGroupByExpressionList().getExpressions()) {
                expression.accept((ExpressionVisitor)this);
            }
        }
    }

    private boolean isConst(Expression expression) {
        return this.constAnalyzer.isConstExpression(expression);
    }

    private void checkConstExpress(Expression expression) {
        if (this.constAnalyzer.isConstExpression(expression)) {
            throw new JeecgSqlInjectionException("DISABLE CONST EXPRESSION " + expression);
        }
    }
}

