/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryBlackListHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryBlackListHandler.class);
    public static Map<String, String> ruleMap = new HashMap<String, String>();
    public static final Pattern ILLEGAL_NAME_REG = Pattern.compile("[-]{2,}");

    protected abstract List<QueryTable> getQueryTableInfo(String var1);

    public boolean isPass(String sql) {
        List<QueryTable> list = null;
        try {
            list = this.getQueryTableInfo(sql.toLowerCase());
        }
        catch (Exception e) {
            log.warn("\u6821\u9a8csql\u8bed\u53e5\uff0c\u89e3\u6790\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
        if (list == null) {
            return true;
        }
        log.info("  \u83b7\u53d6sql\u4fe1\u606f \uff1a{} ", (Object)list.toString());
        boolean flag = this.checkTableAndFieldsName(list);
        if (!flag) {
            return false;
        }
        for (QueryTable table : list) {
            String name = table.getName();
            String fieldRule = ruleMap.get(name);
            if (fieldRule == null) continue;
            if ("*".equals(fieldRule) || table.isAll()) {
                flag = false;
                log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + name + "\u3011\u7981\u6b62\u67e5\u8be2");
                break;
            }
            if (!table.existSameField(fieldRule)) continue;
            flag = false;
            break;
        }
        if (!flag) {
            log.error(this.getError());
            throw new JeecgSqlInjectionException(this.getError());
        }
        return flag;
    }

    private boolean checkTableAndFieldsName(List<QueryTable> list) {
        boolean flag = true;
        block0: for (QueryTable queryTable : list) {
            String tableName = queryTable.getName();
            if (this.hasSpecialString(tableName)) {
                flag = false;
                log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u540d\u3010" + tableName + "\u3011\u5305\u542b\u7279\u6b8a\u5b57\u7b26");
                break;
            }
            Set<String> fields = queryTable.getFields();
            for (String name : fields) {
                if (!this.hasSpecialString(name)) continue;
                flag = false;
                log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u5b57\u6bb5\u540d\u3010" + name + "\u3011\u5305\u542b\u7279\u6b8a\u5b57\u7b26");
                continue block0;
            }
        }
        return flag;
    }

    private boolean hasSpecialString(String name) {
        Matcher m = ILLEGAL_NAME_REG.matcher(name);
        return m.find();
    }

    public String getError() {
        return "\u7cfb\u7edf\u8bbe\u7f6e\u4e86\u5b89\u5168\u89c4\u5219\uff0c\u654f\u611f\u8868\u548c\u654f\u611f\u5b57\u6bb5\u7981\u6b62\u67e5\u8be2\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743!";
    }

    static {
        ruleMap.put("sys_user", "password,salt");
    }

    protected class QueryTable {
        private String name;
        private String alias;
        private Set<String> fields;
        private boolean all;

        public QueryTable() {
        }

        public QueryTable(String name, String alias) {
            this.name = name;
            this.alias = alias;
            this.all = false;
            this.fields = new HashSet<String>();
        }

        public void addField(String field) {
            this.fields.add(field);
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getFields() {
            return new HashSet<String>(this.fields);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setFields(Set<String> fields) {
            this.fields = fields;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean isAll() {
            return this.all;
        }

        public void setAll(boolean all) {
            this.all = all;
        }

        public boolean existSameField(String fieldString) {
            String[] controlFields = fieldString.split(",");
            for (String sqlField : this.fields) {
                for (String controlField : controlFields) {
                    if (sqlField.equals(controlField)) {
                        log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + this.name + "\u3011\u4e2d\u5b57\u6bb5\u3010" + controlField + "\u3011\u7981\u6b62\u67e5\u8be2");
                        return true;
                    }
                    String aliasColumn = controlField;
                    if (StringUtils.isNotBlank((String)this.alias)) {
                        aliasColumn = this.alias + "." + controlField;
                    }
                    if (sqlField.indexOf(aliasColumn) == -1) continue;
                    log.warn("sql\u9ed1\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + this.name + "\u3011\u4e2d\u5b57\u6bb5\u3010" + controlField + "\u3011\u7981\u6b62\u67e5\u8be2");
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "QueryTable{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", fields=" + this.fields + ", all=" + this.all + '}';
        }
    }
}

