/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class SsrfFileTypeFilter {
    private static final Logger log = LoggerFactory.getLogger(SsrfFileTypeFilter.class);
    private static final List<String> FILE_TYPE_WHITE_LIST = new ArrayList<String>();
    static final HashMap<String, String> FILE_TYPE_MAP = new HashMap();

    private static String getFileTypeBySuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
    }

    public static void checkDownloadFileType(String filePath) throws IOException {
        String suffix = SsrfFileTypeFilter.getFileTypeBySuffix(filePath);
        log.info("suffix:{}", (Object)suffix);
        boolean isAllowExtension = FILE_TYPE_WHITE_LIST.contains(suffix.toLowerCase());
        if (!isAllowExtension) {
            throw new IOException("\u4e0b\u8f7d\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u6587\u4ef6\u7c7b\u578b\uff1a" + suffix);
        }
    }

    public static void checkUploadFileType(MultipartFile file) throws Exception {
        String suffix = SsrfFileTypeFilter.getFileType(file);
        log.info("suffix:{}", (Object)suffix);
        boolean isAllowExtension = FILE_TYPE_WHITE_LIST.contains(suffix.toLowerCase());
        if (!isAllowExtension) {
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u6587\u4ef6\u7c7b\u578b\uff1a" + suffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileType(MultipartFile file) throws Exception {
        String fileExtendName = null;
        try (InputStream is = null;){
            is = file.getInputStream();
            byte[] b = new byte[10];
            is.read(b, 0, b.length);
            String fileTypeHex = String.valueOf(SsrfFileTypeFilter.bytesToHexString(b));
            for (String key : FILE_TYPE_MAP.keySet()) {
                if (!key.toLowerCase().startsWith(fileTypeHex.toLowerCase().substring(0, 5)) && !fileTypeHex.toLowerCase().substring(0, 5).startsWith(key.toLowerCase())) continue;
                fileExtendName = FILE_TYPE_MAP.get(key);
                break;
            }
            log.info("-----\u83b7\u53d6\u5230\u7684\u6307\u5b9a\u6587\u4ef6\u7c7b\u578b------" + fileExtendName);
            if (StringUtils.isBlank(fileExtendName)) {
                String fileName = file.getOriginalFilename();
                if (-1 == fileName.indexOf(".")) {
                    String string = "";
                    return string;
                }
                String string = SsrfFileTypeFilter.getFileTypeBySuffix(fileName);
                return string;
            }
            log.info("-----\u6700\u7d42\u7684\u6587\u4ef6\u7c7b\u578b------" + fileExtendName);
            is.close();
            String string = fileExtendName;
            return string;
        }
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        FILE_TYPE_WHITE_LIST.add("jpg");
        FILE_TYPE_WHITE_LIST.add("jpeg");
        FILE_TYPE_WHITE_LIST.add("png");
        FILE_TYPE_WHITE_LIST.add("gif");
        FILE_TYPE_WHITE_LIST.add("bmp");
        FILE_TYPE_WHITE_LIST.add("svg");
        FILE_TYPE_WHITE_LIST.add("ico");
        FILE_TYPE_WHITE_LIST.add("txt");
        FILE_TYPE_WHITE_LIST.add("doc");
        FILE_TYPE_WHITE_LIST.add("docx");
        FILE_TYPE_WHITE_LIST.add("pdf");
        FILE_TYPE_WHITE_LIST.add("csv");
        FILE_TYPE_WHITE_LIST.add("mp4");
        FILE_TYPE_WHITE_LIST.add("avi");
        FILE_TYPE_WHITE_LIST.add("mov");
        FILE_TYPE_WHITE_LIST.add("wmv");
        FILE_TYPE_WHITE_LIST.add("mp3");
        FILE_TYPE_WHITE_LIST.add("wav");
        FILE_TYPE_WHITE_LIST.add("xls");
        FILE_TYPE_WHITE_LIST.add("xlsx");
        FILE_TYPE_WHITE_LIST.add("zip");
        FILE_TYPE_WHITE_LIST.add("rar");
        FILE_TYPE_WHITE_LIST.add("7z");
        FILE_TYPE_WHITE_LIST.add("tar");
        FILE_TYPE_WHITE_LIST.add("apk");
        FILE_TYPE_WHITE_LIST.add("wgt");
        FILE_TYPE_MAP.put("3c25402070616765206c", "jsp");
        FILE_TYPE_MAP.put("3c3f7068700a0a2f2a2a0a202a205048", "php");
        FILE_TYPE_MAP.put("cafebabe0000002e0041", "class");
        FILE_TYPE_MAP.put("494e5345525420494e54", "sql");
    }
}

