/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import cn.hutool.core.util.ReUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectionUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String XSS_STR = "and |exec |peformance_schema|information_schema|extractvalue|updatexml|geohash|gtid_subset|gtid_subtract|insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|or |+|--";
    private static String specialReportXssStr = "exec |peformance_schema|information_schema|extractvalue|updatexml|geohash|gtid_subset|gtid_subtract|insert |alter |delete |grant |update |drop |master |truncate |declare |--";
    private static String specialDictSqlXssStr = "exec |peformance_schema|information_schema|extractvalue|updatexml|geohash|gtid_subset|gtid_subtract|insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|+|--";
    private static List<String> FULL_MATCHING_KEYWRODS = new ArrayList<String>();
    private static final String[] XSS_REGULAR_STR_ARRAY;
    private static final Pattern SQL_ANNOTATION;
    private static final String SQL_ANNOTATION2 = "--";
    private static final String SQL_INJECTION_KEYWORD_TIP = "\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}";
    private static final String SQL_INJECTION_TIP = "\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->";
    private static final String SQL_INJECTION_TIP_VARIABLE = "\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}";
    private static Pattern tableNamePattern;
    static final Pattern fieldPattern;

    public static void filterContentMulti(String ... values) {
        SqlInjectionUtil.filterContent(values, null);
    }

    public static void filterContent(String value, String customXssString) {
        if (value == null || "".equals(value)) {
            return;
        }
        SqlInjectionUtil.checkSqlAnnotation(value);
        value = value.toLowerCase().trim();
        String[] xssArr = XSS_STR.split("\\|");
        for (int i = 0; i < xssArr.length; ++i) {
            if (value.indexOf(xssArr[i]) <= -1) continue;
            log.error(SQL_INJECTION_KEYWORD_TIP, (Object)xssArr[i]);
            log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
            throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
        }
        if (customXssString != null) {
            String[] xssArr2 = customXssString.split("\\|");
            for (int i = 0; i < xssArr2.length; ++i) {
                if (value.indexOf(xssArr2[i]) <= -1) continue;
                log.error(SQL_INJECTION_KEYWORD_TIP, (Object)xssArr2[i]);
                log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
                throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
            }
        }
        for (String regularOriginal : XSS_REGULAR_STR_ARRAY) {
            String regular = ".*" + regularOriginal + ".*";
            if (!Pattern.matches(regular, value)) continue;
            log.error(SQL_INJECTION_KEYWORD_TIP, (Object)regularOriginal);
            log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
            throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
        }
    }

    private static boolean isExistSqlInjectKeyword(String sql, String keyword) {
        if (sql.startsWith(keyword.trim())) {
            return true;
        }
        if (sql.contains(keyword)) {
            String matchingText = " " + keyword;
            if (FULL_MATCHING_KEYWRODS.contains(keyword)) {
                matchingText = keyword;
            }
            if (sql.contains(matchingText)) {
                return true;
            }
            String regularStr = "\\s+\\S+" + keyword;
            List resultFindAll = (List)ReUtil.findAll((String)regularStr, (CharSequence)sql, (int)0, new ArrayList());
            for (String res : resultFindAll) {
                log.info("isExistSqlInjectKeyword \u2014- \u5339\u914d\u5230\u7684SQL\u6ce8\u5165\u5173\u952e\u8bcd\uff1a{}", (Object)res);
                if (!res.contains("%") && !res.contains("+") && !res.contains("#") && !res.contains("/") && !res.contains(")")) continue;
                return true;
            }
        }
        return false;
    }

    public static void filterContent(String[] values, String customXssString) {
        for (String val : values) {
            if (oConvertUtils.isEmpty(val)) {
                return;
            }
            SqlInjectionUtil.filterContent(val, customXssString);
        }
    }

    public static void specialFilterContentForDictSql(String value) {
        String[] xssArr = specialDictSqlXssStr.split("\\|");
        if (value == null || "".equals(value)) {
            return;
        }
        SqlInjectionUtil.checkSqlAnnotation(value);
        value = value.toLowerCase().trim();
        for (int i = 0; i < xssArr.length; ++i) {
            if (!SqlInjectionUtil.isExistSqlInjectKeyword(value, xssArr[i])) continue;
            log.error(SQL_INJECTION_KEYWORD_TIP, (Object)xssArr[i]);
            log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
            throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
        }
        for (String regularOriginal : XSS_REGULAR_STR_ARRAY) {
            String regular = ".*" + regularOriginal + ".*";
            if (!Pattern.matches(regular, value)) continue;
            log.error(SQL_INJECTION_KEYWORD_TIP, (Object)regularOriginal);
            log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
            throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
        }
    }

    public static void specialFilterContentForOnlineReport(String value) {
        String[] xssArr = specialReportXssStr.split("\\|");
        if (value == null || "".equals(value)) {
            return;
        }
        SqlInjectionUtil.checkSqlAnnotation(value);
        value = value.toLowerCase().trim();
        for (int i = 0; i < xssArr.length; ++i) {
            if (!SqlInjectionUtil.isExistSqlInjectKeyword(value, xssArr[i])) continue;
            log.error(SQL_INJECTION_KEYWORD_TIP, (Object)xssArr[i]);
            log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
            throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
        }
        for (String regularOriginal : XSS_REGULAR_STR_ARRAY) {
            String regular = ".*" + regularOriginal + ".*";
            if (!Pattern.matches(regular, value)) continue;
            log.error(SQL_INJECTION_KEYWORD_TIP, (Object)regularOriginal);
            log.error(SQL_INJECTION_TIP_VARIABLE, (Object)value);
            throw new JeecgSqlInjectionException(SQL_INJECTION_TIP + value);
        }
    }

    public static void checkSqlAnnotation(String str) {
        if (str.contains(SQL_ANNOTATION2)) {
            String error = "\u8bf7\u6ce8\u610f\uff0cSQL\u4e2d\u4e0d\u5141\u8bb8\u542b\u6ce8\u91ca\uff0c\u6709\u5b89\u5168\u98ce\u9669\uff01";
            log.error(error);
            throw new RuntimeException(error);
        }
        Matcher matcher = SQL_ANNOTATION.matcher(str);
        if (matcher.find()) {
            String error = "\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669---> \\*.*\\";
            log.error(error);
            throw new JeecgSqlInjectionException(error);
        }
    }

    public static String getSqlInjectTableName(String table) {
        boolean isValidTableName;
        if (oConvertUtils.isEmpty(table)) {
            return table;
        }
        int index = table.toLowerCase().indexOf(" where ");
        if (index != -1) {
            table = table.substring(0, index);
            log.info("\u622a\u6389where\u4e4b\u540e\u7684\u65b0\u8868\u540d\uff1a" + table);
        }
        if (!(isValidTableName = tableNamePattern.matcher(table = table.trim()).matches())) {
            String errorMsg = "\u8868\u540d\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + table;
            log.error(errorMsg);
            throw new JeecgSqlInjectionException(errorMsg);
        }
        SqlInjectionUtil.filterContentMulti(table);
        return table;
    }

    public static String getSqlInjectField(String field) {
        if (oConvertUtils.isEmpty(field)) {
            return field;
        }
        if ((field = field.trim()).contains(",")) {
            return SqlInjectionUtil.getSqlInjectField(field.split(","));
        }
        boolean isValidField = fieldPattern.matcher(field).matches();
        if (!isValidField) {
            String errorMsg = "\u5b57\u6bb5\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + field;
            log.error(errorMsg);
            throw new JeecgSqlInjectionException(errorMsg);
        }
        SqlInjectionUtil.filterContentMulti(field);
        return field;
    }

    public static String getSqlInjectField(String ... fields) {
        for (String s : fields) {
            SqlInjectionUtil.getSqlInjectField(s);
        }
        return String.join((CharSequence)",", fields);
    }

    public static String getSqlInjectSortField(String sortField) {
        String field = SqlInjectionUtil.getSqlInjectField(oConvertUtils.camelToUnderline(sortField));
        return field;
    }

    public static List getSqlInjectSortFields(String ... sortFields) {
        ArrayList<String> list = new ArrayList<String>();
        for (String sortField : sortFields) {
            list.add(SqlInjectionUtil.getSqlInjectSortField(sortField));
        }
        return list;
    }

    public static String getSqlInjectOrderType(String orderType) {
        if (orderType == null) {
            return null;
        }
        if ("ASC".equalsIgnoreCase(orderType = orderType.trim())) {
            return "ASC";
        }
        return "DESC";
    }

    static {
        FULL_MATCHING_KEYWRODS.add(";");
        FULL_MATCHING_KEYWRODS.add("+");
        FULL_MATCHING_KEYWRODS.add(SQL_ANNOTATION2);
        XSS_REGULAR_STR_ARRAY = new String[]{"chr\\s*\\(", "mid\\s*\\(", " char\\s*\\(", "sleep\\s*\\(", "user\\s*\\(", "show\\s+tables", "user[\\s]*\\([\\s]*\\)", "show\\s+databases", "sleep\\(\\d*\\)", "sleep\\(.*\\)"};
        SQL_ANNOTATION = Pattern.compile("/\\*[\\s\\S]*\\*/");
        tableNamePattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_\\$]{0,63}$");
        fieldPattern = Pattern.compile("^[a-zA-Z0-9_]+$");
    }
}

