/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DySmsLimit {
    private static final Logger log = LoggerFactory.getLogger(DySmsLimit.class);
    private static final int MAX_MESSAGE_PER_MINUTE = 5;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MAX_TOTAL_MESSAGE_PER_MINUTE = 20;
    private static ConcurrentHashMap<String, Long> ipLastRequestTime = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer> ipRequestCount = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> ipBlacklist = new ConcurrentHashMap();

    public static boolean canSendSms(String ip) {
        long currentTime = System.currentTimeMillis();
        long lastRequestTime = ipLastRequestTime.getOrDefault(ip, 0L);
        int requestCount = ipRequestCount.getOrDefault(ip, 0);
        log.info("IP\uff1a{}, Msg requestCount\uff1a{} ", (Object)ip, (Object)requestCount);
        if (ipBlacklist.getOrDefault(ip, false).booleanValue()) {
            log.error("IP\uff1a{}, \u8fdb\u5165\u9ed1\u540d\u5355\uff0c\u7981\u6b62\u53d1\u9001\u8bf7\u6c42\u77ed\u4fe1\uff01", (Object)ip);
            return false;
        }
        if (currentTime - lastRequestTime >= 60000L) {
            ipRequestCount.put(ip, 1);
            ipLastRequestTime.put(ip, currentTime);
            return true;
        }
        ipRequestCount.put(ip, requestCount + 1);
        if (requestCount < 5) {
            return true;
        }
        if (requestCount >= 20) {
            ipBlacklist.put(ip, true);
            return false;
        }
        log.error("IP\uff1a{}, 1\u5206\u949f\u5185\u8bf7\u6c42\u77ed\u4fe1\u8d85\u8fc75\u6b21\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01", (Object)ip);
        return false;
    }

    public static void clearSendSmsCount(String ip) {
        long currentTime = System.currentTimeMillis();
        ipRequestCount.put(ip, 0);
        ipLastRequestTime.put(ip, currentTime);
    }
}

