/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.config.JeecgSmsTemplateConfig;
import org.jeecg.config.StaticConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DySmsHelper {
    private static final Logger logger = LoggerFactory.getLogger(DySmsHelper.class);
    static final String PRODUCT = "Dysmsapi";
    static final String DOMAIN = "dysmsapi.aliyuncs.com";
    static String accessKeyId;
    static String accessKeySecret;

    public static void setAccessKeyId(String accessKeyId) {
        DySmsHelper.accessKeyId = accessKeyId;
    }

    public static void setAccessKeySecret(String accessKeySecret) {
        DySmsHelper.accessKeySecret = accessKeySecret;
    }

    public static String getAccessKeyId() {
        return accessKeyId;
    }

    public static String getAccessKeySecret() {
        return accessKeySecret;
    }

    public static boolean sendSms(String phone, JSONObject templateParamJson, DySmsEnum dySmsEnum) throws ClientException {
        Map<String, String> smsTemplate;
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        StaticConfig staticConfig = SpringContextUtils.getBean(StaticConfig.class);
        DySmsHelper.setAccessKeyId(staticConfig.getAccessKeyId());
        DySmsHelper.setAccessKeySecret(staticConfig.getAccessKeySecret());
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)PRODUCT, (String)DOMAIN);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        DySmsHelper.validateParam(templateParamJson, dySmsEnum);
        String templateCode = dySmsEnum.getTemplateCode();
        JeecgSmsTemplateConfig baseConfig = SpringContextUtils.getBean(JeecgSmsTemplateConfig.class);
        if (baseConfig != null && CollectionUtil.isNotEmpty(baseConfig.getTemplateCode()) && (smsTemplate = baseConfig.getTemplateCode()).containsKey(templateCode) && StringUtils.isNotEmpty((CharSequence)smsTemplate.get(templateCode))) {
            templateCode = smsTemplate.get(templateCode);
            logger.info("yml\u4e2d\u8bfb\u53d6\u77ed\u4fe1code{}", (Object)templateCode);
        }
        String signName = dySmsEnum.getSignName();
        if (baseConfig != null && StringUtils.isNotEmpty((CharSequence)baseConfig.getSignature())) {
            logger.info("yml\u4e2d\u8bfb\u53d6\u7b7e\u540d\u540d\u79f0{}", (Object)baseConfig.getSignature());
            signName = baseConfig.getSignature();
        }
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phone);
        request.setSignName(signName);
        request.setTemplateCode(templateCode);
        request.setTemplateParam(templateParamJson.toJSONString());
        boolean result = false;
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        logger.info("\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e----------------");
        logger.info("{Code:" + sendSmsResponse.getCode() + ",Message:" + sendSmsResponse.getMessage() + ",RequestId:" + sendSmsResponse.getRequestId() + ",BizId:" + sendSmsResponse.getBizId() + "}");
        String ok = "OK";
        if (ok.equals(sendSmsResponse.getCode())) {
            result = true;
        }
        return result;
    }

    private static void validateParam(JSONObject templateParamJson, DySmsEnum dySmsEnum) {
        String[] keyArr;
        String keys = dySmsEnum.getKeys();
        for (String item : keyArr = keys.split(",")) {
            if (templateParamJson.containsKey((Object)item)) continue;
            throw new RuntimeException("\u6a21\u677f\u7f3a\u5c11\u53c2\u6570\uff1a" + item);
        }
    }
}

