/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.util.StringUtils;

public class DateUtils
extends PropertyEditorSupport {
    public static ThreadLocal<SimpleDateFormat> date_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> yyyyMMdd = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> date_sdf_wz = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        }
    };
    public static ThreadLocal<SimpleDateFormat> time_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    public static ThreadLocal<SimpleDateFormat> yyyymmddhhmmss = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    public static ThreadLocal<SimpleDateFormat> short_time_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm");
        }
    };
    public static ThreadLocal<SimpleDateFormat> datetimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long SECOND_IN_MILLIS = 1000L;

    private static SimpleDateFormat getSdFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(millis));
        return cal;
    }

    public static Date getDate() {
        return new Date();
    }

    public static LocalDate getLocalDate() {
        LocalDate today = LocalDate.now();
        return today;
    }

    public static Date getDate(long millis) {
        return new Date(millis);
    }

    public static String timestamptoStr(Timestamp time) {
        Date date = null;
        if (null != time) {
            date = new Date(time.getTime());
        }
        return DateUtils.date2Str(date_sdf.get());
    }

    public static Timestamp str2Timestamp(String str) {
        Date date = DateUtils.str2Date(str, date_sdf.get());
        return new Timestamp(date.getTime());
    }

    public static Date str2Date(String str, SimpleDateFormat sdf) {
        if (null == str || "".equals(str)) {
            return null;
        }
        Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String date2Str(SimpleDateFormat dateSdf) {
        SimpleDateFormat simpleDateFormat = dateSdf;
        synchronized (simpleDateFormat) {
            Date date = DateUtils.getDate();
            if (null == date) {
                return null;
            }
            return dateSdf.format(date);
        }
    }

    public static String dateformat(String date, String format) {
        SimpleDateFormat sformat = new SimpleDateFormat(format);
        Date nowDate = null;
        try {
            nowDate = sformat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sformat.format(nowDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String date2Str(Date date, SimpleDateFormat dateSdf) {
        SimpleDateFormat simpleDateFormat = dateSdf;
        synchronized (simpleDateFormat) {
            if (null == date) {
                return null;
            }
            return dateSdf.format(date);
        }
    }

    public static String getDate(String format) {
        Date date = new Date();
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getTimestamp(String time) {
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String now() {
        return datetimeFormat.get().format(DateUtils.getCalendar().getTime());
    }

    public static Timestamp getTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp getCalendarTimestamp(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp gettimestamp() {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = df.format(dt);
        Timestamp buydate = Timestamp.valueOf(nowTime);
        return buydate;
    }

    public static long getMillis() {
        return System.currentTimeMillis();
    }

    public static long getMillis(Calendar cal) {
        return cal.getTime().getTime();
    }

    public static long getMillis(Date date) {
        return date.getTime();
    }

    public static long getMillis(Timestamp ts) {
        return ts.getTime();
    }

    public static String formatDate() {
        return date_sdf.get().format(DateUtils.getCalendar().getTime());
    }

    public static String formatDateTime() {
        return datetimeFormat.get().format(DateUtils.getCalendar().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataString(SimpleDateFormat formatstr) {
        SimpleDateFormat simpleDateFormat = formatstr;
        synchronized (simpleDateFormat) {
            return formatstr.format(DateUtils.getCalendar().getTime());
        }
    }

    public static String formatDate(Calendar cal) {
        return date_sdf.get().format(cal.getTime());
    }

    public static String formatDate(Date date) {
        return date_sdf.get().format(date);
    }

    public static String formatDate(long millis) {
        return date_sdf.get().format(new Date(millis));
    }

    public static String formatDate(String pattern) {
        return DateUtils.getSdFormat(pattern).format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal, String pattern) {
        return DateUtils.getSdFormat(pattern).format(cal.getTime());
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtils.getSdFormat(pattern).format(date);
    }

    public static String formatTime() {
        return time_sdf.get().format(DateUtils.getCalendar().getTime());
    }

    public static String formatTime(long millis) {
        return time_sdf.get().format(new Date(millis));
    }

    public static String formatTime(Calendar cal) {
        return time_sdf.get().format(cal.getTime());
    }

    public static String formatTime(Date date) {
        return time_sdf.get().format(date);
    }

    public static String formatShortTime() {
        return short_time_sdf.get().format(DateUtils.getCalendar().getTime());
    }

    public static String formatShortTime(long millis) {
        return short_time_sdf.get().format(new Date(millis));
    }

    public static String formatShortTime(Calendar cal) {
        return short_time_sdf.get().format(cal.getTime());
    }

    public static String formatShortTime(Date date) {
        return short_time_sdf.get().format(date);
    }

    public static Date parseDate(String src, String pattern) throws ParseException {
        return DateUtils.getSdFormat(pattern).parse(src);
    }

    public static Calendar parseCalendar(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String formatAddDate(String src, String pattern, int amount) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(5, amount);
        return DateUtils.formatDate(cal);
    }

    public static Timestamp parseTimestamp(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static int dateDiff(char flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = DateUtils.getMillis(calSrc) - DateUtils.getMillis(calDes);
        char year = 'y';
        char day = 'd';
        char hour = 'h';
        char minute = 'm';
        char second = 's';
        if (flag == year) {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == day) {
            return (int)(millisDiff / 86400000L);
        }
        if (flag == hour) {
            return (int)(millisDiff / 3600000L);
        }
        if (flag == minute) {
            return (int)(millisDiff / 60000L);
        }
        if (flag == second) {
            return (int)(millisDiff / 1000L);
        }
        return 0;
    }

    public static Long getCurrentTimestamp() {
        return Long.valueOf(yyyymmddhhmmss.get().format(new Date()));
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                int length10 = 10;
                int length19 = 19;
                if (text.indexOf(":") == -1 && text.length() == length10) {
                    this.setValue(date_sdf.get().parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == length19) {
                    this.setValue(datetimeFormat.get().parse(text));
                }
                throw new IllegalArgumentException("Could not parse date, date format is error ");
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("Could not parse date: " + ex.getMessage());
                iae.initCause(ex);
                throw iae;
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getDate());
        return calendar.get(1);
    }

    public static Date parseDatetime(String str) {
        try {
            return datetimeFormat.get().parse(str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        boolean isSameYear = calendar1.get(1) == calendar2.get(1);
        boolean isSameMonth = isSameYear && calendar1.get(2) == calendar2.get(2);
        return isSameMonth && calendar1.get(5) == calendar2.get(5);
    }

    public static long calculateTimeDifference(Date targetDate) {
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime convertedTargetDate = targetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        Duration duration = Duration.between(currentTime, convertedTargetDate);
        long timeDifferenceInMillis = duration.toMillis();
        return timeDifferenceInMillis;
    }

    public static long calculateDaysDifference(Date targetDate) {
        LocalDate currentDate = LocalDate.now();
        LocalDate convertedTargetDate = targetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long daysDifference = ChronoUnit.DAYS.between(currentDate, convertedTargetDate);
        return daysDifference;
    }

    public static boolean isSameWeek(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        boolean isSameYear = calendar1.get(1) == calendar2.get(1);
        return isSameYear && calendar1.get(3) == calendar2.get(3);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        boolean isSameYear = calendar1.get(1) == calendar2.get(1);
        return isSameYear && calendar1.get(2) == calendar2.get(2);
    }

    public static boolean isSameYear(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(1) == calendar2.get(1);
    }
}

