/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import cn.hutool.core.date.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.jeecg.common.constant.enums.DateRangeEnum;

public class DateRangeUtils {
    public static Date[] getDateRangeByEnum(DateRangeEnum rangeEnum) {
        if (rangeEnum == null) {
            return null;
        }
        Date[] ranges = new Date[2];
        switch (rangeEnum) {
            case TODAY: {
                ranges[0] = DateRangeUtils.getTodayStartTime();
                ranges[1] = DateRangeUtils.getTodayEndTime();
                break;
            }
            case YESTERDAY: {
                ranges[0] = DateRangeUtils.getYesterdayStartTime();
                ranges[1] = DateRangeUtils.getYesterdayEndTime();
                break;
            }
            case TOMORROW: {
                ranges[0] = DateRangeUtils.getTomorrowStartTime();
                ranges[1] = DateRangeUtils.getTomorrowEndTime();
                break;
            }
            case THIS_WEEK: {
                ranges[0] = DateRangeUtils.getThisWeekStartDay();
                ranges[1] = DateRangeUtils.getThisWeekEndDay();
                break;
            }
            case LAST_WEEK: {
                ranges[0] = DateRangeUtils.getLastWeekStartDay();
                ranges[1] = DateRangeUtils.getLastWeekEndDay();
                break;
            }
            case NEXT_WEEK: {
                ranges[0] = DateRangeUtils.getNextWeekStartDay();
                ranges[1] = DateRangeUtils.getNextWeekEndDay();
                break;
            }
            case LAST_7_DAYS: {
                ranges[0] = DateRangeUtils.getLast7DaysStartTime();
                ranges[1] = DateRangeUtils.getLast7DaysEndTime();
                break;
            }
            case THIS_MONTH: {
                ranges[0] = DateRangeUtils.getThisMonthStartDay();
                ranges[1] = DateRangeUtils.getThisMonthEndDay();
                break;
            }
            case LAST_MONTH: {
                ranges[0] = DateRangeUtils.getLastMonthStartDay();
                ranges[1] = DateRangeUtils.getLastMonthEndDay();
                break;
            }
            case NEXT_MONTH: {
                ranges[0] = DateRangeUtils.getNextMonthStartDay();
                ranges[1] = DateRangeUtils.getNextMonthEndDay();
                break;
            }
            default: {
                return null;
            }
        }
        return ranges;
    }

    public static Date getNextMonthStartDay() {
        return DateUtil.beginOfMonth((Date)DateUtil.nextMonth());
    }

    public static Date getNextMonthEndDay() {
        return DateUtil.endOfMonth((Date)DateUtil.nextMonth());
    }

    public static Date getThisMonthStartDay() {
        return DateUtil.beginOfMonth((Date)DateUtil.date());
    }

    public static Date getThisMonthEndDay() {
        return DateUtil.endOfMonth((Date)DateUtil.date());
    }

    public static Date getLastMonthStartDay() {
        return DateUtil.beginOfMonth((Date)DateUtil.lastMonth());
    }

    public static Date getLastMonthEndDay() {
        return DateUtil.endOfMonth((Date)DateUtil.lastMonth());
    }

    public static Date getLastWeekStartDay() {
        return DateUtil.beginOfWeek((Date)DateUtil.lastWeek());
    }

    public static Date getLastWeekEndDay() {
        return DateUtil.endOfWeek((Date)DateUtil.lastWeek());
    }

    public static Date getThisWeekStartDay() {
        Date today = new Date();
        return DateUtil.beginOfWeek((Date)today);
    }

    public static Date getThisWeekEndDay() {
        Date today = new Date();
        return DateUtil.endOfWeek((Date)today);
    }

    public static Date getNextWeekStartDay() {
        return DateUtil.beginOfWeek((Date)DateUtil.nextWeek());
    }

    public static Date getNextWeekEndDay() {
        return DateUtil.endOfWeek((Date)DateUtil.nextWeek());
    }

    public static Date getLast7DaysStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -7);
        return DateUtil.beginOfDay((Date)calendar.getTime());
    }

    public static Date getLast7DaysEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateRangeUtils.getLast7DaysStartTime());
        calendar.add(5, 6);
        return DateUtil.endOfDay((Date)calendar.getTime());
    }

    public static Date getYesterdayStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        return DateUtil.beginOfDay((Date)calendar.getTime());
    }

    public static Date getYesterdayEndTime() {
        return DateUtil.endOfDay((Date)DateRangeUtils.getYesterdayStartTime());
    }

    public static Date getTomorrowStartTime() {
        return DateUtil.beginOfDay((Date)DateUtil.tomorrow());
    }

    public static Date getTomorrowEndTime() {
        return DateUtil.endOfDay((Date)DateUtil.tomorrow());
    }

    public static Date getTodayStartTime() {
        return DateUtil.beginOfDay((Date)new Date());
    }

    public static Date getTodayEndTime() {
        return DateUtil.endOfDay((Date)new Date());
    }
}

