/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    public static final long EXPIRE_TIME = 302400000L;
    static final String WELL_NUMBER = "#{";

    public static void responseError(ServletResponse response, Integer code, String errorMsg) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Content-type", "text/html;charset=UTF-8");
        Result jsonResult = new Result(code, errorMsg);
        jsonResult.setSuccess(false);
        ServletOutputStream os = null;
        try {
            os = httpServletResponse.getOutputStream();
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setStatus(code.intValue());
            os.write(new ObjectMapper().writeValueAsString(jsonResult).getBytes("UTF-8"));
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean verify(String token, String username, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("username", username).build();
            DecodedJWT jwt = verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("username").asString();
        }
        catch (JWTDecodeException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String sign(String username, String secret) {
        Date date = new Date(System.currentTimeMillis() + 302400000L);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("username", username).withExpiresAt(date).sign(algorithm);
    }

    public static String getUserNameByToken(HttpServletRequest request) throws JeecgBootException {
        String accessToken = request.getHeader("X-Access-Token");
        String username = JwtUtil.getUsername(accessToken);
        if (oConvertUtils.isEmpty(username)) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230\u7528\u6237");
        }
        return username;
    }

    public static String getSessionData(String key) {
        String moshi = "";
        String wellNumber = WELL_NUMBER;
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains(wellNumber)) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (oConvertUtils.isNotEmpty(key)) {
            HttpSession session = SpringContextUtils.getHttpServletRequest().getSession();
            returnValue = (String)session.getAttribute(key);
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }

    public static String getUserSystemData(String key, SysUserCacheInfo user) {
        boolean multiStr;
        if (user == null) {
            try {
                user = JeecgDataAutorUtils.loadUserInfo();
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        LoginUser sysUser = null;
        try {
            sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        }
        catch (Exception e) {
            log.warn("SecurityUtils.getSubject() \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        String moshi = "";
        String wellNumber = WELL_NUMBER;
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains(wellNumber)) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (oConvertUtils.isNotEmpty(key) && key.trim().matches("^\\[\\w+]$")) {
            key = key.substring(1, key.length() - 1);
            multiStr = true;
        } else {
            multiStr = false;
        }
        if (key.equals("sysDate") || key.toLowerCase().equals("sys_date")) {
            returnValue = DateUtils.formatDate();
        } else if (key.equals("sysTime") || key.toLowerCase().equals("sys_time")) {
            returnValue = DateUtils.now();
        } else if (key.equals("bpmStatus") || key.toLowerCase().equals("bpm_status")) {
            returnValue = "1";
        }
        if (sysUser == null && user == null) {
            return null;
        }
        if (key.equals("sysUserCode") || key.toLowerCase().equals("sys_user_code")) {
            returnValue = user == null ? sysUser.getUsername() : user.getSysUserCode();
        } else if (key.equals("sysUserId") || key.equalsIgnoreCase("sys_user_id")) {
            returnValue = user == null ? sysUser.getId() : user.getSysUserId();
        } else if (key.equals("sysUserName") || key.toLowerCase().equals("sys_user_name")) {
            returnValue = user == null ? sysUser.getRealname() : user.getSysUserName();
        } else if (key.equals("sysOrgCode") || key.toLowerCase().equals("sys_org_code")) {
            returnValue = user == null ? sysUser.getOrgCode() : user.getSysOrgCode();
        } else if (key.equals("sysOrgId") || key.equalsIgnoreCase("sys_org_id")) {
            returnValue = user == null ? sysUser.getOrgId() : user.getSysOrgId();
        } else if (key.equals("sysMultiOrgCode") || key.toLowerCase().equals("sys_multi_org_code")) {
            if (user == null) {
                returnValue = sysUser.getOrgCode();
                returnValue = multiStr ? "'" + returnValue + "'" : returnValue;
            } else if (user.isOneDepart()) {
                returnValue = user.getSysMultiOrgCode().get(0);
                returnValue = multiStr ? "'" + returnValue + "'" : returnValue;
            } else {
                returnValue = user.getSysMultiOrgCode().stream().filter(Objects::nonNull).map(orgCode -> {
                    if (multiStr) {
                        return "'" + orgCode + "'";
                    }
                    return orgCode;
                }).collect(Collectors.joining(", "));
            }
        } else if (key.equals("sysRoleCode") || key.equalsIgnoreCase("sys_role_code")) {
            returnValue = user == null ? sysUser.getRoleCode() : user.getSysRoleCode();
        } else if (key.equals("tenantId") || key.toLowerCase().equals("tenant_id")) {
            try {
                returnValue = SpringContextUtils.getHttpServletRequest().getHeader("X-Tenant-Id");
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u7cfb\u7edf\u79df\u6237\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }
}

