/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.query;

import org.jeecg.common.util.oConvertUtils;

public enum QueryRuleEnum {
    GT(">", "gt", "\u5927\u4e8e"),
    GE(">=", "ge", "\u5927\u4e8e\u7b49\u4e8e"),
    LT("<", "lt", "\u5c0f\u4e8e"),
    LE("<=", "le", "\u5c0f\u4e8e\u7b49\u4e8e"),
    EQ("=", "eq", "\u7b49\u4e8e"),
    NE("!=", "ne", "\u4e0d\u7b49\u4e8e"),
    IN("IN", "in", "\u5305\u542b"),
    LIKE("LIKE", "like", "\u5168\u6a21\u7cca"),
    NOT_LIKE("NOT_LIKE", "not_like", "\u4e0d\u6a21\u7cca\u5305\u542b"),
    LEFT_LIKE("LEFT_LIKE", "left_like", "\u5de6\u6a21\u7cca"),
    RIGHT_LIKE("RIGHT_LIKE", "right_like", "\u53f3\u6a21\u7cca"),
    EQ_WITH_ADD("EQWITHADD", "eq_with_add", "\u5e26\u52a0\u53f7\u7b49\u4e8e"),
    LIKE_WITH_AND("LIKEWITHAND", "like_with_and", "\u591a\u8bcd\u6a21\u7cca\u5339\u914d\u2014\u2014\u2014\u2014\u6682\u65f6\u672a\u7528\u4e0a"),
    LIKE_WITH_OR("LIKEWITHOR", "like_with_or", "\u591a\u8bcd\u6a21\u7cca\u5339\u914d(or)"),
    SQL_RULES("USE_SQL_RULES", "ext", "\u81ea\u5b9a\u4e49SQL\u7247\u6bb5"),
    LINKAGE("LINKAGE", "linkage", "\u67e5\u8be2\u5de5\u4f5c\u8868"),
    NOT_LEFT_LIKE("NOT_LEFT_LIKE", "not_left_like", "\u4e0d\u4ee5\u2026\u7ed3\u5c3e"),
    NOT_RIGHT_LIKE("NOT_RIGHT_LIKE", "not_right_like", "\u4e0d\u4ee5\u2026\u5f00\u5934"),
    EMPTY("EMPTY", "empty", "\u503c\u4e3a\u7a7a"),
    NOT_EMPTY("NOT_EMPTY", "not_empty", "\u503c\u4e0d\u4e3a\u7a7a"),
    NOT_IN("NOT_IN", "not_in", "\u4e0d\u5305\u542b"),
    ELE_MATCH("ELE_MATCH", "elemMatch", "\u591a\u8bcd\u5339\u914d"),
    ELE_NOT_MATCH("ELE_NOT_MATCH", "elemNotMatch", "\u591a\u8bcd\u7cbe\u786e\u4e0d\u5339\u914d"),
    RANGE("RANGE", "range", "\u8303\u56f4\u67e5\u8be2"),
    NOT_RANGE("NOT_RANGE", "not_range", "\u4e0d\u5728\u8303\u56f4\u67e5\u8be2"),
    CUSTOM_MONGODB("CUSTOM_MONGODB", "custom_mongodb", "\u81ea\u5b9a\u4e49mongodb\u67e5\u8be2\u8bed\u53e5");

    private String value;
    private String condition;
    private String msg;

    private QueryRuleEnum(String value, String condition, String msg) {
        this.value = value;
        this.condition = condition;
        this.msg = msg;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public static QueryRuleEnum getByValue(String value) {
        if (oConvertUtils.isEmpty(value)) {
            return null;
        }
        for (QueryRuleEnum val : QueryRuleEnum.values()) {
            if (!val.getValue().equals(value) && !val.getCondition().equalsIgnoreCase(value)) continue;
            return val;
        }
        return null;
    }
}

