/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.query;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.util.SqlConcatUtil;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.ReflectHelper;
import org.jeecg.common.util.SqlInjectionUtil;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.NumberUtils;

public class QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(QueryGenerator.class);
    public static final String SQL_RULES_COLUMN = "SQL_RULES_COLUMN";
    private static final String BEGIN = "_begin";
    private static final String END = "_end";
    private static final String MULTI = "_MultiString";
    private static final String STAR = "*";
    private static final String COMMA = ",";
    public static final String QUERY_COMMA_ESCAPE = "++";
    private static final String NOT_EQUAL = "!";
    private static final String QUERY_SEPARATE_KEYWORD = " ";
    private static final String SUPER_QUERY_PARAMS = "superQueryParams";
    private static final String SUPER_QUERY_MATCH_TYPE = "superQueryMatchType";
    public static final String SQL_SQ = "'";
    private static final String ORDER_COLUMN = "column";
    private static final String ORDER_TYPE = "order";
    private static final String ORDER_TYPE_ASC = "ASC";
    public static final String LIKE_MYSQL_SPECIAL_STRS = "_,%";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TO_DATE = "to_date";
    private static final ThreadLocal<SimpleDateFormat> LOCAL = new ThreadLocal();

    private static SimpleDateFormat getTime() {
        SimpleDateFormat time = LOCAL.get();
        if (time == null) {
            time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LOCAL.set(time);
        }
        return time;
    }

    public static <T> QueryWrapper<T> initQueryWrapper(T searchObj, Map<String, String[]> parameterMap) {
        long start = System.currentTimeMillis();
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryGenerator.installMplus(queryWrapper, searchObj, parameterMap, null);
        log.debug("---\u67e5\u8be2\u6761\u4ef6\u6784\u9020\u5668\u521d\u59cb\u5316\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2----");
        return queryWrapper;
    }

    public static <T> QueryWrapper<T> initQueryWrapper(T searchObj, Map<String, String[]> parameterMap, Map<String, QueryRuleEnum> customRuleMap) {
        long start = System.currentTimeMillis();
        QueryWrapper queryWrapper = new QueryWrapper();
        QueryGenerator.installMplus(queryWrapper, searchObj, parameterMap, customRuleMap);
        log.debug("---\u67e5\u8be2\u6761\u4ef6\u6784\u9020\u5668\u521d\u59cb\u5316\u5b8c\u6210,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2----");
        return queryWrapper;
    }

    private static void installMplus(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap, Map<String, QueryRuleEnum> customRuleMap) {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)searchObj);
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty(c) || !c.startsWith(SQL_RULES_COLUMN)) continue;
            queryWrapper.and(i -> i.apply(QueryGenerator.getSqlRuleValue(((SysPermissionDataRuleModel)ruleMap.get(c)).getRuleValue()), new Object[0]));
        }
        HashMap<String, String> fieldColumnMap = new HashMap<String, String>(5);
        for (int i2 = 0; i2 < origDescriptors.length; ++i2) {
            String name = origDescriptors[i2].getName();
            String type = origDescriptors[i2].getPropertyType().toString();
            try {
                if (QueryGenerator.judgedIsUselessField(name) || !PropertyUtils.isReadable((Object)searchObj, (String)name)) continue;
                Object value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name);
                String column = ReflectHelper.getTableFieldName(searchObj.getClass(), name);
                if (column == null) continue;
                fieldColumnMap.put(name, column);
                if (ruleMap.containsKey(name)) {
                    QueryGenerator.addRuleToQueryWrapper(ruleMap.get(name), column, origDescriptors[i2].getPropertyType(), queryWrapper);
                }
                QueryGenerator.doIntervalQuery(queryWrapper, parameterMap, type, name, column);
                if (null != value && value.toString().startsWith(COMMA) && value.toString().endsWith(COMMA)) {
                    String multiLikeval = value.toString().replace(",,", COMMA);
                    String[] vals = multiLikeval.substring(1, multiLikeval.length()).split(COMMA);
                    String field = oConvertUtils.camelToUnderline(column);
                    if (vals.length > 1) {
                        queryWrapper.and(j -> {
                            log.info("---\u67e5\u8be2\u8fc7\u6ee4\u5668\uff0cQuery\u89c4\u5219---field:{}, rule:{}, value:{}", new Object[]{field, "like", vals[0]});
                            j = (QueryWrapper)j.like((Object)field, (Object)vals[0]);
                            for (int k = 1; k < vals.length; ++k) {
                                j = (QueryWrapper)((QueryWrapper)j.or()).like((Object)field, (Object)vals[k]);
                                log.info("---\u67e5\u8be2\u8fc7\u6ee4\u5668\uff0cQuery\u89c4\u5219 .or()---field:{}, rule:{}, value:{}", new Object[]{field, "like", vals[k]});
                            }
                        });
                        continue;
                    }
                    log.info("---\u67e5\u8be2\u8fc7\u6ee4\u5668\uff0cQuery\u89c4\u5219---field:{}, rule:{}, value:{}", new Object[]{field, "like", vals[0]});
                    queryWrapper.and(j -> j.like((Object)field, (Object)vals[0]));
                    continue;
                }
                QueryRuleEnum rule = null != customRuleMap && customRuleMap.containsKey(name) ? customRuleMap.get(name) : QueryGenerator.convert2Rule(value);
                value = QueryGenerator.replaceValue(rule, value);
                QueryGenerator.addEasyQuery(queryWrapper, column, rule, value);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        QueryGenerator.doMultiFieldsOrder(queryWrapper, parameterMap, fieldColumnMap);
        QueryGenerator.doSuperQuery(queryWrapper, parameterMap, fieldColumnMap);
    }

    private static void doIntervalQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, String type, String filedName, String columnName) throws ParseException {
        String endValue = null;
        String beginValue = null;
        if (parameterMap != null && parameterMap.containsKey(filedName + BEGIN)) {
            beginValue = parameterMap.get(filedName + BEGIN)[0].trim();
            QueryGenerator.addQueryByRule(queryWrapper, columnName, type, beginValue, QueryRuleEnum.GE);
        }
        if (parameterMap != null && parameterMap.containsKey(filedName + END)) {
            endValue = parameterMap.get(filedName + END)[0].trim();
            QueryGenerator.addQueryByRule(queryWrapper, columnName, type, endValue, QueryRuleEnum.LE);
        }
        if (parameterMap != null && parameterMap.containsKey(filedName + MULTI)) {
            endValue = parameterMap.get(filedName + MULTI)[0].trim();
            QueryGenerator.addQueryByRule(queryWrapper, columnName.replace(MULTI, ""), type, endValue, QueryRuleEnum.IN);
        }
    }

    private static void doMultiFieldsOrder(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, Map<String, String> fieldColumnMap) {
        Set<String> allFields = fieldColumnMap.keySet();
        String column = null;
        String order = null;
        if (parameterMap != null && parameterMap.containsKey(ORDER_COLUMN)) {
            column = parameterMap.get(ORDER_COLUMN)[0];
        }
        if (parameterMap != null && parameterMap.containsKey(ORDER_TYPE)) {
            order = parameterMap.get(ORDER_TYPE)[0];
        }
        log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + column + ",\u6392\u5e8f\u65b9\u5f0f:" + order);
        if ("createTime".equals(column) && !fieldColumnMap.containsKey("createTime")) {
            column = "id";
            log.warn("\u68c0\u6d4b\u5230\u5b9e\u4f53\u91cc\u6ca1\u6709\u5b57\u6bb5createTime\uff0c\u6539\u6210\u91c7\u7528ID\u6392\u5e8f\uff01");
        }
        if (oConvertUtils.isNotEmpty(column) && oConvertUtils.isNotEmpty(order)) {
            if (column.endsWith("_dictText")) {
                column = column.substring(0, column.lastIndexOf("_dictText"));
            }
            log.debug("\u5f53\u524d\u5b57\u6bb5\u6709\uff1a" + allFields);
            if (!QueryGenerator.allColumnExist(column, allFields)) {
                throw new JeecgBootException("\u8bf7\u6ce8\u610f\uff0c\u5c06\u8981\u6392\u5e8f\u7684\u5217\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + column);
            }
            if (column.contains(COMMA)) {
                List<String> columnList = Arrays.asList(column.split(COMMA));
                String columnStrNew = columnList.stream().map(c -> (String)fieldColumnMap.get(c)).collect(Collectors.joining(COMMA));
                if (oConvertUtils.isNotEmpty(columnStrNew)) {
                    column = columnStrNew;
                }
            } else {
                column = fieldColumnMap.get(column);
            }
            SqlInjectionUtil.filterContentMulti(column);
            if (order.toUpperCase().indexOf(ORDER_TYPE_ASC) >= 0) {
                queryWrapper.orderByAsc(SqlInjectionUtil.getSqlInjectSortFields(column.split(COMMA)));
            } else {
                queryWrapper.orderByDesc(SqlInjectionUtil.getSqlInjectSortFields(column.split(COMMA)));
            }
        }
    }

    private static boolean allColumnExist(String columnStr, Set<String> allFields) {
        boolean exist = true;
        if (columnStr.indexOf(COMMA) >= 0) {
            String[] arr;
            for (String column : arr = columnStr.split(COMMA)) {
                if (allFields.contains(column)) continue;
                exist = false;
                break;
            }
        } else {
            exist = allFields.contains(columnStr);
        }
        return exist;
    }

    private static void doSuperQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, Map<String, String> fieldColumnMap) {
        if (parameterMap != null && parameterMap.containsKey(SUPER_QUERY_PARAMS)) {
            String superQueryParams = parameterMap.get(SUPER_QUERY_PARAMS)[0];
            String superQueryMatchType = parameterMap.get(SUPER_QUERY_MATCH_TYPE) != null ? parameterMap.get(SUPER_QUERY_MATCH_TYPE)[0] : MatchTypeEnum.AND.getValue();
            MatchTypeEnum matchType = MatchTypeEnum.getByValue(superQueryMatchType);
            try {
                superQueryParams = URLDecoder.decode(superQueryParams, "UTF-8");
                List conditions = JSON.parseArray((String)superQueryParams, QueryCondition.class);
                if (conditions == null || conditions.size() == 0) {
                    return;
                }
                List filterConditions = conditions.stream().filter(rule -> oConvertUtils.isNotEmpty(rule.getField()) && oConvertUtils.isNotEmpty(rule.getRule()) && oConvertUtils.isNotEmpty(rule.getVal())).collect(Collectors.toList());
                if (filterConditions.size() == 0) {
                    return;
                }
                log.debug("---\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570-->" + filterConditions);
                queryWrapper.and(andWrapper -> {
                    for (int i = 0; i < filterConditions.size(); ++i) {
                        QueryCondition rule = (QueryCondition)filterConditions.get(i);
                        if (!oConvertUtils.isNotEmpty(rule.getField()) || !oConvertUtils.isNotEmpty(rule.getRule()) || !oConvertUtils.isNotEmpty(rule.getVal())) continue;
                        log.debug("SuperQuery ==> " + rule.toString());
                        Object queryValue = rule.getVal();
                        if ("date".equals(rule.getType())) {
                            queryValue = DateUtils.str2Date(rule.getVal(), DateUtils.date_sdf.get());
                        } else if ("datetime".equals(rule.getType())) {
                            queryValue = DateUtils.str2Date(rule.getVal(), DateUtils.datetimeFormat.get());
                        }
                        String dbType = rule.getDbType();
                        if (oConvertUtils.isNotEmpty(dbType)) {
                            try {
                                String valueStr = String.valueOf(queryValue);
                                switch (dbType.toLowerCase().trim()) {
                                    case "int": {
                                        queryValue = Integer.parseInt(valueStr);
                                        break;
                                    }
                                    case "bigdecimal": {
                                        queryValue = new BigDecimal(valueStr);
                                        break;
                                    }
                                    case "short": {
                                        queryValue = Short.parseShort(valueStr);
                                        break;
                                    }
                                    case "long": {
                                        queryValue = Long.parseLong(valueStr);
                                        break;
                                    }
                                    case "float": {
                                        queryValue = Float.valueOf(Float.parseFloat(valueStr));
                                        break;
                                    }
                                    case "double": {
                                        queryValue = Double.parseDouble(valueStr);
                                        break;
                                    }
                                    case "boolean": {
                                        queryValue = Boolean.parseBoolean(valueStr);
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("\u9ad8\u7ea7\u67e5\u8be2\u503c\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)e);
                            }
                        }
                        QueryGenerator.addEasyQuery(andWrapper, (String)fieldColumnMap.get(rule.getField()), QueryRuleEnum.getByValue(rule.getRule()), queryValue);
                        if (MatchTypeEnum.OR != matchType || i >= filterConditions.size() - 1) continue;
                        andWrapper.or();
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u8f6c\u7801\u5931\u8d25\uff1a" + superQueryParams, (Throwable)e);
            }
            catch (Exception e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u62fc\u63a5\u5931\u8d25\uff1a" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static QueryRuleEnum convert2Rule(Object value) {
        if (value == null) {
            return QueryRuleEnum.EQ;
        }
        String val = (value + "").toString().trim();
        if (val.length() == 0) {
            return QueryRuleEnum.EQ;
        }
        QueryRuleEnum rule = null;
        int length2 = 2;
        int length3 = 3;
        if (rule == null && val.length() >= length3 && QUERY_SEPARATE_KEYWORD.equals(val.substring(length2, length3))) {
            rule = QueryRuleEnum.getByValue(val.substring(0, 2));
        }
        if (rule == null && val.length() >= length2 && QUERY_SEPARATE_KEYWORD.equals(val.substring(1, length2))) {
            rule = QueryRuleEnum.getByValue(val.substring(0, 1));
        }
        if (rule == null && val.equals(STAR)) {
            rule = QueryRuleEnum.EQ;
        }
        if (rule == null && val.contains(STAR)) {
            if (val.startsWith(STAR) && val.endsWith(STAR)) {
                rule = QueryRuleEnum.LIKE;
            } else if (val.startsWith(STAR)) {
                rule = QueryRuleEnum.LEFT_LIKE;
            } else if (val.endsWith(STAR)) {
                rule = QueryRuleEnum.RIGHT_LIKE;
            }
        }
        if (rule == null && val.contains(COMMA)) {
            rule = QueryRuleEnum.IN;
        }
        if (rule == null && val.startsWith(NOT_EQUAL)) {
            rule = QueryRuleEnum.NE;
        }
        if (rule == null && val.indexOf(QUERY_COMMA_ESCAPE) > 0) {
            rule = QueryRuleEnum.EQ_WITH_ADD;
        }
        if (rule == QueryRuleEnum.IN && val.indexOf(YYYY_MM_DD) >= 0 && val.indexOf(TO_DATE) >= 0) {
            rule = QueryRuleEnum.EQ;
        }
        return rule != null ? rule : QueryRuleEnum.EQ;
    }

    private static Object replaceValue(QueryRuleEnum rule, Object value) {
        if (rule == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String val = (value + "").toString().trim();
        if (QueryRuleEnum.EQ.getValue().equals(val)) {
            return val;
        }
        if (rule == QueryRuleEnum.LIKE) {
            value = val.substring(1, val.length() - 1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.LEFT_LIKE || rule == QueryRuleEnum.NE) {
            value = val.substring(1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.RIGHT_LIKE) {
            value = val.substring(0, val.length() - 1);
            value = QueryGenerator.specialStrConvert(value.toString());
        } else if (rule == QueryRuleEnum.IN) {
            value = val.split(COMMA);
        } else if (rule == QueryRuleEnum.EQ_WITH_ADD) {
            value = val.replaceAll("\\+\\+", COMMA);
        } else if (val.startsWith(rule.getValue())) {
            value = val.replaceFirst(rule.getValue(), "");
        } else if (val.startsWith(rule.getCondition() + QUERY_SEPARATE_KEYWORD)) {
            value = val.replaceFirst(rule.getCondition() + QUERY_SEPARATE_KEYWORD, "").trim();
        }
        return value;
    }

    private static void addQueryByRule(QueryWrapper<?> queryWrapper, String name, String type, String value, QueryRuleEnum rule) throws ParseException {
        if (oConvertUtils.isNotEmpty(value)) {
            if (value.contains(COMMA)) {
                Object[] temp = Arrays.stream(value.split(COMMA)).map(v -> {
                    try {
                        return QueryGenerator.parseByType(v, type, rule);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        return v;
                    }
                }).toArray();
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, temp);
                return;
            }
            Object temp = QueryGenerator.parseByType(value, type, rule);
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, temp);
        }
    }

    private static Object parseByType(String value, String type, QueryRuleEnum rule) throws ParseException {
        Object temp;
        switch (type) {
            case "class java.lang.Integer": {
                temp = Integer.parseInt(value);
                break;
            }
            case "class java.math.BigDecimal": {
                temp = new BigDecimal(value);
                break;
            }
            case "class java.lang.Short": {
                temp = Short.parseShort(value);
                break;
            }
            case "class java.lang.Long": {
                temp = Long.parseLong(value);
                break;
            }
            case "class java.lang.Float": {
                temp = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case "class java.lang.Double": {
                temp = Double.parseDouble(value);
                break;
            }
            case "class java.util.Date": {
                temp = QueryGenerator.getDateQueryByRule(value, rule);
                break;
            }
            default: {
                temp = value;
            }
        }
        return temp;
    }

    private static Date getDateQueryByRule(String value, QueryRuleEnum rule) throws ParseException {
        Date date = null;
        int length = 10;
        if (value.length() == length) {
            if (rule == QueryRuleEnum.GE) {
                date = QueryGenerator.getTime().parse(value + " 00:00:00");
            } else if (rule == QueryRuleEnum.LE) {
                date = QueryGenerator.getTime().parse(value + " 23:59:59");
            }
        }
        if (date == null) {
            date = QueryGenerator.getTime().parse(value);
        }
        return date;
    }

    public static void addEasyQuery(QueryWrapper<?> queryWrapper, String name, QueryRuleEnum rule, Object value) {
        if (name == null || value == null || rule == null || oConvertUtils.isEmpty(value)) {
            return;
        }
        name = oConvertUtils.camelToUnderline(name);
        log.debug("---\u9ad8\u7ea7\u67e5\u8be2 Query\u89c4\u5219---field:{} , rule:{} , value:{}", new Object[]{name, rule.getValue(), value});
        switch (rule) {
            case GT: {
                queryWrapper.gt((Object)name, value);
                break;
            }
            case GE: {
                queryWrapper.ge((Object)name, value);
                break;
            }
            case LT: {
                queryWrapper.lt((Object)name, value);
                break;
            }
            case LE: {
                queryWrapper.le((Object)name, value);
                break;
            }
            case EQ: 
            case EQ_WITH_ADD: {
                queryWrapper.eq((Object)name, value);
                break;
            }
            case NE: {
                queryWrapper.ne((Object)name, value);
                break;
            }
            case IN: {
                if (value instanceof String) {
                    queryWrapper.in((Object)name, (Object[])value.toString().split(COMMA));
                    break;
                }
                if (value instanceof String[]) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                if (value.getClass().isArray()) {
                    queryWrapper.in((Object)name, (Object[])value);
                    break;
                }
                queryWrapper.in((Object)name, new Object[]{value});
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)name, value);
                break;
            }
            case LEFT_LIKE: {
                queryWrapper.likeLeft((Object)name, value);
                break;
            }
            case NOT_LEFT_LIKE: {
                queryWrapper.notLikeLeft((Object)name, value);
                break;
            }
            case RIGHT_LIKE: {
                queryWrapper.likeRight((Object)name, value);
                break;
            }
            case NOT_RIGHT_LIKE: {
                queryWrapper.notLikeRight((Object)name, value);
                break;
            }
            case LIKE_WITH_OR: {
                String nameFinal = name;
                Object[] vals = value instanceof String ? value.toString().split(COMMA) : (value instanceof String[] ? (Object[])value : (value.getClass().isArray() ? (Object[])value : new Object[]{value}));
                queryWrapper.and(j -> {
                    log.info("---\u67e5\u8be2\u8fc7\u6ee4\u5668\uff0cQuery\u89c4\u5219---field:{}, rule:{}, value:{}", new Object[]{nameFinal, "like", vals[0]});
                    j = (QueryWrapper)j.like((Object)nameFinal, vals[0]);
                    for (int k = 1; k < vals.length; ++k) {
                        j = (QueryWrapper)((QueryWrapper)j.or()).like((Object)nameFinal, vals[k]);
                        log.info("---\u67e5\u8be2\u8fc7\u6ee4\u5668\uff0cQuery\u89c4\u5219 .or()---field:{}, rule:{}, value:{}", new Object[]{nameFinal, "like", vals[k]});
                    }
                });
                break;
            }
            default: {
                log.info("--\u67e5\u8be2\u89c4\u5219\u672a\u5339\u914d\u5230---");
            }
        }
    }

    private static boolean judgedIsUselessField(String name) {
        return "class".equals(name) || "ids".equals(name) || "page".equals(name) || "rows".equals(name);
    }

    public static Map<String, SysPermissionDataRuleModel> getRuleMap() {
        HashMap<String, SysPermissionDataRuleModel> ruleMap = new HashMap<String, SysPermissionDataRuleModel>(5);
        List<SysPermissionDataRuleModel> list = null;
        try {
            list = JeecgDataAutorUtils.loadDataSearchConditon();
        }
        catch (Exception e) {
            log.error("\u6839\u636erequest\u5bf9\u8c61\u83b7\u53d6\u6743\u9650\u6570\u636e\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5b9a\u65f6\u4efb\u52a1\u4e2d\u6267\u884c\u7684\u3002", (Throwable)e);
        }
        if (list != null && list.size() > 0) {
            if (list.get(0) == null) {
                return ruleMap;
            }
            for (SysPermissionDataRuleModel rule : list) {
                String column = rule.getRuleColumn();
                if (QueryRuleEnum.SQL_RULES.getValue().equals(rule.getRuleConditions())) {
                    column = SQL_RULES_COLUMN + rule.getId();
                }
                ruleMap.put(column, rule);
            }
        }
        return ruleMap;
    }

    private static void addRuleToQueryWrapper(SysPermissionDataRuleModel dataRule, String name, Class propertyType, QueryWrapper<?> queryWrapper) {
        QueryRuleEnum rule = QueryRuleEnum.getByValue(dataRule.getRuleConditions());
        if (rule.equals((Object)QueryRuleEnum.IN) && !propertyType.equals(String.class)) {
            String[] values = dataRule.getRuleValue().split(COMMA);
            Object[] objs = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                objs[i] = NumberUtils.parseNumber((String)values[i], (Class)propertyType);
            }
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, objs);
        } else if (propertyType.equals(String.class)) {
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, QueryGenerator.converRuleValue(dataRule.getRuleValue()));
        } else if (propertyType.equals(Date.class)) {
            String dateStr = QueryGenerator.converRuleValue(dataRule.getRuleValue());
            int length = 10;
            if (dateStr.length() == length) {
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, DateUtils.str2Date(dateStr, DateUtils.date_sdf.get()));
            } else {
                QueryGenerator.addEasyQuery(queryWrapper, name, rule, DateUtils.str2Date(dateStr, DateUtils.datetimeFormat.get()));
            }
        } else {
            QueryGenerator.addEasyQuery(queryWrapper, name, rule, NumberUtils.parseNumber((String)QueryGenerator.converRuleValue(dataRule.getRuleValue()), (Class)propertyType));
        }
    }

    public static String converRuleValue(String ruleValue) {
        String value = JwtUtil.getUserSystemData(ruleValue, null);
        return value != null ? value : ruleValue;
    }

    public static String trimSingleQuote(String ruleValue) {
        if (oConvertUtils.isEmpty(ruleValue)) {
            return "";
        }
        if (ruleValue.startsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(1);
        }
        if (ruleValue.endsWith(SQL_SQ)) {
            ruleValue = ruleValue.substring(0, ruleValue.length() - 1);
        }
        return ruleValue;
    }

    public static String getSqlRuleValue(String sqlRule) {
        try {
            Set<String> varParams = QueryGenerator.getSqlRuleParams(sqlRule);
            if (varParams == null || varParams.isEmpty()) {
                return sqlRule;
            }
            for (String var : varParams) {
                String tempValue = QueryGenerator.converRuleValue(var);
                sqlRule = sqlRule.replace("#{" + var + "}", tempValue);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sqlRule;
    }

    public static Set<String> getSqlRuleParams(String sql) {
        if (oConvertUtils.isEmpty(sql)) {
            return null;
        }
        HashSet<String> varParams = new HashSet<String>();
        String regex = "#\\{\\[*\\w+]*}";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            String var = m.group();
            varParams.add(var.substring(var.indexOf("{") + 1, var.indexOf("}")));
        }
        return varParams;
    }

    public static String getSingleQueryConditionSql(String field, String alias, Object value, boolean isString) {
        return SqlConcatUtil.getSingleQueryConditionSql(field, alias, value, isString, null);
    }

    public static String installAuthJdbc(Class<?> clazz) {
        StringBuffer sb = new StringBuffer();
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors(clazz);
        String sqlAnd = " and ";
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty(c) || !c.startsWith(SQL_RULES_COLUMN)) continue;
            sb.append(sqlAnd + QueryGenerator.getSqlRuleValue(ruleMap.get(c).getRuleValue()));
        }
        for (int i = 0; i < origDescriptors.length; ++i) {
            String column;
            String name = origDescriptors[i].getName();
            if (QueryGenerator.judgedIsUselessField(name) || !ruleMap.containsKey(name) || (column = ReflectHelper.getTableFieldName(clazz, name)) == null) continue;
            SysPermissionDataRuleModel dataRule = ruleMap.get(name);
            QueryRuleEnum rule = QueryRuleEnum.getByValue(dataRule.getRuleConditions());
            Class<?> propType = origDescriptors[i].getPropertyType();
            boolean isString = propType.equals(String.class);
            Object value = isString || Date.class.equals(propType) ? QueryGenerator.converRuleValue(dataRule.getRuleValue()) : NumberUtils.parseNumber((String)dataRule.getRuleValue(), propType);
            String filedSql = SqlConcatUtil.getSingleSqlByRule(rule, oConvertUtils.camelToUnderline(column), value, isString);
            sb.append(sqlAnd + filedSql);
        }
        log.info("query auth sql is:" + sb.toString());
        return sb.toString();
    }

    public static void installAuthMplus(QueryWrapper<?> queryWrapper, Class<?> clazz) {
        Map<String, SysPermissionDataRuleModel> ruleMap = QueryGenerator.getRuleMap();
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors(clazz);
        for (String c : ruleMap.keySet()) {
            if (!oConvertUtils.isNotEmpty(c) || !c.startsWith(SQL_RULES_COLUMN)) continue;
            queryWrapper.and(i -> i.apply(QueryGenerator.getSqlRuleValue(((SysPermissionDataRuleModel)ruleMap.get(c)).getRuleValue()), new Object[0]));
        }
        for (int i2 = 0; i2 < origDescriptors.length; ++i2) {
            String column;
            String name = origDescriptors[i2].getName();
            if (QueryGenerator.judgedIsUselessField(name) || (column = ReflectHelper.getTableFieldName(clazz, name)) == null || !ruleMap.containsKey(name)) continue;
            QueryGenerator.addRuleToQueryWrapper(ruleMap.get(name), column, origDescriptors[i2].getPropertyType(), queryWrapper);
        }
    }

    public static String convertSystemVariables(String sql) {
        return QueryGenerator.getSqlRuleValue(sql);
    }

    private static String getDbType() {
        return CommonUtils.getDatabaseType();
    }

    private static String specialStrConvert(String value) {
        if ("MYSQL".equals(QueryGenerator.getDbType()) || "MARIADB".equals(QueryGenerator.getDbType())) {
            String[] specialStr;
            for (String str : specialStr = LIKE_MYSQL_SPECIAL_STRS.split(COMMA)) {
                if (value.indexOf(str) == -1) continue;
                value = value.replace(str, "\\" + str);
            }
        }
        return value;
    }
}

