/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.exception;

import cn.hutool.core.util.ObjectUtil;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.jeecg.common.api.dto.LogDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.enums.ClientTerminalTypeEnum;
import org.jeecg.common.enums.SentinelErrorInfoEnum;
import org.jeecg.common.exception.JeecgBoot401Exception;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.exception.JeecgCloudException;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.BrowserUtils;
import org.jeecg.common.util.IpUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class JeecgBootExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(JeecgBootExceptionHandler.class);
    @Resource
    BaseCommonService baseCommonService;

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> handleValidationExceptions(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error("\u6821\u9a8c\u5931\u8d25\uff01" + e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(",")));
    }

    @ExceptionHandler(value={JeecgBootException.class})
    public Result<?> handleJeecgBootException(JeecgBootException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog(e);
        return Result.error(e.getErrCode(), e.getMessage());
    }

    @ExceptionHandler(value={JeecgBootBizTipException.class})
    public Result<?> handleJeecgBootBizTipException(JeecgBootBizTipException e) {
        log.error(e.getMessage());
        return Result.error(e.getErrCode(), e.getMessage());
    }

    @ExceptionHandler(value={JeecgCloudException.class})
    public Result<?> handleJeecgCloudException(JeecgCloudException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value={JeecgBoot401Exception.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Result<?> handleJeecgBoot401Exception(JeecgBoot401Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog(e);
        return new Result(401, e.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Result<?> handlerNoFoundException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog(e);
        return Result.error(404, "\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result<?> handleDuplicateKeyException(DuplicateKeyException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55");
    }

    @ExceptionHandler(value={UnauthorizedException.class, AuthorizationException.class})
    public Result<?> handleAuthorizationException(AuthorizationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.noauth("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01");
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        Throwable throwable = e.getCause();
        SentinelErrorInfoEnum errorInfoEnum = SentinelErrorInfoEnum.getErrorByException((Throwable)throwable);
        if (ObjectUtil.isNotEmpty((Object)errorInfoEnum)) {
            return Result.error(errorInfoEnum.getError());
        }
        this.addSysLog(e);
        return Result.error("\u64cd\u4f5c\u5931\u8d25\uff0c" + e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u4e0d\u652f\u6301");
        sb.append(e.getMethod());
        sb.append("\u8bf7\u6c42\u65b9\u6cd5\uff0c");
        sb.append("\u652f\u6301\u4ee5\u4e0b");
        String[] methods = e.getSupportedMethods();
        if (methods != null) {
            for (String str : methods) {
                sb.append(str);
                sb.append("\u3001");
            }
        }
        log.error(sb.toString(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error(405, sb.toString());
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result<?> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa10MB\u9650\u5236, \u8bf7\u538b\u7f29\u6216\u964d\u4f4e\u6587\u4ef6\u8d28\u91cf! ");
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public Result<?> handleDataIntegrityViolationException(DataIntegrityViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error("\u6267\u884c\u6570\u636e\u5e93\u5f02\u5e38,\u8fdd\u53cd\u4e86\u5b8c\u6574\u6027\u4f8b\u5982\uff1a\u8fdd\u53cd\u60df\u4e00\u7ea6\u675f\u3001\u8fdd\u53cd\u975e\u7a7a\u9650\u5236\u3001\u5b57\u6bb5\u5185\u5bb9\u8d85\u51fa\u957f\u5ea6\u7b49");
    }

    @ExceptionHandler(value={PoolException.class})
    public Result<?> handlePoolException(PoolException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.addSysLog((Throwable)e);
        return Result.error("Redis \u8fde\u63a5\u5f02\u5e38!");
    }

    @ExceptionHandler(value={JeecgSqlInjectionException.class})
    public Result<?> handleSQLException(Exception exception) {
        boolean hasSensitiveInformation;
        String msg = exception.getMessage().toLowerCase();
        String extractvalue = "extractvalue";
        String updatexml = "updatexml";
        boolean bl = hasSensitiveInformation = msg.indexOf("extractvalue") >= 0 || msg.indexOf("updatexml") >= 0;
        if (msg != null && hasSensitiveInformation) {
            log.error("\u6821\u9a8c\u5931\u8d25\uff0c\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669\uff01{}", (Object)msg);
            return Result.error("\u6821\u9a8c\u5931\u8d25\uff0c\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669\uff01");
        }
        this.addSysLog(exception);
        return Result.error("\u6821\u9a8c\u5931\u8d25\uff0c\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669\uff01" + msg);
    }

    private void addSysLog(Throwable e) {
        LoginUser sysUser;
        LogDTO log = new LogDTO();
        log.setLogType(4);
        log.setLogContent(e.getClass().getName() + ":" + e.getMessage());
        log.setRequestParam(ExceptionUtils.getStackTrace((Throwable)e));
        HttpServletRequest request = null;
        try {
            request = SpringContextUtils.getHttpServletRequest();
        }
        catch (NullPointerException | BeansException throwable) {
            // empty catch block
        }
        if (null != request) {
            Map parameterMap = request.getParameterMap();
            if (!CollectionUtils.isEmpty((Map)parameterMap)) {
                log.setMethod(oConvertUtils.mapToString(request.getParameterMap()));
            }
            log.setRequestUrl(request.getRequestURI());
            log.setIp(IpUtils.getIpAddr(request));
            if (BrowserUtils.isDesktop(request)) {
                log.setClientType(ClientTerminalTypeEnum.PC.getKey());
            } else {
                log.setClientType(ClientTerminalTypeEnum.APP.getKey());
            }
        }
        if ((sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal()) != null) {
            log.setUserid(sysUser.getUsername());
            log.setUsername(sysUser.getRealname());
        }
        this.baseCommonService.addLog(log);
    }
}

