/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.es;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
@ConditionalOnProperty(prefix="jeecg.elasticsearch", name={"cluster-nodes"})
public class JeecgElasticsearchTemplate {
    private static final Logger log = LoggerFactory.getLogger(JeecgElasticsearchTemplate.class);
    private String baseUrl;
    private final String FORMAT_JSON = "format=json";
    private String version = null;
    public static final int ES_MAX_SIZE = 10000;
    public static final String IE_SEVEN = "7";
    public static final String URL_NOT_FOUND = "404 Not Found";

    public JeecgElasticsearchTemplate(@Value(value="${jeecg.elasticsearch.cluster-nodes}") String baseUrl, @Value(value="${jeecg.elasticsearch.check-enabled}") boolean checkEnabled) {
        log.debug("JeecgElasticsearchTemplate BaseURL\uff1a" + baseUrl);
        if (StringUtils.isNotEmpty((CharSequence)baseUrl)) {
            this.baseUrl = baseUrl;
            if (checkEnabled) {
                try {
                    this.getElasticsearchVersion();
                    log.info("ElasticSearch \u670d\u52a1\u8fde\u63a5\u6210\u529f");
                    log.info("ElasticSearch version: " + this.version);
                }
                catch (Exception e) {
                    this.version = "";
                    log.warn("ElasticSearch \u670d\u52a1\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u914d\u7f6e\u672a\u901a\u8fc7\u3002\u53ef\u80fd\u662fBaseURL\u672a\u914d\u7f6e\u6216\u914d\u7f6e\u6709\u8bef\uff0c\u4e5f\u53ef\u80fd\u662fElasticsearch\u670d\u52a1\u672a\u542f\u52a8\u3002\u63a5\u4e0b\u6765\u5c06\u4f1a\u62d2\u7edd\u6267\u884c\u4efb\u4f55\u65b9\u6cd5\uff01");
                }
            }
        }
    }

    private void getElasticsearchVersion() {
        String url;
        JSONObject result;
        if (this.version == null && (result = RestUtil.get(url = this.getBaseUrl().toString())) != null) {
            JSONObject v = result.getJSONObject("version");
            this.version = v.getString("number");
        }
    }

    public StringBuilder getBaseUrl(String indexName, String typeName) {
        typeName = typeName.trim().toLowerCase();
        return this.getBaseUrl(indexName).append("/").append(typeName);
    }

    public StringBuilder getBaseUrl(String indexName) {
        indexName = indexName.trim().toLowerCase();
        return this.getBaseUrl().append("/").append(indexName);
    }

    public StringBuilder getBaseUrl() {
        return new StringBuilder("http://").append(this.baseUrl);
    }

    private <T> ResponseEntity<T> cat(String urlAfter, Class<T> responseType) {
        String url = this.getBaseUrl().append("/_cat").append(urlAfter).append("?").append("format=json").toString();
        return RestUtil.request(url, HttpMethod.GET, null, null, null, responseType);
    }

    public JSONArray getIndices() {
        return this.getIndices(null);
    }

    public JSONArray getIndices(String indexName) {
        StringBuilder urlAfter = new StringBuilder("/indices");
        if (!StringUtils.isEmpty((CharSequence)indexName)) {
            urlAfter.append("/").append(indexName.trim().toLowerCase());
        }
        return (JSONArray)this.cat(urlAfter.toString(), JSONArray.class).getBody();
    }

    public boolean indexExists(String indexName) {
        try {
            JSONArray array = this.getIndices(indexName);
            return array != null;
        }
        catch (HttpClientErrorException ex) {
            if (HttpStatus.NOT_FOUND == ex.getStatusCode()) {
                return false;
            }
            throw ex;
        }
    }

    public JSONObject getDataById(String indexName, String typeName, String dataId) {
        String url = this.getBaseUrl(indexName, typeName).append("/").append(dataId).toString();
        log.info("url:" + url);
        JSONObject result = RestUtil.get(url);
        boolean found = result.getBoolean("found");
        if (found) {
            return result.getJSONObject("_source");
        }
        return null;
    }

    public boolean createIndex(String indexName) {
        String url = this.getBaseUrl(indexName).toString();
        try {
            return RestUtil.put(url).getBoolean("acknowledged");
        }
        catch (HttpClientErrorException ex) {
            if (HttpStatus.BAD_REQUEST == ex.getStatusCode()) {
                log.warn("\u7d22\u5f15\u521b\u5efa\u5931\u8d25\uff1a" + indexName + " \u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u521b\u5efa");
            } else {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public boolean removeIndex(String indexName) {
        String url = this.getBaseUrl(indexName).toString();
        try {
            return RestUtil.delete(url).getBoolean("acknowledged");
        }
        catch (HttpClientErrorException ex) {
            if (HttpStatus.NOT_FOUND == ex.getStatusCode()) {
                log.warn("\u7d22\u5f15\u5220\u9664\u5931\u8d25\uff1a" + indexName + " \u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u5220\u9664");
            } else {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public JSONObject getIndexMapping(String indexName, String typeName) {
        String url = this.getBaseUrl(indexName, typeName).append("/_mapping?").append("format=json").toString();
        this.getElasticsearchVersion();
        if (oConvertUtils.isNotEmpty(this.version) && this.version.startsWith(IE_SEVEN)) {
            url = url + "&include_type_name=true";
        }
        log.info("getIndexMapping-url:" + url);
        try {
            return RestUtil.get(url);
        }
        catch (HttpClientErrorException e) {
            String message = e.getMessage();
            if (message != null && message.contains(URL_NOT_FOUND)) {
                return null;
            }
            throw e;
        }
    }

    public <T> Map<String, T> getIndexMappingFormat(String indexName, String typeName, Class<T> clazz) {
        JSONObject mapping = this.getIndexMapping(indexName, typeName);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (mapping == null) {
            return map;
        }
        JSONObject properties = mapping.getJSONObject(indexName).getJSONObject("mappings").getJSONObject(typeName).getJSONObject("properties");
        for (String key : properties.keySet()) {
            Object entity = properties.getJSONObject(key).toJavaObject(clazz);
            map.put(key, entity);
        }
        return map;
    }

    public boolean save(String indexName, String typeName, String dataId, JSONObject data) {
        return this.saveOrUpdate(indexName, typeName, dataId, data);
    }

    public boolean update(String indexName, String typeName, String dataId, JSONObject data) {
        return this.saveOrUpdate(indexName, typeName, dataId, data);
    }

    public boolean saveOrUpdate(String indexName, String typeName, String dataId, JSONObject data) {
        String url = this.getBaseUrl(indexName, typeName).append("/").append(dataId).append("?refresh=wait_for").toString();
        try {
            Set keys = data.keySet();
            ArrayList<String> emptyKeys = new ArrayList<String>(keys.size());
            for (String key : keys) {
                String value = data.getString(key);
                if (oConvertUtils.isEmpty(value) || "[]".equals(value)) {
                    emptyKeys.add(key);
                }
                if (!oConvertUtils.isNotEmpty(value) || value.indexOf("[{") == -1) continue;
                emptyKeys.add(key);
                log.info("-------\u5254\u9664\u4e0a\u4f20\u63a7\u4ef6\u5b57\u6bb5------------key: " + key);
            }
            for (String key : emptyKeys) {
                data.remove((Object)key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String result = RestUtil.put(url, data).getString("result");
            return "created".equals(result) || "updated".equals(result);
        }
        catch (Exception e) {
            log.error(e.getMessage() + "\n-- url: " + url + "\n-- data: " + data.toJSONString());
            return false;
        }
    }

    public boolean saveBatch(String indexName, String typeName, JSONArray dataList) {
        String url = this.getBaseUrl().append("/_bulk").append("?refresh=wait_for").toString();
        StringBuilder bodySb = new StringBuilder();
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject data = dataList.getJSONObject(i);
            String id = data.getString("id");
            JSONObject action = new JSONObject();
            JSONObject actionInfo = new JSONObject();
            actionInfo.put("_id", (Object)id);
            actionInfo.put("_index", (Object)indexName);
            actionInfo.put("_type", (Object)typeName);
            action.put("create", (Object)actionInfo);
            bodySb.append(action.toJSONString()).append("\n");
            data.remove((Object)"id");
            bodySb.append(data.toJSONString()).append("\n");
        }
        System.out.println("+-+-+-: bodySb.toString(): " + bodySb.toString());
        HttpHeaders headers = RestUtil.getHeaderApplicationJson();
        RestUtil.request(url, HttpMethod.PUT, headers, null, bodySb, JSONObject.class);
        return true;
    }

    public boolean delete(String indexName, String typeName, String dataId) {
        String url = this.getBaseUrl(indexName, typeName).append("/").append(dataId).toString();
        try {
            return "deleted".equals(RestUtil.delete(url).getString("result"));
        }
        catch (HttpClientErrorException ex) {
            if (HttpStatus.NOT_FOUND == ex.getStatusCode()) {
                return false;
            }
            throw ex;
        }
    }

    public JSONObject search(String indexName, String typeName, JSONObject queryObject) {
        String url = this.getBaseUrl(indexName, typeName).append("/_search").toString();
        log.info("url:" + url + " ,search: " + queryObject.toJSONString());
        JSONObject res = RestUtil.post(url, queryObject);
        log.info("url:" + url + " ,return res: \n" + res.toJSONString());
        return res;
    }

    public JSONObject buildQuery(List<String> source, JSONObject query, int from, int size) {
        JSONObject json = new JSONObject();
        if (source != null) {
            json.put("_source", source);
        }
        json.put("query", (Object)query);
        json.put("from", (Object)from);
        json.put("size", (Object)size);
        return json;
    }

    public JSONObject buildBoolQuery(JSONArray must, JSONArray mustNot, JSONArray should) {
        JSONObject bool = new JSONObject();
        if (must != null) {
            bool.put("must", (Object)must);
        }
        if (mustNot != null) {
            bool.put("must_not", (Object)mustNot);
        }
        if (should != null) {
            bool.put("should", (Object)should);
        }
        JSONObject json = new JSONObject();
        json.put("bool", (Object)bool);
        return json;
    }

    public JSONObject buildQueryString(String field, String ... args) {
        if (field == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(field).append(":(");
        if (args != null) {
            for (String arg : args) {
                sb.append(arg).append(" ");
            }
        }
        sb.append(")");
        return this.buildQueryString(sb.toString());
    }

    public JSONObject buildQueryString(String query) {
        JSONObject queryString = new JSONObject();
        queryString.put("query", (Object)query);
        JSONObject json = new JSONObject();
        json.put("query_string", (Object)queryString);
        return json;
    }

    public JSONObject buildRangeQuery(String field, Object min, Object max, boolean containMin, boolean containMax) {
        JSONObject inner = new JSONObject();
        if (min != null) {
            if (containMin) {
                inner.put("gte", min);
            } else {
                inner.put("gt", min);
            }
        }
        if (max != null) {
            if (containMax) {
                inner.put("lte", max);
            } else {
                inner.put("lt", max);
            }
        }
        JSONObject range = new JSONObject();
        range.put(field, (Object)inner);
        JSONObject json = new JSONObject();
        json.put("range", (Object)range);
        return json;
    }
}

