/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.adapter.files;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Source;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jeecg.modules.jmreport.calcite.adapter.JmCalciteDataConverter;

public class JmJsonEnumerator
implements Enumerator<Object[]> {
    private final Enumerator<@Nullable Object[]> enumerator;

    public JmJsonEnumerator(List<? extends @Nullable Object> list) {
        ArrayList<@Nullable Object[]> objs = new ArrayList<Object[]>();
        for (Object object : list) {
            if (object instanceof Collection) {
                List tmp = (List)object;
                objs.add(tmp.toArray());
                continue;
            }
            if (object instanceof Map) {
                objs.add(((LinkedHashMap)object).values().toArray());
                continue;
            }
            objs.add(new Object[]{object});
        }
        this.enumerator = Linq4j.enumerator(objs);
    }

    public static JmCalciteDataConverter deduceRowType(RelDataTypeFactory typeFactory, Source source) {
        List<Object> list;
        ObjectMapper objectMapper = new ObjectMapper();
        LinkedHashMap jsonFieldMap = new LinkedHashMap(1);
        Object jsonObj = null;
        try {
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            jsonObj = "file".equals(source.protocol()) && source.file().exists() ? objectMapper.readValue(source.file(), Object.class) : (Arrays.asList("http", "https", "ftp").contains(source.protocol()) ? objectMapper.readValue(source.url(), Object.class) : objectMapper.readValue(source.reader(), Object.class));
        }
        catch (MismatchedInputException e) {
            if (!e.getMessage().contains("No content")) {
                throw new RuntimeException("Couldn't read " + source, e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read " + source, e);
        }
        if (jsonObj == null) {
            list = new ArrayList();
            jsonFieldMap.put("EmptyFileHasNoColumns", Boolean.TRUE);
        } else if (jsonObj instanceof Collection) {
            list = (List)jsonObj;
            jsonFieldMap = (LinkedHashMap)list.get(0);
        } else if (jsonObj instanceof Map) {
            jsonFieldMap = (LinkedHashMap)jsonObj;
            list = new ArrayList(((LinkedHashMap)jsonObj).values());
        } else {
            jsonFieldMap.put("line", jsonObj);
            list = new ArrayList();
            list.add(0, jsonObj);
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>(jsonFieldMap.size());
        ArrayList<String> names = new ArrayList<String>(jsonFieldMap.size());
        for (Object key : jsonFieldMap.keySet()) {
            Object val = jsonFieldMap.get(key);
            if (null == val) {
                val = "";
            }
            RelDataType type = typeFactory.createJavaType(val.getClass());
            names.add(key.toString());
            types.add(type);
        }
        RelDataType relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return new JmCalciteDataConverter(relDataType, list);
    }

    public Object[] current() {
        return (Object[])this.enumerator.current();
    }

    public boolean moveNext() {
        return this.enumerator.moveNext();
    }

    public void reset() {
        this.enumerator.reset();
    }

    public void close() {
        this.enumerator.close();
    }
}

