/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.adapter.files;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jeecg.modules.jmreport.calcite.adapter.files.JmCsvScannableTable;
import org.jeecg.modules.jmreport.calcite.adapter.files.JmExcelScannableTable;
import org.jeecg.modules.jmreport.calcite.adapter.files.JmJsonScannableTable;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.desreport.model.FilesDsTable;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmFilesSchema
extends AbstractSchema {
    private static final Logger log = LoggerFactory.getLogger(JmFilesSchema.class);
    private static final List<String> SUPPORT_FILE_EXT = Arrays.asList("csv", "json", "xls", "xlsx");
    private final File directoryFile;
    private Map<String, Table> tableMap;
    private List<FilesDsTable> filesDsTables = new ArrayList<FilesDsTable>();

    public JmFilesSchema(File directoryFile, JmreportDynamicDataSourceVo operand) {
        this.directoryFile = directoryFile;
        String dbUrl = operand.getDbUrl();
        if (OkConvertUtils.isNotEmpty((Object)dbUrl)) {
            this.filesDsTables = JSONArray.parseArray((String)dbUrl, FilesDsTable.class);
        }
    }

    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            this.tableMap = this.createTableMap();
        }
        return this.tableMap;
    }

    private Map<String, Table> createTableMap() {
        Source baseSource = Sources.of((File)this.directoryFile);
        File[] files = this.directoryFile.listFiles((dir, name) -> {
            String extension = FilenameUtils.getExtension((String)name);
            return SUPPORT_FILE_EXT.contains(extension);
        });
        if (files == null) {
            log.warn("directory {} not found", (Object)this.directoryFile);
            files = new File[]{};
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (files.length < 1 || this.filesDsTables.isEmpty()) {
            return builder.build();
        }
        Map<String, List<FilesDsTable>> filesDsTableMap = this.filesDsTables.stream().collect(Collectors.groupingBy(FilesDsTable::getFileName));
        for (File file : files) {
            Source sourceSansExcel;
            Source sourceSansCsv;
            String fileName = file.getName();
            List<FilesDsTable> currentFileTables = filesDsTableMap.get(fileName);
            if (OkConvertUtils.isEmpty(currentFileTables)) continue;
            Source source = Sources.of((File)file);
            Source sourceSansGz = source.trim(".gz");
            Source sourceSansJson = sourceSansGz.trimOrNull(".json");
            if (sourceSansJson != null) {
                JmJsonScannableTable table = new JmJsonScannableTable(source);
                builder.put((Object)JmFilesSchema.trimTablePrefix(currentFileTables.get(0).getName()), (Object)table);
            }
            if ((sourceSansCsv = sourceSansGz.trimOrNull(".csv")) != null) {
                JmCsvScannableTable table = new JmCsvScannableTable(source, null);
                builder.put((Object)JmFilesSchema.trimTablePrefix(currentFileTables.get(0).getName()), (Object)table);
            }
            if ((sourceSansExcel = sourceSansGz.trimOrNull(".xls")) == null) {
                sourceSansExcel = sourceSansGz.trimOrNull(".xlsx");
            }
            if (sourceSansExcel == null || !file.exists()) continue;
            try (Workbook wb = WorkbookFactory.create((File)file);){
                String fileBaseName = sourceSansExcel.relative(baseSource).path();
                for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                    Sheet sheet = wb.getSheetAt(i);
                    JmExcelScannableTable table = new JmExcelScannableTable(sheet);
                    String tableName = sheet.getSheetName();
                    if (fileBaseName.contains("_")) {
                        String[] split = fileBaseName.split("_");
                        tableName = tableName + "_" + split[split.length - 1];
                    } else {
                        tableName = tableName + "_" + fileBaseName;
                    }
                    String finalTableName = tableName;
                    Optional<FilesDsTable> hitTableOp = currentFileTables.stream().filter(tb -> tb.getName().contains(finalTableName)).findFirst();
                    hitTableOp.ifPresent(arg_0 -> JmFilesSchema.lambda$createTableMap$2(builder, (Table)table, arg_0));
                }
            }
            catch (IOException e) {
                log.error("\u6784\u9020excel\u6587\u4ef6\u6570\u636e\u96c6\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
        }
        return builder.build();
    }

    private static String trim(String s, String suffix) {
        String trimmed = JmFilesSchema.trimOrNull(s, suffix);
        return trimmed != null ? trimmed : s;
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    private static String trimTablePrefix(String tableName) {
        if (OkConvertUtils.isEmpty((Object)tableName)) {
            return tableName;
        }
        if (tableName.startsWith("jmf")) {
            return tableName.substring("jmf".length() + 1);
        }
        return tableName;
    }

    private static /* synthetic */ void lambda$createTableMap$2(ImmutableMap.Builder builder, Table table, FilesDsTable filesDsTable) {
        builder.put((Object)JmFilesSchema.trimTablePrefix(filesDsTable.getName()), (Object)table);
    }
}

